/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap;

import androidx.compose.runtime.external.kotlinx.collections.immutable.PersistentMap;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMap;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilderEntries;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilderKeys;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilderValues;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.TrieNode;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.DeltaCounter;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.MutabilityOwnership;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.collections.AbstractMutableMap;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentHashMapBuilder<K, V>
extends AbstractMutableMap<K, V>
implements PersistentMap.Builder<K, V> {
    @NotNull
    private PersistentHashMap<K, V> map;
    @NotNull
    private MutabilityOwnership ownership;
    @NotNull
    private TrieNode<K, V> node;
    @Nullable
    private V operationResult;
    private int modCount;
    private int size;
    public static final int $stable = 8;

    public PersistentHashMapBuilder(@NotNull PersistentHashMap<K, V> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.map = map2;
        this.ownership = new MutabilityOwnership();
        this.node = this.map.getNode$runtime();
        this.size = this.map.size();
    }

    @NotNull
    public final MutabilityOwnership getOwnership() {
        return this.ownership;
    }

    protected final void setOwnership(@NotNull MutabilityOwnership mutabilityOwnership) {
        Intrinsics.checkNotNullParameter((Object)mutabilityOwnership, (String)"<set-?>");
        this.ownership = mutabilityOwnership;
    }

    @NotNull
    public final TrieNode<K, V> getNode$runtime() {
        return this.node;
    }

    public final void setOperationResult$runtime(@Nullable V v) {
        this.operationResult = v;
    }

    public final int getModCount$runtime() {
        return this.modCount;
    }

    public final void setModCount$runtime(int n) {
        this.modCount = n;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int value2) {
        this.size = value2;
        int n = this.modCount;
        this.modCount = n + 1;
    }

    @Override
    @NotNull
    public PersistentHashMap<K, V> build() {
        PersistentHashMap<K, V> persistentHashMap;
        if (this.node == this.map.getNode$runtime()) {
            persistentHashMap = this.map;
        } else {
            this.ownership = new MutabilityOwnership();
            persistentHashMap = new PersistentHashMap<K, V>(this.node, this.size());
        }
        this.map = persistentHashMap;
        return this.map;
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        return (Set)((Object)new PersistentHashMapBuilderEntries(this));
    }

    @NotNull
    public Set<K> getKeys() {
        return new PersistentHashMapBuilderKeys(this);
    }

    @NotNull
    public Collection<V> getValues() {
        return new PersistentHashMapBuilderValues(this);
    }

    @Override
    public boolean containsKey(K key2) {
        K k = key2;
        return this.node.containsKey(k != null ? k.hashCode() : 0, key2, 0);
    }

    @Override
    @Nullable
    public V get(K key2) {
        K k = key2;
        return this.node.get(k != null ? k.hashCode() : 0, key2, 0);
    }

    @Override
    @Nullable
    public V put(K key2, V value2) {
        this.operationResult = null;
        K k = key2;
        this.node = this.node.mutablePut(k != null ? k.hashCode() : 0, key2, value2, 0, this);
        return this.operationResult;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        PersistentHashMap map2;
        Intrinsics.checkNotNullParameter(from, (String)"from");
        PersistentMap persistentMap = from instanceof PersistentHashMap ? (PersistentHashMap)from : null;
        if (persistentMap == null) {
            PersistentHashMapBuilder persistentHashMapBuilder = from instanceof PersistentHashMapBuilder ? (PersistentHashMapBuilder)from : null;
            persistentMap = persistentHashMapBuilder != null ? persistentHashMapBuilder.build() : null;
        }
        if ((map2 = persistentMap) != null) {
            DeltaCounter intersectionCounter = new DeltaCounter(0, 1, null);
            int oldSize = this.size();
            TrieNode trieNode = map2.getNode$runtime();
            Intrinsics.checkNotNull(trieNode, (String)"null cannot be cast to non-null type androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.TrieNode<K of androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder, V of androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder>");
            this.node = this.node.mutablePutAll(trieNode, 0, intersectionCounter, this);
            int newSize = oldSize + map2.size() - intersectionCounter.getCount();
            if (oldSize != newSize) {
                this.setSize(newSize);
            }
        } else {
            super.putAll(from);
        }
    }

    @Override
    @Nullable
    public V remove(K key2) {
        this.operationResult = null;
        K k = key2;
        TrieNode trieNode = this.node.mutableRemove(k != null ? k.hashCode() : 0, key2, 0, this);
        if (trieNode == null) {
            TrieNode trieNode2 = TrieNode.Companion.getEMPTY$runtime();
            trieNode = trieNode2;
            Intrinsics.checkNotNull((Object)trieNode2, (String)"null cannot be cast to non-null type androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.TrieNode<K of androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder, V of androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder>");
        }
        this.node = trieNode;
        return this.operationResult;
    }

    @Override
    public final boolean remove(Object key2, Object value2) {
        int oldSize = this.size();
        Object object = key2;
        TrieNode trieNode = this.node.mutableRemove(object != null ? object.hashCode() : 0, key2, value2, 0, this);
        if (trieNode == null) {
            TrieNode trieNode2 = TrieNode.Companion.getEMPTY$runtime();
            trieNode = trieNode2;
            Intrinsics.checkNotNull((Object)trieNode2, (String)"null cannot be cast to non-null type androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.TrieNode<K of androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder, V of androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder>");
        }
        this.node = trieNode;
        return oldSize != this.size();
    }

    @Override
    public void clear() {
        TrieNode trieNode = TrieNode.Companion.getEMPTY$runtime();
        Intrinsics.checkNotNull((Object)trieNode, (String)"null cannot be cast to non-null type androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.TrieNode<K of androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder, V of androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder>");
        this.node = trieNode;
        this.setSize(0);
    }
}

