/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList;

import androidx.compose.runtime.PreconditionsKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.PersistentList;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.ObjectRef;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.SmallPersistentVector;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.CommonFunctionsKt;
import androidx.compose.runtime.external.kotlinx.collections.immutable.internal.ListImplementation;
import java.util.Arrays;
import java.util.ListIterator;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nPersistentVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentVector.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector\n+ 2 Preconditions.kt\nandroidx/compose/runtime/PreconditionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,328:1\n34#2,4:329\n1#3:333\n*S KotlinDebug\n*F\n+ 1 PersistentVector.kt\nandroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVector\n*L\n30#1:329,4\n*E\n"})
public final class PersistentVector<E>
extends AbstractPersistentList<E> {
    @NotNull
    private final Object[] root;
    @NotNull
    private final Object[] tail;
    private final int size;
    private final int rootShift;
    public static final int $stable = 8;

    public PersistentVector(@NotNull Object[] root, @NotNull Object[] tail, int size, int rootShift) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)tail, (String)"tail");
        this.root = root;
        this.tail = tail;
        this.size = size;
        this.rootShift = rootShift;
        boolean value$iv = this.size() > 32;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalArgumentException("Trie-based persistent vector should have at least 33 elements, got " + this.size());
        }
        CommonFunctionsKt.assert(this.size() - UtilsKt.rootSize(this.size()) <= RangesKt.coerceAtMost((int)this.tail.length, (int)32));
    }

    public int getSize() {
        return this.size;
    }

    private final int rootSize() {
        return UtilsKt.rootSize(this.size());
    }

    @Override
    @NotNull
    public PersistentList<E> add(E element) {
        int tailSize = this.size() - this.rootSize();
        if (tailSize < 32) {
            Object[] objectArray = Arrays.copyOf(this.tail, 32);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newTail = objectArray;
            newTail[tailSize] = element;
            return new PersistentVector<E>(this.root, newTail, this.size() + 1, this.rootShift);
        }
        Object[] newTail = UtilsKt.presizedBufferWith(element);
        return this.pushFilledTail(this.root, this.tail, newTail);
    }

    private final PersistentVector<E> pushFilledTail(Object[] root, Object[] filledTail, Object[] newTail) {
        if (this.size() >> 5 > 1 << this.rootShift) {
            Object[] newRoot = UtilsKt.presizedBufferWith(root);
            int newRootShift = this.rootShift + 5;
            newRoot = this.pushTail(newRoot, newRootShift, filledTail);
            return new PersistentVector<E>(newRoot, newTail, this.size() + 1, newRootShift);
        }
        Object[] newRoot = this.pushTail(root, this.rootShift, filledTail);
        return new PersistentVector<E>(newRoot, newTail, this.size() + 1, this.rootShift);
    }

    private final Object[] pushTail(Object[] root, int shift, Object[] tail) {
        Object[] objectArray;
        int bufferIndex;
        block3: {
            block2: {
                bufferIndex = UtilsKt.indexSegment(this.size() - 1, shift);
                objectArray = root;
                if (root == null) break block2;
                Object[] objectArray2 = Arrays.copyOf(objectArray, 32);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
                objectArray = objectArray2;
                if (objectArray2 != null) break block3;
            }
            objectArray = new Object[32];
        }
        Object[] newRootNode = objectArray;
        newRootNode[bufferIndex] = shift == 5 ? tail : this.pushTail((Object[])newRootNode[bufferIndex], shift - 5, tail);
        return newRootNode;
    }

    @Override
    @NotNull
    public PersistentList<E> add(int index, E element) {
        ListImplementation.checkPositionIndex$runtime(index, this.size());
        if (index == this.size()) {
            return this.add(element);
        }
        int rootSize = this.rootSize();
        if (index >= rootSize) {
            return this.insertIntoTail(this.root, index - rootSize, element);
        }
        ObjectRef elementCarry = new ObjectRef(null);
        Object[] newRoot = this.insertIntoRoot(this.root, this.rootShift, index, element, elementCarry);
        return this.insertIntoTail(newRoot, 0, elementCarry.getValue());
    }

    private final PersistentVector<E> insertIntoTail(Object[] root, int tailIndex, Object element) {
        int tailSize = this.size() - this.rootSize();
        Object[] objectArray = Arrays.copyOf(this.tail, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newTail = objectArray;
        if (tailSize < 32) {
            ArraysKt.copyInto((Object[])this.tail, (Object[])newTail, (int)(tailIndex + 1), (int)tailIndex, (int)tailSize);
            newTail[tailIndex] = element;
            return new PersistentVector<E>(root, newTail, this.size() + 1, this.rootShift);
        }
        Object lastElement = this.tail[31];
        ArraysKt.copyInto((Object[])this.tail, (Object[])newTail, (int)(tailIndex + 1), (int)tailIndex, (int)(tailSize - 1));
        newTail[tailIndex] = element;
        return this.pushFilledTail(root, newTail, UtilsKt.presizedBufferWith(lastElement));
    }

    private final Object[] insertIntoRoot(Object[] root, int shift, int index, Object element, ObjectRef elementCarry) {
        int bufferIndex = UtilsKt.indexSegment(index, shift);
        if (shift == 0) {
            Object[] objectArray;
            if (bufferIndex == 0) {
                objectArray = new Object[32];
            } else {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
            }
            Object[] newRoot = objectArray;
            ArraysKt.copyInto((Object[])root, (Object[])newRoot, (int)(bufferIndex + 1), (int)bufferIndex, (int)31);
            elementCarry.setValue(root[31]);
            newRoot[bufferIndex] = element;
            return newRoot;
        }
        Object[] objectArray = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newRoot = objectArray;
        int lowerLevelShift = shift - 5;
        Object object = root[bufferIndex];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        newRoot[bufferIndex] = this.insertIntoRoot((Object[])object, lowerLevelShift, index, element, elementCarry);
        for (int i2 = bufferIndex + 1; i2 < 32 && newRoot[i2] != null; ++i2) {
            Object object2 = root[i2];
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            newRoot[i2] = this.insertIntoRoot((Object[])object2, lowerLevelShift, 0, elementCarry.getValue(), elementCarry);
        }
        return newRoot;
    }

    @Override
    @NotNull
    public PersistentList<E> removeAt(int index) {
        ListImplementation.checkElementIndex$runtime(index, this.size());
        int rootSize = this.rootSize();
        if (index >= rootSize) {
            return this.removeFromTailAt(this.root, rootSize, this.rootShift, index - rootSize);
        }
        Object[] newRoot = this.removeFromRootAt(this.root, this.rootShift, index, new ObjectRef(this.tail[0]));
        return this.removeFromTailAt(newRoot, rootSize, this.rootShift, 0);
    }

    private final PersistentList<E> removeFromTailAt(Object[] root, int rootSize, int shift, int index) {
        int tailSize = this.size() - rootSize;
        CommonFunctionsKt.assert(index < tailSize);
        if (tailSize == 1) {
            return this.pullLastBufferFromRoot(root, rootSize, shift);
        }
        Object[] objectArray = Arrays.copyOf(this.tail, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newTail = objectArray;
        if (index < tailSize - 1) {
            ArraysKt.copyInto((Object[])this.tail, (Object[])newTail, (int)index, (int)(index + 1), (int)tailSize);
        }
        newTail[tailSize - 1] = null;
        return new PersistentVector<E>(root, newTail, rootSize + tailSize - 1, shift);
    }

    private final PersistentList<E> pullLastBufferFromRoot(Object[] root, int rootSize, int shift) {
        if (shift == 0) {
            Object[] objectArray;
            if (root.length == 33) {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
            } else {
                objectArray = root;
            }
            Object[] buffer = objectArray;
            return new SmallPersistentVector(buffer);
        }
        ObjectRef tailCarry = new ObjectRef(null);
        Object[] objectArray = this.pullLastBuffer(root, shift, rootSize - 1, tailCarry);
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] newRoot = objectArray;
        Object object = tailCarry.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        Object[] newTail = (Object[])object;
        if (newRoot[1] == null) {
            Object object2 = newRoot[0];
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            Object[] lowerLevelRoot = (Object[])object2;
            return new PersistentVector<E>(lowerLevelRoot, newTail, rootSize, shift - 5);
        }
        return new PersistentVector<E>(newRoot, newTail, rootSize, shift);
    }

    private final Object[] pullLastBuffer(Object[] root, int shift, int index, ObjectRef tailCarry) {
        Object[] newBufferAtIndex;
        Object[] objectArray;
        int bufferIndex = UtilsKt.indexSegment(index, shift);
        if (shift == 5) {
            tailCarry.setValue(root[bufferIndex]);
            objectArray = null;
        } else {
            Object object = root[bufferIndex];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            objectArray = newBufferAtIndex = this.pullLastBuffer((Object[])object, shift - 5, index, tailCarry);
        }
        if (newBufferAtIndex == null && bufferIndex == 0) {
            return null;
        }
        Object[] objectArray2 = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
        Object[] newRoot = objectArray2;
        newRoot[bufferIndex] = newBufferAtIndex;
        return newRoot;
    }

    private final Object[] removeFromRootAt(Object[] root, int shift, int index, ObjectRef tailCarry) {
        int bufferIndex = UtilsKt.indexSegment(index, shift);
        if (shift == 0) {
            Object[] objectArray;
            if (bufferIndex == 0) {
                objectArray = new Object[32];
            } else {
                Object[] objectArray2 = Arrays.copyOf(root, 32);
                objectArray = objectArray2;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
            }
            Object[] newRoot = objectArray;
            ArraysKt.copyInto((Object[])root, (Object[])newRoot, (int)bufferIndex, (int)(bufferIndex + 1), (int)32);
            newRoot[31] = tailCarry.getValue();
            tailCarry.setValue(root[bufferIndex]);
            return newRoot;
        }
        int bufferLastIndex = 31;
        if (root[bufferLastIndex] == null) {
            bufferLastIndex = UtilsKt.indexSegment(this.rootSize() - 1, shift);
        }
        Object[] objectArray = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newRoot = objectArray;
        int lowerLevelShift = shift - 5;
        int i2 = bufferLastIndex;
        int n = bufferIndex + 1;
        if (n <= i2) {
            while (true) {
                Object object = newRoot[i2];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
                newRoot[i2] = this.removeFromRootAt((Object[])object, lowerLevelShift, 0, tailCarry);
                if (i2 == n) break;
                --i2;
            }
        }
        Object object = newRoot[bufferIndex];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
        newRoot[bufferIndex] = this.removeFromRootAt((Object[])object, lowerLevelShift, index, tailCarry);
        return newRoot;
    }

    @Override
    @NotNull
    public PersistentList<E> removeAll(@NotNull Function1<? super E, Boolean> predicate) {
        PersistentList.Builder builder;
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        PersistentList.Builder it = builder = this.builder();
        boolean bl = false;
        ((PersistentVectorBuilder)it).removeAllWithPredicate(predicate);
        return ((PersistentVectorBuilder)builder).build();
    }

    @Override
    @NotNull
    public PersistentVectorBuilder<E> builder() {
        return new PersistentVectorBuilder(this, this.root, this.tail, this.rootShift);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        ListImplementation.checkPositionIndex$runtime(index, this.size());
        return new PersistentVectorIterator<Object>(this.root, this.tail, index, this.size(), this.rootShift / 5 + 1);
    }

    private final Object[] bufferFor(int index) {
        if (this.rootSize() <= index) {
            return this.tail;
        }
        Object[] buffer = this.root;
        for (int shift = this.rootShift; shift > 0; shift -= 5) {
            Object object = buffer[UtilsKt.indexSegment(index, shift)];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            buffer = (Object[])object;
        }
        return buffer;
    }

    @Override
    public E get(int index) {
        ListImplementation.checkElementIndex$runtime(index, this.size());
        Object[] buffer = this.bufferFor(index);
        return (E)buffer[index & 0x1F];
    }

    @Override
    @NotNull
    public PersistentList<E> set(int index, E element) {
        ListImplementation.checkElementIndex$runtime(index, this.size());
        if (this.rootSize() <= index) {
            Object[] objectArray = Arrays.copyOf(this.tail, 32);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newTail = objectArray;
            newTail[index & 0x1F] = element;
            return new PersistentVector<E>(this.root, newTail, this.size(), this.rootShift);
        }
        Object[] newRoot = this.setInRoot(this.root, this.rootShift, index, element);
        return new PersistentVector<E>(newRoot, this.tail, this.size(), this.rootShift);
    }

    private final Object[] setInRoot(Object[] root, int shift, int index, Object e) {
        int bufferIndex = UtilsKt.indexSegment(index, shift);
        Object[] objectArray = Arrays.copyOf(root, 32);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newRoot = objectArray;
        if (shift == 0) {
            newRoot[bufferIndex] = e;
        } else {
            Object object = newRoot[bufferIndex];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            newRoot[bufferIndex] = this.setInRoot((Object[])object, shift - 5, index, e);
        }
        return newRoot;
    }
}

