/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.changelist;

import androidx.compose.runtime.Applier;
import androidx.compose.runtime.RememberManager;
import androidx.compose.runtime.SlotWriter;
import androidx.compose.runtime.changelist.Operation;
import androidx.compose.runtime.changelist.OperationArgContainer;
import androidx.compose.runtime.changelist.OperationsDebugStringFormattable;
import kotlin.Deprecated;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmInline;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operations.kt\nandroidx/compose/runtime/changelist/Operations\n+ 2 ArrayUtils.nonAndroid.kt\nandroidx/compose/runtime/collection/ArrayUtils_nonAndroidKt\n+ 3 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,642:1\n145#1,5:643\n158#1,5:648\n255#1:655\n255#1:656\n334#1,7:663\n325#1,16:670\n356#1:686\n356#1:687\n334#1,7:688\n23#2:653\n23#2:654\n23#2:662\n4658#3,4:657\n1#4:661\n*S KotlinDebug\n*F\n+ 1 Operations.kt\nandroidx/compose/runtime/changelist/Operations\n*L\n123#1:643,5\n124#1:648,5\n212#1:655\n213#1:656\n325#1:663,7\n347#1:670,16\n359#1:686\n362#1:687\n576#1:688,7\n141#1:653\n166#1:654\n295#1:662\n211#1:657,4\n*E\n"})
public final class Operations
extends OperationsDebugStringFormattable {
    @JvmField
    @NotNull
    public Operation[] opCodes = new Operation[16];
    @JvmField
    public int opCodesSize;
    @JvmField
    @NotNull
    public int[] intArgs = new int[16];
    @JvmField
    public int intArgsSize;
    @JvmField
    @NotNull
    public Object[] objectArgs = new Object[16];
    @JvmField
    public int objectArgsSize;
    private int pushedIntMask;
    private int pushedObjectMask;
    public static final int $stable = 8;

    public final int getSize() {
        return this.opCodesSize;
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    public final boolean isNotEmpty() {
        return this.getSize() != 0;
    }

    public final void clear() {
        this.opCodesSize = 0;
        this.intArgsSize = 0;
        ArraysKt.fill((Object[])this.objectArgs, null, (int)0, (int)this.objectArgsSize);
        this.objectArgsSize = 0;
    }

    public final void pushOp(@NotNull Operation operation) {
        Operations this_$iv;
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        if (this.opCodesSize == this.opCodes.length) {
            this.resizeOpCodes();
        }
        Operations operations = this;
        int requiredSize$iv = this.intArgsSize + operation.getInts();
        boolean $i$f$ensureIntArgsSizeAtLeast = false;
        int currentSize$iv = this_$iv.intArgs.length;
        if (requiredSize$iv > currentSize$iv) {
            super.resizeIntArgs(currentSize$iv, requiredSize$iv);
        }
        this_$iv = this;
        requiredSize$iv = this.objectArgsSize + operation.getObjects();
        boolean $i$f$ensureObjectArgsSizeAtLeast = false;
        currentSize$iv = this_$iv.objectArgs.length;
        if (requiredSize$iv > currentSize$iv) {
            this_$iv.resizeObjectArgs(currentSize$iv, requiredSize$iv);
        }
        int n = this.opCodesSize;
        this.opCodesSize = n + 1;
        this.opCodes[n] = operation;
        this.intArgsSize += operation.getInts();
        this.objectArgsSize += operation.getObjects();
    }

    private final int determineNewSize(int currentSize, int requiredSize) {
        int resizeAmount = RangesKt.coerceAtMost((int)currentSize, (int)1024);
        return RangesKt.coerceAtLeast((int)(currentSize + resizeAmount), (int)requiredSize);
    }

    /*
     * WARNING - void declaration
     */
    private final void resizeOpCodes() {
        void startIndex$iv;
        void destinationOffset$iv;
        void $this$fastCopyInto$iv;
        int resizeAmount = RangesKt.coerceAtMost((int)this.opCodesSize, (int)1024);
        Object[] newOpCodes = new Operation[this.opCodesSize + resizeAmount];
        Operation[] operationArray = this.opCodes;
        boolean bl = false;
        boolean bl2 = false;
        int endIndex$iv = this.opCodesSize;
        boolean $i$f$fastCopyInto = false;
        this.opCodes = (Operation[])ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])newOpCodes, (int)destinationOffset$iv, (int)startIndex$iv, (int)endIndex$iv);
    }

    private final void resizeIntArgs(int currentSize, int requiredSize) {
        int[] newIntArgs = new int[this.determineNewSize(currentSize, requiredSize)];
        ArraysKt.copyInto((int[])this.intArgs, (int[])newIntArgs, (int)0, (int)0, (int)currentSize);
        this.intArgs = newIntArgs;
    }

    /*
     * WARNING - void declaration
     */
    private final void resizeObjectArgs(int currentSize, int requiredSize) {
        void destinationOffset$iv;
        void $this$fastCopyInto$iv;
        Object[] newObjectArgs = new Object[this.determineNewSize(currentSize, requiredSize)];
        Object[] objectArray = this.objectArgs;
        boolean bl = false;
        int startIndex$iv = 0;
        boolean $i$f$fastCopyInto = false;
        ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])newObjectArgs, (int)destinationOffset$iv, (int)startIndex$iv, (int)currentSize);
        this.objectArgs = newObjectArgs;
    }

    public final void push(@NotNull Operation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        this.pushOp(operation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void ensureAllArgumentsPushedFor(@NotNull Operation operation) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Operations operations = this;
        int paramCount$iv = operation.getInts();
        boolean $i$f$createExpectedArgMask = false;
        if (this.pushedIntMask != (paramCount$iv == 0 ? 0 : -1) >>> 32 - paramCount$iv) return;
        Operations this_$iv = this;
        paramCount$iv = operation.getObjects();
        $i$f$createExpectedArgMask = false;
        if (this.pushedObjectMask != (paramCount$iv == 0 ? 0 : -1) >>> 32 - paramCount$iv) return;
    }

    /*
     * WARNING - void declaration
     */
    public final void popInto(@NotNull Operations other) {
        void endIndex$iv;
        void startIndex$iv;
        void destinationOffset$iv;
        void destination$iv;
        void $this$fastCopyInto$iv;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Operation[] opCodes = this.opCodes;
        this.opCodesSize += -1;
        Operation op = opCodes[this.opCodesSize];
        opCodes[this.opCodesSize] = null;
        other.pushOp(op);
        Object[] objectArray = this.objectArgs;
        Object[] objectArray2 = other.objectArgs;
        int n = other.objectArgsSize - op.getObjects();
        int n2 = this.objectArgsSize - op.getObjects();
        int n3 = this.objectArgsSize;
        boolean $i$f$fastCopyInto = false;
        ArraysKt.copyInto((Object[])$this$fastCopyInto$iv, (Object[])destination$iv, (int)destinationOffset$iv, (int)startIndex$iv, (int)endIndex$iv);
        ArraysKt.fill((Object[])this.objectArgs, null, (int)(this.objectArgsSize - op.getObjects()), (int)this.objectArgsSize);
        ArraysKt.copyInto((int[])this.intArgs, (int[])other.intArgs, (int)(other.intArgsSize - op.getInts()), (int)(this.intArgsSize - op.getInts()), (int)this.intArgsSize);
        this.objectArgsSize -= op.getObjects();
        this.intArgsSize -= op.getInts();
    }

    public final void executeAndFlushAllPendingOperations(@NotNull Applier<?> applier, @NotNull SlotWriter slots, @NotNull RememberManager rememberManager) {
        Intrinsics.checkNotNullParameter(applier, (String)"applier");
        Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
        Intrinsics.checkNotNullParameter((Object)rememberManager, (String)"rememberManager");
        Operations this_$iv = this;
        boolean $i$f$drain = false;
        Operations this_$iv$iv = this_$iv;
        boolean $i$f$forEach = false;
        if (this_$iv$iv.isNotEmpty()) {
            OpIterator iterator$iv$iv = this_$iv$iv.new OpIterator();
            do {
                OpIterator $this$executeAndFlushAllPendingOperations_u24lambda_u248 = iterator$iv$iv;
                boolean bl = false;
                Operation $this$executeAndFlushAllPendingOperations_u24lambda_u248_u24lambda_u247 = $this$executeAndFlushAllPendingOperations_u24lambda_u248.getOperation();
                boolean bl2 = false;
                $this$executeAndFlushAllPendingOperations_u24lambda_u248_u24lambda_u247.execute($this$executeAndFlushAllPendingOperations_u24lambda_u248, applier, slots, rememberManager);
            } while (iterator$iv$iv.next());
        }
        this_$iv.clear();
    }

    @Deprecated(message="toString() will return the default implementation from Any. Did you mean to use toDebugString()?", replaceWith=@ReplaceWith(expression="toDebugString()", imports={}))
    @NotNull
    public String toString() {
        return super.toString();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public final class OpIterator
    implements OperationArgContainer {
        private int opIdx;
        private int intIdx;
        private int objIdx;

        public final boolean next() {
            if (this.opIdx >= Operations.this.opCodesSize) {
                return false;
            }
            Operation op = this.getOperation();
            this.intIdx += op.getInts();
            this.objIdx += op.getObjects();
            int n = this.opIdx;
            this.opIdx = n + 1;
            return this.opIdx < Operations.this.opCodesSize;
        }

        @NotNull
        public final Operation getOperation() {
            return Operations.this.opCodes[this.opIdx];
        }

        @Override
        public int getInt(int parameter) {
            return Operations.this.intArgs[this.intIdx + parameter];
        }

        @Override
        public <T> T getObject-31yXWZQ(int parameter) {
            return (T)Operations.this.objectArgs[this.objIdx + parameter];
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @SourceDebugExtension(value={"SMAP\nOperations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Operations.kt\nandroidx/compose/runtime/changelist/Operations$WriteScope\n+ 2 Operations.kt\nandroidx/compose/runtime/changelist/Operations\n*L\n1#1,642:1\n356#2:643\n359#2:644\n356#2:645\n356#2:646\n356#2:647\n362#2:648\n356#2:649\n356#2:650\n356#2:651\n356#2:652\n*S KotlinDebug\n*F\n+ 1 Operations.kt\nandroidx/compose/runtime/changelist/Operations$WriteScope\n*L\n367#1:643\n378#1:644\n378#1:645\n396#1:646\n420#1:647\n436#1:648\n436#1:649\n454#1:650\n481#1:651\n513#1:652\n*E\n"})
    public static final class WriteScope {
        @NotNull
        private final Operations stack;

        public static final <T> void setObject-DKhxnng(Operations arg0, int parameter, T value2) {
            Operations $this$setObject_DKhxnng_u24lambda_u247 = arg0;
            boolean bl = false;
            Operations this_$iv = $this$setObject_DKhxnng_u24lambda_u247;
            boolean bl2 = false;
            Operations this_$iv$iv = this_$iv;
            boolean $i$f$peekOperation = false;
            $this$setObject_DKhxnng_u24lambda_u247.objectArgs[this_$iv.objectArgsSize - this_$iv$iv.opCodes[this_$iv$iv.opCodesSize - 1].getObjects() + parameter] = value2;
        }

        public static final <T, U> void setObjects-4uCC6AY(Operations arg0, int parameter1, T value1, int parameter2, U value2) {
            Operations $this$setObjects_4uCC6AY_u24lambda_u249 = arg0;
            boolean bl = false;
            Operations this_$iv = $this$setObjects_4uCC6AY_u24lambda_u249;
            boolean $i$f$peekOperation = false;
            int base = $this$setObjects_4uCC6AY_u24lambda_u249.objectArgsSize - this_$iv.opCodes[this_$iv.opCodesSize - 1].getObjects();
            Object[] objectArgs = $this$setObjects_4uCC6AY_u24lambda_u249.objectArgs;
            objectArgs[base + parameter1] = value1;
            objectArgs[base + parameter2] = value2;
        }

        public static final <T, U, V> void setObjects-t7hvbck(Operations arg0, int parameter1, T value1, int parameter2, U value2, int parameter3, V value3) {
            Operations $this$setObjects_t7hvbck_u24lambda_u2411 = arg0;
            boolean bl = false;
            Operations this_$iv = $this$setObjects_t7hvbck_u24lambda_u2411;
            boolean $i$f$peekOperation = false;
            int base = $this$setObjects_t7hvbck_u24lambda_u2411.objectArgsSize - this_$iv.opCodes[this_$iv.opCodesSize - 1].getObjects();
            Object[] objectArgs = $this$setObjects_t7hvbck_u24lambda_u2411.objectArgs;
            objectArgs[base + parameter1] = value1;
            objectArgs[base + parameter2] = value2;
            objectArgs[base + parameter3] = value3;
        }

        public static final <T, U, V, W> void setObjects-OGa0p1M(Operations arg0, int parameter1, T value1, int parameter2, U value2, int parameter3, V value3, int parameter4, W value4) {
            Operations $this$setObjects_OGa0p1M_u24lambda_u2413 = arg0;
            boolean bl = false;
            Operations this_$iv = $this$setObjects_OGa0p1M_u24lambda_u2413;
            boolean $i$f$peekOperation = false;
            int base = $this$setObjects_OGa0p1M_u24lambda_u2413.objectArgsSize - this_$iv.opCodes[this_$iv.opCodesSize - 1].getObjects();
            Object[] objectArgs = $this$setObjects_OGa0p1M_u24lambda_u2413.objectArgs;
            objectArgs[base + parameter1] = value1;
            objectArgs[base + parameter2] = value2;
            objectArgs[base + parameter3] = value3;
            objectArgs[base + parameter4] = value4;
        }

        public static String toString-impl(Operations arg0) {
            return "WriteScope(stack=" + arg0 + ")";
        }

        public String toString() {
            return WriteScope.toString-impl(this.stack);
        }

        public static int hashCode-impl(Operations arg0) {
            return arg0.hashCode();
        }

        public int hashCode() {
            return WriteScope.hashCode-impl(this.stack);
        }

        public static boolean equals-impl(Operations arg0, Object other) {
            if (!(other instanceof WriteScope)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((WriteScope)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return WriteScope.equals-impl(this.stack, other);
        }

        @NotNull
        public static Operations constructor-impl(@NotNull Operations stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return stack;
        }

        public final /* synthetic */ Operations unbox-impl() {
            return this.stack;
        }
    }
}

