/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.changelist;

import androidx.compose.runtime.Anchor;
import androidx.compose.runtime.ComposerImpl;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.Composition;
import androidx.compose.runtime.CompositionContext;
import androidx.compose.runtime.ControlledComposition;
import androidx.compose.runtime.IntStack;
import androidx.compose.runtime.MovableContentState;
import androidx.compose.runtime.MovableContentStateReference;
import androidx.compose.runtime.RecomposeScopeImpl;
import androidx.compose.runtime.RememberObserverHolder;
import androidx.compose.runtime.SlotReader;
import androidx.compose.runtime.SlotTable;
import androidx.compose.runtime.Stack;
import androidx.compose.runtime.changelist.ChangeList;
import androidx.compose.runtime.changelist.FixupList;
import androidx.compose.runtime.internal.IntRef;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nComposerChangeListWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposerChangeListWriter.kt\nandroidx/compose/runtime/changelist/ComposerChangeListWriter\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 Stack.kt\nandroidx/compose/runtime/IntStack\n*L\n1#1,466:1\n4644#2,4:467\n4644#2,4:471\n4644#2,4:475\n4644#2,4:480\n82#3:479\n*S KotlinDebug\n*F\n+ 1 ComposerChangeListWriter.kt\nandroidx/compose/runtime/changelist/ComposerChangeListWriter\n*L\n162#1:467,4\n251#1:471,4\n309#1:475,4\n448#1:480,4\n448#1:479\n*E\n"})
public final class ComposerChangeListWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ComposerImpl composer;
    @NotNull
    private ChangeList changeList;
    private boolean startedGroup;
    @NotNull
    private final IntStack startedGroups;
    private boolean implicitRootStart;
    private int writersReaderDelta;
    private int pendingUps;
    @NotNull
    private ArrayList<T> pendingDownNodes;
    private int removeFrom;
    private int moveFrom;
    private int moveTo;
    private int moveCount;
    public static final int $stable = 8;

    public ComposerChangeListWriter(@NotNull ComposerImpl composer, @NotNull ChangeList changeList) {
        Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        this.composer = composer;
        this.changeList = changeList;
        this.startedGroups = new IntStack();
        this.implicitRootStart = true;
        this.pendingDownNodes = Stack.constructor-impl$default(null, 1, null);
        this.removeFrom = -1;
        this.moveFrom = -1;
        this.moveTo = -1;
    }

    @NotNull
    public final ChangeList getChangeList() {
        return this.changeList;
    }

    public final void setChangeList(@NotNull ChangeList changeList) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"<set-?>");
        this.changeList = changeList;
    }

    private final SlotReader getReader() {
        return this.composer.getReader$runtime();
    }

    public final boolean getImplicitRootStart() {
        return this.implicitRootStart;
    }

    public final void setImplicitRootStart(boolean bl) {
        this.implicitRootStart = bl;
    }

    private final void pushApplierOperationPreamble() {
        this.pushPendingUpsAndDowns();
    }

    private final void pushSlotEditingOperationPreamble() {
        ComposerChangeListWriter.realizeOperationLocation$default(this, false, 1, null);
        this.recordSlotEditing();
    }

    private final void pushSlotTableOperationPreamble(boolean useParentSlot) {
        this.realizeOperationLocation(useParentSlot);
    }

    static /* synthetic */ void pushSlotTableOperationPreamble$default(ComposerChangeListWriter composerChangeListWriter, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        composerChangeListWriter.pushSlotTableOperationPreamble(bl);
    }

    public final void moveReaderRelativeTo(int location) {
        this.writersReaderDelta += location - this.getReader().getCurrentGroup();
    }

    public final void moveReaderToAbsolute(int location) {
        this.writersReaderDelta = location;
    }

    public final void recordSlotEditing() {
        if (this.getReader().getSize() > 0) {
            SlotReader reader2 = this.getReader();
            int location = reader2.getParent();
            if (this.startedGroups.peekOr(-2) != location) {
                this.ensureRootStarted();
                if (location > 0) {
                    Anchor anchor = reader2.anchor(location);
                    this.startedGroups.push(location);
                    this.ensureGroupStarted(anchor);
                }
            }
        }
    }

    private final void ensureRootStarted() {
        if (!this.startedGroup && this.implicitRootStart) {
            ComposerChangeListWriter.pushSlotTableOperationPreamble$default(this, false, 1, null);
            this.changeList.pushEnsureRootStarted();
            this.startedGroup = true;
        }
    }

    private final void ensureGroupStarted(Anchor anchor) {
        ComposerChangeListWriter.pushSlotTableOperationPreamble$default(this, false, 1, null);
        this.changeList.pushEnsureGroupStarted(anchor);
        this.startedGroup = true;
    }

    private final void realizeOperationLocation(boolean forParent) {
        int location = forParent ? this.getReader().getParent() : this.getReader().getCurrentGroup();
        int distance = location - this.writersReaderDelta;
        boolean value$iv = distance >= 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Tried to seek backward");
        }
        if (distance > 0) {
            this.changeList.pushAdvanceSlotsBy(distance);
            this.writersReaderDelta = location;
        }
    }

    static /* synthetic */ void realizeOperationLocation$default(ComposerChangeListWriter composerChangeListWriter, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        composerChangeListWriter.realizeOperationLocation(bl);
    }

    public final boolean getPastParent() {
        return this.getReader().getParent() - this.writersReaderDelta < 0;
    }

    public final void remember(@NotNull RememberObserverHolder value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.changeList.pushRemember(value2);
    }

    public final void rememberPausingScope(@NotNull RecomposeScopeImpl scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.changeList.pushRememberPausingScope(scope2);
    }

    public final void startResumingScope(@NotNull RecomposeScopeImpl scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.changeList.pushStartResumingScope(scope2);
    }

    public final void endResumingScope(@NotNull RecomposeScopeImpl scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.changeList.pushEndResumingScope(scope2);
    }

    public final void updateValue(@Nullable Object value2, int groupSlotIndex) {
        this.pushSlotTableOperationPreamble(true);
        this.changeList.pushUpdateValue(value2, groupSlotIndex);
    }

    public final void updateAnchoredValue(@Nullable Object value2, @NotNull Anchor anchor, int groupSlotIndex) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        this.changeList.pushUpdateAnchoredValue(value2, anchor, groupSlotIndex);
    }

    public final void appendValue(@NotNull Anchor anchor, @Nullable Object value2) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        this.changeList.pushAppendValue(anchor, value2);
    }

    public final void trimValues(int count) {
        if (count > 0) {
            this.pushSlotEditingOperationPreamble();
            this.changeList.pushTrimValues(count);
        }
    }

    public final void resetSlots() {
        this.changeList.pushResetSlots();
    }

    public final void updateAuxData(@Nullable Object data2) {
        ComposerChangeListWriter.pushSlotTableOperationPreamble$default(this, false, 1, null);
        this.changeList.pushUpdateAuxData(data2);
    }

    public final void endRoot() {
        if (this.startedGroup) {
            ComposerChangeListWriter.pushSlotTableOperationPreamble$default(this, false, 1, null);
            ComposerChangeListWriter.pushSlotTableOperationPreamble$default(this, false, 1, null);
            this.changeList.pushEndCurrentGroup();
            this.startedGroup = false;
        }
    }

    public final void endCurrentGroup() {
        int location = this.getReader().getParent();
        int currentStartedGroup = this.startedGroups.peekOr(-1);
        boolean value$iv = currentStartedGroup <= location;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Missed recording an endGroup");
        }
        if (this.startedGroups.peekOr(-1) == location) {
            ComposerChangeListWriter.pushSlotTableOperationPreamble$default(this, false, 1, null);
            this.startedGroups.pop();
            this.changeList.pushEndCurrentGroup();
        }
    }

    public final void skipToEndOfCurrentGroup() {
        this.changeList.pushSkipToEndOfCurrentGroup();
    }

    public final void removeCurrentGroup() {
        this.pushSlotEditingOperationPreamble();
        this.changeList.pushRemoveCurrentGroup();
        this.writersReaderDelta += this.getReader().getGroupSize();
    }

    public final void insertSlots(@NotNull Anchor anchor, @NotNull SlotTable from) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        this.pushPendingUpsAndDowns();
        this.pushSlotEditingOperationPreamble();
        this.realizeNodeMovementOperations();
        this.changeList.pushInsertSlots(anchor, from);
    }

    public final void insertSlots(@NotNull Anchor anchor, @NotNull SlotTable from, @NotNull FixupList fixups) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)fixups, (String)"fixups");
        this.pushPendingUpsAndDowns();
        this.pushSlotEditingOperationPreamble();
        this.realizeNodeMovementOperations();
        this.changeList.pushInsertSlots(anchor, from, fixups);
    }

    public final void moveCurrentGroup(int offset) {
        this.pushSlotEditingOperationPreamble();
        this.changeList.pushMoveCurrentGroup(offset);
    }

    public final void endCompositionScope(@NotNull Function1<? super Composition, Unit> action, @NotNull Composition composition) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)composition, (String)"composition");
        this.changeList.pushEndCompositionScope(action, composition);
    }

    public final void useNode(@Nullable Object node2) {
        this.pushApplierOperationPreamble();
        this.changeList.pushUseNode(node2);
    }

    public final <T, V> void updateNode(V value2, @NotNull Function2<? super T, ? super V, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.pushApplierOperationPreamble();
        this.changeList.pushUpdateNode(value2, block);
    }

    public final void removeNode(int nodeIndex, int count) {
        if (count > 0) {
            boolean value$iv = nodeIndex >= 0;
            boolean $i$f$runtimeCheck = false;
            if (!value$iv) {
                boolean bl = false;
                ComposerKt.composeImmediateRuntimeError("Invalid remove index " + nodeIndex);
            }
            if (this.removeFrom == nodeIndex) {
                this.moveCount += count;
            } else {
                this.realizeNodeMovementOperations();
                this.removeFrom = nodeIndex;
                this.moveCount = count;
            }
        }
    }

    public final void moveNode(int from, int to, int count) {
        if (count > 0) {
            if (this.moveCount > 0 && this.moveFrom == from - this.moveCount && this.moveTo == to - this.moveCount) {
                this.moveCount += count;
            } else {
                this.realizeNodeMovementOperations();
                this.moveFrom = from;
                this.moveTo = to;
                this.moveCount = count;
            }
        }
    }

    public final void releaseMovableContent() {
        this.pushPendingUpsAndDowns();
        if (this.startedGroup) {
            this.skipToEndOfCurrentGroup();
            this.endRoot();
        }
    }

    public final void endNodeMovement() {
        this.realizeNodeMovementOperations();
    }

    public final void endNodeMovementAndDeleteNode(int nodeIndex, int group) {
        int nodeCount;
        this.endNodeMovement();
        this.pushPendingUpsAndDowns();
        int n = nodeCount = this.getReader().isNode(group) ? 1 : this.getReader().nodeCount(group);
        if (nodeCount > 0) {
            this.removeNode(nodeIndex, nodeCount);
        }
    }

    private final void realizeNodeMovementOperations() {
        if (this.moveCount > 0) {
            if (this.removeFrom >= 0) {
                this.realizeRemoveNode(this.removeFrom, this.moveCount);
                this.removeFrom = -1;
            } else {
                this.realizeMoveNode(this.moveTo, this.moveFrom, this.moveCount);
                this.moveFrom = -1;
                this.moveTo = -1;
            }
            this.moveCount = 0;
        }
    }

    private final void realizeRemoveNode(int removeFrom, int moveCount) {
        this.pushApplierOperationPreamble();
        this.changeList.pushRemoveNode(removeFrom, moveCount);
    }

    private final void realizeMoveNode(int to, int from, int count) {
        this.pushApplierOperationPreamble();
        this.changeList.pushMoveNode(to, from, count);
    }

    public final void moveUp() {
        Object object;
        this.realizeNodeMovementOperations();
        if (Stack.isNotEmpty-impl(this.pendingDownNodes)) {
            object = Stack.pop-impl(this.pendingDownNodes);
        } else {
            int n = this.pendingUps;
            this.pendingUps = n + 1;
            object = n;
        }
    }

    public final void moveDown(@Nullable Object node2) {
        this.realizeNodeMovementOperations();
        Stack.push-impl(this.pendingDownNodes, node2);
    }

    private final void pushPendingUpsAndDowns() {
        if (this.pendingUps > 0) {
            this.changeList.pushUps(this.pendingUps);
            this.pendingUps = 0;
        }
        if (Stack.isNotEmpty-impl(this.pendingDownNodes)) {
            this.changeList.pushDowns(Stack.toArray-impl(this.pendingDownNodes));
            Stack.clear-impl(this.pendingDownNodes);
        }
    }

    public final void sideEffect(@NotNull Function0<Unit> effect2) {
        Intrinsics.checkNotNullParameter(effect2, (String)"effect");
        this.changeList.pushSideEffect(effect2);
    }

    public final void determineMovableContentNodeIndex(@NotNull IntRef effectiveNodeIndexOut, @NotNull Anchor anchor) {
        Intrinsics.checkNotNullParameter((Object)effectiveNodeIndexOut, (String)"effectiveNodeIndexOut");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        this.pushPendingUpsAndDowns();
        this.changeList.pushDetermineMovableContentNodeIndex(effectiveNodeIndexOut, anchor);
    }

    public final void copyNodesToNewAnchorLocation(@NotNull List<? extends Object> nodes, @NotNull IntRef effectiveNodeIndex) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)effectiveNodeIndex, (String)"effectiveNodeIndex");
        this.changeList.pushCopyNodesToNewAnchorLocation(nodes, effectiveNodeIndex);
    }

    public final void copySlotTableToAnchorLocation(@Nullable MovableContentState resolvedState, @NotNull CompositionContext parentContext, @NotNull MovableContentStateReference from, @NotNull MovableContentStateReference to) {
        Intrinsics.checkNotNullParameter((Object)parentContext, (String)"parentContext");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.changeList.pushCopySlotTableToAnchorLocation(resolvedState, parentContext, from, to);
    }

    public final void releaseMovableGroupAtCurrent(@NotNull ControlledComposition composition, @NotNull CompositionContext parentContext, @NotNull MovableContentStateReference reference) {
        Intrinsics.checkNotNullParameter((Object)composition, (String)"composition");
        Intrinsics.checkNotNullParameter((Object)parentContext, (String)"parentContext");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        this.changeList.pushReleaseMovableGroupAtCurrent(composition, parentContext, reference);
    }

    public final void endMovableContentPlacement() {
        this.changeList.pushEndMovableContentPlacement();
        this.writersReaderDelta = 0;
    }

    public final void includeOperationsIn(@NotNull ChangeList other, @Nullable IntRef effectiveNodeIndex) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.changeList.pushExecuteOperationsIn(other, effectiveNodeIndex);
    }

    public final void finalizeComposition() {
        this.pushPendingUpsAndDowns();
        IntStack this_$iv = this.startedGroups;
        boolean $i$f$isEmpty = false;
        boolean value$iv = this_$iv.tos == 0;
        boolean $i$f$runtimeCheck = false;
        if (!value$iv) {
            boolean bl = false;
            ComposerKt.composeImmediateRuntimeError("Missed recording an endGroup()");
        }
    }

    public final void resetTransientState() {
        this.startedGroup = false;
        this.startedGroups.clear();
        this.writersReaderDelta = 0;
    }

    public final void deactivateCurrentGroup() {
        ComposerChangeListWriter.pushSlotTableOperationPreamble$default(this, false, 1, null);
        this.changeList.pushDeactivateCurrentGroup();
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

