/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.v2;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollExtensionsKt;
import androidx.compose.foundation.lazy.LazyListItemInfo;
import androidx.compose.foundation.lazy.LazyListLayoutInfo;
import androidx.compose.foundation.lazy.LazyListState;
import androidx.compose.foundation.v2.LazyLineContentAdapter;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nScrollbar.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scrollbar.skiko.kt\nandroidx/compose/foundation/v2/LazyListScrollbarAdapter\n+ 2 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,501:1\n59#2:502\n54#2:504\n90#3:503\n85#3:505\n*S KotlinDebug\n*F\n+ 1 Scrollbar.skiko.kt\nandroidx/compose/foundation/v2/LazyListScrollbarAdapter\n*L\n227#1:502\n229#1:504\n227#1:503\n229#1:505\n*E\n"})
public final class LazyListScrollbarAdapter
extends LazyLineContentAdapter {
    @NotNull
    private final LazyListState scrollState;

    public LazyListScrollbarAdapter(@NotNull LazyListState scrollState) {
        Intrinsics.checkNotNullParameter((Object)scrollState, (String)"scrollState");
        this.scrollState = scrollState;
    }

    @Override
    public double getViewportSize() {
        int n;
        LazyListLayoutInfo $this$_get_viewportSize__u24lambda_u240 = this.scrollState.getLayoutInfo();
        boolean bl = false;
        if ($this$_get_viewportSize__u24lambda_u240.getOrientation() == Orientation.Vertical) {
            long arg0$iv = $this$_get_viewportSize__u24lambda_u240.getViewportSize-YbymL2g();
            boolean bl2 = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt2 = false;
            n = (int)(value$iv$iv & 0xFFFFFFFFL);
        } else {
            long arg0$iv = $this$_get_viewportSize__u24lambda_u240.getViewportSize-YbymL2g();
            boolean bl3 = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackInt1 = false;
            n = (int)(value$iv$iv >> 32);
        }
        return n;
    }

    private final Integer firstFloatingVisibleItemIndex() {
        Integer n;
        List<LazyListItemInfo> $this$firstFloatingVisibleItemIndex_u24lambda_u241 = this.scrollState.getLayoutInfo().getVisibleItemsInfo();
        boolean bl = false;
        switch ($this$firstFloatingVisibleItemIndex_u24lambda_u241.size()) {
            case 0: {
                n = null;
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            default: {
                LazyListItemInfo first = $this$firstFloatingVisibleItemIndex_u24lambda_u241.get(0);
                LazyListItemInfo second = $this$firstFloatingVisibleItemIndex_u24lambda_u241.get(1);
                n = first.getIndex() < second.getIndex() - 1 || first.getOffset() + first.getSize() + this.getLineSpacing() > second.getOffset() ? 1 : 0;
            }
        }
        return n;
    }

    @Override
    @Nullable
    protected LazyLineContentAdapter.VisibleLine firstVisibleLine() {
        Integer n = this.firstFloatingVisibleItemIndex();
        if (n == null) {
            return null;
        }
        int firstFloatingVisibleIndex = n;
        LazyListItemInfo firstFloatingItem = this.scrollState.getLayoutInfo().getVisibleItemsInfo().get(firstFloatingVisibleIndex);
        return new LazyLineContentAdapter.VisibleLine(firstFloatingItem.getIndex(), firstFloatingItem.getOffset());
    }

    @Override
    protected int totalLineCount() {
        return this.scrollState.getLayoutInfo().getTotalItemsCount();
    }

    @Override
    protected int contentPadding() {
        LazyListLayoutInfo $this$contentPadding_u24lambda_u242 = this.scrollState.getLayoutInfo();
        boolean bl = false;
        return $this$contentPadding_u24lambda_u242.getBeforeContentPadding() + $this$contentPadding_u24lambda_u242.getAfterContentPadding();
    }

    @Override
    @Nullable
    protected Object snapToLine(int lineIndex, int scrollOffset, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.scrollState.scrollToItem(lineIndex, scrollOffset, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    protected Object scrollBy(float value2, @NotNull Continuation<? super Unit> $completion) {
        Object object = ScrollExtensionsKt.scrollBy(this.scrollState, value2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    protected double averageVisibleLineSize() {
        double d;
        List<LazyListItemInfo> $this$averageVisibleLineSize_u24lambda_u243 = this.scrollState.getLayoutInfo().getVisibleItemsInfo();
        boolean bl = false;
        Integer n = this.firstFloatingVisibleItemIndex();
        if (n == null) {
            d = 0.0;
        } else {
            int firstFloatingIndex = n;
            LazyListItemInfo first = $this$averageVisibleLineSize_u24lambda_u243.get(firstFloatingIndex);
            LazyListItemInfo last = (LazyListItemInfo)CollectionsKt.last($this$averageVisibleLineSize_u24lambda_u243);
            int count = $this$averageVisibleLineSize_u24lambda_u243.size() - firstFloatingIndex;
            d = (double)(last.getOffset() + last.getSize() - first.getOffset() - (count - 1) * this.getLineSpacing()) / (double)count;
        }
        return d;
    }

    @Override
    protected int getLineSpacing() {
        return this.scrollState.getLayoutInfo().getMainAxisItemSpacing();
    }
}

