/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.collection.LongObjectMap;
import androidx.collection.LongObjectMapKt;
import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.SelectableInfo;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayout;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SingleSelectionLayout
implements SelectionLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isStartHandle;
    private final int startSlot;
    private final int endSlot;
    @Nullable
    private final Selection previousSelection;
    @NotNull
    private final SelectableInfo info;

    public SingleSelectionLayout(boolean isStartHandle, int startSlot, int endSlot, @Nullable Selection previousSelection, @NotNull SelectableInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.isStartHandle = isStartHandle;
        this.startSlot = startSlot;
        this.endSlot = endSlot;
        this.previousSelection = previousSelection;
        this.info = info;
    }

    @Override
    public boolean isStartHandle() {
        return this.isStartHandle;
    }

    @Override
    public int getStartSlot() {
        return this.startSlot;
    }

    @Override
    public int getEndSlot() {
        return this.endSlot;
    }

    @Override
    @Nullable
    public Selection getPreviousSelection() {
        return this.previousSelection;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    @NotNull
    public CrossStatus getCrossStatus() {
        return this.getStartSlot() < this.getEndSlot() ? CrossStatus.NOT_CROSSED : (this.getStartSlot() > this.getEndSlot() ? CrossStatus.CROSSED : this.info.getRawCrossStatus());
    }

    @Override
    @NotNull
    public SelectableInfo getStartInfo() {
        return this.info;
    }

    @Override
    @NotNull
    public SelectableInfo getEndInfo() {
        return this.info;
    }

    @Override
    @NotNull
    public SelectableInfo getCurrentInfo() {
        return this.info;
    }

    @Override
    @NotNull
    public SelectableInfo getFirstInfo() {
        return this.info;
    }

    @Override
    public void forEachMiddleInfo(@NotNull Function1<? super SelectableInfo, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
    }

    @Override
    public boolean shouldRecomputeSelection(@Nullable SelectionLayout other) {
        return this.getPreviousSelection() == null || other == null || !(other instanceof SingleSelectionLayout) || this.getStartSlot() != ((SingleSelectionLayout)other).getStartSlot() || this.getEndSlot() != ((SingleSelectionLayout)other).getEndSlot() || this.isStartHandle() != ((SingleSelectionLayout)other).isStartHandle() || this.info.shouldRecomputeSelection(((SingleSelectionLayout)other).info);
    }

    @Override
    @NotNull
    public LongObjectMap<Selection> createSubSelections(@NotNull Selection selection) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Selection $this$createSubSelections_u24lambda_u240 = selection;
        boolean bl = false;
        Selection finalSelection = !$this$createSubSelections_u24lambda_u240.getHandlesCrossed() && $this$createSubSelections_u24lambda_u240.getStart().getOffset() > $this$createSubSelections_u24lambda_u240.getEnd().getOffset() || $this$createSubSelections_u24lambda_u240.getHandlesCrossed() && $this$createSubSelections_u24lambda_u240.getStart().getOffset() <= $this$createSubSelections_u24lambda_u240.getEnd().getOffset() ? Selection.copy$default($this$createSubSelections_u24lambda_u240, null, null, !$this$createSubSelections_u24lambda_u240.getHandlesCrossed(), 3, null) : $this$createSubSelections_u24lambda_u240;
        return LongObjectMapKt.longObjectMapOf((long)this.info.getSelectableId(), (Object)finalSelection);
    }

    @NotNull
    public String toString() {
        return "SingleSelectionLayout(isStartHandle=" + this.isStartHandle() + ", crossed=" + this.getCrossStatus() + ", info=\n\t" + this.info + ")";
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

