/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.collection.LongIntMap;
import androidx.collection.LongIntMapKt;
import androidx.collection.MutableLongIntMap;
import androidx.compose.foundation.text.selection.Direction;
import androidx.compose.foundation.text.selection.MultiSelectionLayout;
import androidx.compose.foundation.text.selection.SelectableInfo;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayout;
import androidx.compose.foundation.text.selection.SelectionLayoutKt;
import androidx.compose.foundation.text.selection.SingleSelectionLayout;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.TextLayoutResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SelectionLayoutBuilder {
    private final long currentPosition;
    private final long previousHandlePosition;
    @NotNull
    private final LayoutCoordinates containerCoordinates;
    private final boolean isStartHandle;
    @Nullable
    private final Selection previousSelection;
    @NotNull
    private final Comparator<Long> selectableIdOrderingComparator;
    @NotNull
    private final MutableLongIntMap selectableIdToInfoListIndex;
    @NotNull
    private final List<SelectableInfo> infoList;
    private int startSlot;
    private int endSlot;
    private int currentSlot;
    public static final int $stable = 8;

    private SelectionLayoutBuilder(long currentPosition, long previousHandlePosition, LayoutCoordinates containerCoordinates, boolean isStartHandle, Selection previousSelection, Comparator<Long> selectableIdOrderingComparator) {
        Intrinsics.checkNotNullParameter((Object)containerCoordinates, (String)"containerCoordinates");
        Intrinsics.checkNotNullParameter(selectableIdOrderingComparator, (String)"selectableIdOrderingComparator");
        this.currentPosition = currentPosition;
        this.previousHandlePosition = previousHandlePosition;
        this.containerCoordinates = containerCoordinates;
        this.isStartHandle = isStartHandle;
        this.previousSelection = previousSelection;
        this.selectableIdOrderingComparator = selectableIdOrderingComparator;
        this.selectableIdToInfoListIndex = LongIntMapKt.mutableLongIntMapOf();
        this.infoList = new ArrayList();
        this.startSlot = -1;
        this.endSlot = -1;
        this.currentSlot = -1;
    }

    public final long getCurrentPosition-F1C5BW0() {
        return this.currentPosition;
    }

    public final long getPreviousHandlePosition-F1C5BW0() {
        return this.previousHandlePosition;
    }

    @NotNull
    public final LayoutCoordinates getContainerCoordinates() {
        return this.containerCoordinates;
    }

    public final boolean isStartHandle() {
        return this.isStartHandle;
    }

    @Nullable
    public final Selection getPreviousSelection() {
        return this.previousSelection;
    }

    @NotNull
    public final Comparator<Long> getSelectableIdOrderingComparator() {
        return this.selectableIdOrderingComparator;
    }

    @Nullable
    public final SelectionLayout build() {
        SelectionLayout selectionLayout;
        int lastSlot = this.currentSlot + 1;
        switch (this.infoList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                SelectableInfo selectableInfo = (SelectableInfo)CollectionsKt.single(this.infoList);
                int n = this.startSlot == -1 ? lastSlot : this.startSlot;
                int n2 = this.endSlot == -1 ? lastSlot : this.endSlot;
                Selection selection = this.previousSelection;
                boolean bl = this.isStartHandle;
                selectionLayout = new SingleSelectionLayout(bl, n, n2, selection, selectableInfo);
                break;
            }
            default: {
                selectionLayout = new MultiSelectionLayout((LongIntMap)this.selectableIdToInfoListIndex, this.infoList, this.startSlot == -1 ? lastSlot : this.startSlot, this.endSlot == -1 ? lastSlot : this.endSlot, this.isStartHandle, this.previousSelection);
            }
        }
        return selectionLayout;
    }

    @NotNull
    public final SelectableInfo appendInfo(long selectableId, int rawStartHandleOffset, @NotNull Direction startXHandleDirection, @NotNull Direction startYHandleDirection, int rawEndHandleOffset, @NotNull Direction endXHandleDirection, @NotNull Direction endYHandleDirection, int rawPreviousHandleOffset, @NotNull TextLayoutResult textLayoutResult) {
        Intrinsics.checkNotNullParameter((Object)((Object)startXHandleDirection), (String)"startXHandleDirection");
        Intrinsics.checkNotNullParameter((Object)((Object)startYHandleDirection), (String)"startYHandleDirection");
        Intrinsics.checkNotNullParameter((Object)((Object)endXHandleDirection), (String)"endXHandleDirection");
        Intrinsics.checkNotNullParameter((Object)((Object)endYHandleDirection), (String)"endYHandleDirection");
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        this.currentSlot += 2;
        SelectableInfo selectableInfo = new SelectableInfo(selectableId, this.currentSlot, rawStartHandleOffset, rawEndHandleOffset, rawPreviousHandleOffset, textLayoutResult);
        this.startSlot = this.updateSlot(this.startSlot, startXHandleDirection, startYHandleDirection);
        this.endSlot = this.updateSlot(this.endSlot, endXHandleDirection, endYHandleDirection);
        this.selectableIdToInfoListIndex.set(selectableId, this.infoList.size());
        ((Collection)this.infoList).add(selectableInfo);
        return selectableInfo;
    }

    private final int updateSlot(int slot, Direction xPositionDirection, Direction yPositionDirection) {
        int n;
        if (slot != -1) {
            return slot;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[SelectionLayoutKt.resolve2dDirection(xPositionDirection, yPositionDirection).ordinal()]) {
            case 1: {
                n = this.currentSlot - 1;
                break;
            }
            case 2: {
                n = this.currentSlot;
                break;
            }
            case 3: {
                n = slot;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public /* synthetic */ SelectionLayoutBuilder(long currentPosition, long previousHandlePosition, LayoutCoordinates containerCoordinates, boolean isStartHandle, Selection previousSelection, Comparator selectableIdOrderingComparator, DefaultConstructorMarker $constructor_marker) {
        this(currentPosition, previousHandlePosition, containerCoordinates, isStartHandle, previousSelection, selectableIdOrderingComparator);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.BEFORE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.ON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.AFTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

