/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.modifiers;

import androidx.compose.foundation.text.TextAutoSize;
import androidx.compose.foundation.text.modifiers.SelectionController;
import androidx.compose.foundation.text.modifiers.TextAnnotatedStringNode;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.ColorProducer;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextOverflow;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAnnotatedStringElement
extends ModifierNodeElement<TextAnnotatedStringNode> {
    @NotNull
    private final AnnotatedString text;
    @NotNull
    private final TextStyle style;
    @NotNull
    private final FontFamily.Resolver fontFamilyResolver;
    @Nullable
    private final Function1<TextLayoutResult, Unit> onTextLayout;
    private final int overflow;
    private final boolean softWrap;
    private final int maxLines;
    private final int minLines;
    @Nullable
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    @Nullable
    private final Function1<List<Rect>, Unit> onPlaceholderLayout;
    @Nullable
    private final SelectionController selectionController;
    @Nullable
    private final ColorProducer color;
    @Nullable
    private final TextAutoSize autoSize;
    @Nullable
    private final Function1<TextAnnotatedStringNode.TextSubstitutionValue, Unit> onShowTranslation;

    private TextAnnotatedStringElement(AnnotatedString text2, TextStyle style, FontFamily.Resolver fontFamilyResolver, Function1<? super TextLayoutResult, Unit> onTextLayout, int overflow, boolean softWrap, int maxLines, int minLines, List<AnnotatedString.Range<Placeholder>> placeholders, Function1<? super List<Rect>, Unit> onPlaceholderLayout, SelectionController selectionController, ColorProducer color, TextAutoSize autoSize, Function1<? super TextAnnotatedStringNode.TextSubstitutionValue, Unit> onShowTranslation) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        this.text = text2;
        this.style = style;
        this.fontFamilyResolver = fontFamilyResolver;
        this.onTextLayout = onTextLayout;
        this.overflow = overflow;
        this.softWrap = softWrap;
        this.maxLines = maxLines;
        this.minLines = minLines;
        this.placeholders = placeholders;
        this.onPlaceholderLayout = onPlaceholderLayout;
        this.selectionController = selectionController;
        this.color = color;
        this.autoSize = autoSize;
        this.onShowTranslation = onShowTranslation;
    }

    @Override
    @NotNull
    public TextAnnotatedStringNode create() {
        return new TextAnnotatedStringNode(this.text, this.style, this.fontFamilyResolver, this.onTextLayout, this.overflow, this.softWrap, this.maxLines, this.minLines, this.placeholders, this.onPlaceholderLayout, this.selectionController, this.color, this.autoSize, this.onShowTranslation, null);
    }

    @Override
    public void update(@NotNull TextAnnotatedStringNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.doInvalidations(node2.updateDraw(this.color, this.style), node2.updateText$foundation(this.text), node2.updateLayoutRelatedArgs-y0k-MQk(this.style, this.placeholders, this.minLines, this.maxLines, this.softWrap, this.fontFamilyResolver, this.overflow, this.autoSize), node2.updateCallbacks(this.onTextLayout, this.onPlaceholderLayout, this.selectionController, this.onShowTranslation));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextAnnotatedStringElement)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.color, (Object)((TextAnnotatedStringElement)other).color)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.text, (Object)((TextAnnotatedStringElement)other).text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.style, (Object)((TextAnnotatedStringElement)other).style)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.placeholders, ((TextAnnotatedStringElement)other).placeholders)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fontFamilyResolver, (Object)((TextAnnotatedStringElement)other).fontFamilyResolver)) {
            return false;
        }
        if (this.onTextLayout != ((TextAnnotatedStringElement)other).onTextLayout) {
            return false;
        }
        if (this.onShowTranslation != ((TextAnnotatedStringElement)other).onShowTranslation) {
            return false;
        }
        if (!TextOverflow.equals-impl0(this.overflow, ((TextAnnotatedStringElement)other).overflow)) {
            return false;
        }
        if (this.softWrap != ((TextAnnotatedStringElement)other).softWrap) {
            return false;
        }
        if (this.maxLines != ((TextAnnotatedStringElement)other).maxLines) {
            return false;
        }
        if (this.minLines != ((TextAnnotatedStringElement)other).minLines) {
            return false;
        }
        if (this.onPlaceholderLayout != ((TextAnnotatedStringElement)other).onPlaceholderLayout) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.selectionController, (Object)((TextAnnotatedStringElement)other).selectionController);
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = 31 * result2 + this.style.hashCode();
        result2 = 31 * result2 + this.fontFamilyResolver.hashCode();
        Function1<TextLayoutResult, Unit> function1 = this.onTextLayout;
        result2 = 31 * result2 + (function1 != null ? function1.hashCode() : 0);
        result2 = 31 * result2 + TextOverflow.hashCode-impl(this.overflow);
        result2 = 31 * result2 + Boolean.hashCode(this.softWrap);
        result2 = 31 * result2 + this.maxLines;
        result2 = 31 * result2 + this.minLines;
        List<AnnotatedString.Range<Placeholder>> list2 = this.placeholders;
        result2 = 31 * result2 + (list2 != null ? ((Object)list2).hashCode() : 0);
        Function1<List<Rect>, Unit> function12 = this.onPlaceholderLayout;
        result2 = 31 * result2 + (function12 != null ? function12.hashCode() : 0);
        SelectionController selectionController = this.selectionController;
        result2 = 31 * result2 + (selectionController != null ? selectionController.hashCode() : 0);
        ColorProducer colorProducer2 = this.color;
        result2 = 31 * result2 + (colorProducer2 != null ? colorProducer2.hashCode() : 0);
        Function1<TextAnnotatedStringNode.TextSubstitutionValue, Unit> function13 = this.onShowTranslation;
        result2 = 31 * result2 + (function13 != null ? function13.hashCode() : 0);
        return result2;
    }

    public /* synthetic */ TextAnnotatedStringElement(AnnotatedString text2, TextStyle style, FontFamily.Resolver fontFamilyResolver, Function1 onTextLayout, int overflow, boolean softWrap, int maxLines, int minLines, List placeholders, Function1 onPlaceholderLayout, SelectionController selectionController, ColorProducer color, TextAutoSize autoSize, Function1 onShowTranslation, DefaultConstructorMarker $constructor_marker) {
        this(text2, style, fontFamilyResolver, (Function1<? super TextLayoutResult, Unit>)onTextLayout, overflow, softWrap, maxLines, minLines, placeholders, (Function1<? super List<Rect>, Unit>)onPlaceholderLayout, selectionController, color, autoSize, (Function1<? super TextAnnotatedStringNode.TextSubstitutionValue, Unit>)onShowTranslation);
    }
}

