/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.TextDelegateKt;
import androidx.compose.foundation.text.TextLayoutHelperKt;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.MultiParagraph;
import androidx.compose.ui.text.MultiParagraphIntrinsics;
import androidx.compose.ui.text.Placeholder;
import androidx.compose.ui.text.TextLayoutInput;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.TextStyleKt;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import androidx.compose.ui.unit.ConstraintsKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nTextDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextDelegate.kt\nandroidx/compose/foundation/text/TextDelegate\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,356:1\n97#2,4:357\n97#2,4:361\n97#2,4:365\n30#3:369\n30#3:371\n80#4:370\n80#4:372\n*S KotlinDebug\n*F\n+ 1 TextDelegate.kt\nandroidx/compose/foundation/text/TextDelegate\n*L\n116#1:357,4\n117#1:361,4\n118#1:365,4\n252#1:369\n265#1:371\n252#1:370\n265#1:372\n*E\n"})
public final class TextDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnnotatedString text;
    @NotNull
    private final TextStyle style;
    private final int maxLines;
    private final int minLines;
    private final boolean softWrap;
    private final int overflow;
    @NotNull
    private final Density density;
    @NotNull
    private final FontFamily.Resolver fontFamilyResolver;
    @NotNull
    private final List<AnnotatedString.Range<Placeholder>> placeholders;
    @Nullable
    private MultiParagraphIntrinsics paragraphIntrinsics;
    @Nullable
    private LayoutDirection intrinsicsLayoutDirection;

    private TextDelegate(AnnotatedString text2, TextStyle style, int maxLines, int minLines, boolean softWrap, int overflow, Density density, FontFamily.Resolver fontFamilyResolver, List<AnnotatedString.Range<Placeholder>> placeholders) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)fontFamilyResolver, (String)"fontFamilyResolver");
        Intrinsics.checkNotNullParameter(placeholders, (String)"placeholders");
        this.text = text2;
        this.style = style;
        this.maxLines = maxLines;
        this.minLines = minLines;
        this.softWrap = softWrap;
        this.overflow = overflow;
        this.density = density;
        this.fontFamilyResolver = fontFamilyResolver;
        this.placeholders = placeholders;
        boolean value$iv = this.maxLines > 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("no maxLines");
        }
        value$iv = this.minLines > 0;
        $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("no minLines");
        }
        value$iv = this.minLines <= this.maxLines;
        $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("minLines greater than maxLines");
        }
    }

    public /* synthetic */ TextDelegate(AnnotatedString annotatedString, TextStyle textStyle, int n, int n2, boolean bl, int n3, Density density, FontFamily.Resolver resolver, List list2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n4 & 8) != 0) {
            n2 = 1;
        }
        if ((n4 & 0x10) != 0) {
            bl = true;
        }
        if ((n4 & 0x20) != 0) {
            n3 = TextOverflow.Companion.getClip-gIe3tQ8();
        }
        if ((n4 & 0x100) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(annotatedString, textStyle, n, n2, bl, n3, density, resolver, list2, null);
    }

    @NotNull
    public final AnnotatedString getText() {
        return this.text;
    }

    @NotNull
    public final TextStyle getStyle() {
        return this.style;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final int getMinLines() {
        return this.minLines;
    }

    public final boolean getSoftWrap() {
        return this.softWrap;
    }

    public final int getOverflow-gIe3tQ8() {
        return this.overflow;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    @NotNull
    public final FontFamily.Resolver getFontFamilyResolver() {
        return this.fontFamilyResolver;
    }

    @NotNull
    public final List<AnnotatedString.Range<Placeholder>> getPlaceholders() {
        return this.placeholders;
    }

    private final MultiParagraphIntrinsics getNonNullIntrinsics() {
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.paragraphIntrinsics;
        if (multiParagraphIntrinsics == null) {
            throw new IllegalStateException("layoutIntrinsics must be called first");
        }
        return multiParagraphIntrinsics;
    }

    public final int getMaxIntrinsicWidth() {
        return TextDelegateKt.ceilToIntPx(this.getNonNullIntrinsics().getMaxIntrinsicWidth());
    }

    public final void layoutIntrinsics(@NotNull LayoutDirection layoutDirection) {
        MultiParagraphIntrinsics intrinsics;
        MultiParagraphIntrinsics multiParagraphIntrinsics;
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        MultiParagraphIntrinsics localIntrinsics = this.paragraphIntrinsics;
        if (localIntrinsics == null || layoutDirection != this.intrinsicsLayoutDirection || localIntrinsics.getHasStaleResolvedFonts()) {
            this.intrinsicsLayoutDirection = layoutDirection;
            AnnotatedString annotatedString = this.text;
            TextStyle textStyle = TextStyleKt.resolveDefaults(this.style, layoutDirection);
            Density density = this.density;
            FontFamily.Resolver resolver = this.fontFamilyResolver;
            List<AnnotatedString.Range<Placeholder>> list2 = this.placeholders;
            multiParagraphIntrinsics = new MultiParagraphIntrinsics(annotatedString, textStyle, list2, density, resolver);
        } else {
            multiParagraphIntrinsics = localIntrinsics;
        }
        this.paragraphIntrinsics = intrinsics = multiParagraphIntrinsics;
    }

    private final MultiParagraph layoutText-K40F9xA(long constraints, LayoutDirection layoutDirection) {
        this.layoutIntrinsics(layoutDirection);
        int minWidth = Constraints.getMinWidth-impl(constraints);
        boolean widthMatters = this.softWrap || TextOverflow.equals-impl0(this.overflow, TextOverflow.Companion.getEllipsis-gIe3tQ8());
        int maxWidth = widthMatters && Constraints.getHasBoundedWidth-impl(constraints) ? Constraints.getMaxWidth-impl(constraints) : Integer.MAX_VALUE;
        boolean overwriteMaxLines = !this.softWrap && TextOverflow.equals-impl0(this.overflow, TextOverflow.Companion.getEllipsis-gIe3tQ8());
        int finalMaxLines = overwriteMaxLines ? 1 : this.maxLines;
        int width = minWidth == maxWidth ? maxWidth : RangesKt.coerceIn((int)this.getMaxIntrinsicWidth(), (int)minWidth, (int)maxWidth);
        return new MultiParagraph(this.getNonNullIntrinsics(), Constraints.Companion.fitPrioritizingWidth-Zbe2FdA(0, width, 0, Constraints.getMaxHeight-impl(constraints)), finalMaxLines, this.overflow, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextLayoutResult layout-NN6Ew-U(long constraints, @NotNull LayoutDirection layoutDirection, @Nullable TextLayoutResult prevResult) {
        void width$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        if (prevResult != null && TextLayoutHelperKt.canReuse-7_7YC6M(prevResult, this.text, this.style, this.placeholders, this.maxLines, this.softWrap, this.overflow, this.density, layoutDirection, this.fontFamilyResolver, constraints)) {
            void height$iv;
            void width$iv2;
            TextLayoutResult $this$layout_NN6Ew_U_u24lambda_u243 = prevResult;
            boolean bl = false;
            int n = TextDelegateKt.ceilToIntPx($this$layout_NN6Ew_U_u24lambda_u243.getMultiParagraph().getWidth());
            int n2 = TextDelegateKt.ceilToIntPx($this$layout_NN6Ew_U_u24lambda_u243.getMultiParagraph().getHeight());
            boolean $i$f$IntSize = false;
            boolean $i$f$packInts = false;
            return $this$layout_NN6Ew_U_u24lambda_u243.copy-O0kMr_c(new TextLayoutInput($this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getText(), this.style, $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getPlaceholders(), $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getMaxLines(), $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getSoftWrap(), $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getOverflow-gIe3tQ8(), $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getDensity(), $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getLayoutDirection(), $this$layout_NN6Ew_U_u24lambda_u243.getLayoutInput().getFontFamilyResolver(), constraints, null), ConstraintsKt.constrain-4WqzIAM(constraints, IntSize.constructor-impl((long)width$iv2 << 32 | (long)height$iv & 0xFFFFFFFFL)));
        }
        MultiParagraph multiParagraph = this.layoutText-K40F9xA(constraints, layoutDirection);
        int height$iv = TextDelegateKt.ceilToIntPx(multiParagraph.getWidth());
        int height$iv2 = TextDelegateKt.ceilToIntPx(multiParagraph.getHeight());
        boolean $i$f$IntSize = false;
        boolean $i$f$packInts = false;
        long size = ConstraintsKt.constrain-4WqzIAM(constraints, IntSize.constructor-impl((long)width$iv << 32 | (long)height$iv2 & 0xFFFFFFFFL));
        return new TextLayoutResult(new TextLayoutInput(this.text, this.style, this.placeholders, this.maxLines, this.softWrap, this.overflow, this.density, layoutDirection, this.fontFamilyResolver, constraints, null), multiParagraph, size, null);
    }

    public /* synthetic */ TextDelegate(AnnotatedString text2, TextStyle style, int maxLines, int minLines, boolean softWrap, int overflow, Density density, FontFamily.Resolver fontFamilyResolver, List placeholders, DefaultConstructorMarker $constructor_marker) {
        this(text2, style, maxLines, minLines, softWrap, overflow, density, fontFamilyResolver, placeholders);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

