/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.layout;

import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.lazy.layout.IntervalList;
import androidx.compose.foundation.lazy.layout.IntervalListKt;
import androidx.compose.runtime.collection.MutableVector;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nIntervalList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntervalList.kt\nandroidx/compose/foundation/lazy/layout/MutableIntervalList\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 4 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n165#1,4:212\n165#1,4:216\n165#1,4:226\n1101#2:205\n1083#2,2:206\n97#3,4:208\n97#3,4:220\n472#4:224\n472#4:225\n472#4:230\n1#5:231\n*S KotlinDebug\n*F\n+ 1 IntervalList.kt\nandroidx/compose/foundation/lazy/layout/MutableIntervalList\n*L\n133#1:212,4\n134#1:216,4\n150#1:226,4\n94#1:205\n94#1:206,2\n112#1:208,4\n135#1:220,4\n140#1:224\n142#1:225\n159#1:230\n*E\n"})
public final class MutableIntervalList<T>
implements IntervalList<T> {
    @NotNull
    private final MutableVector<IntervalList.Interval<T>> intervals;
    private int size;
    @Nullable
    private IntervalList.Interval<? extends T> lastInterval;
    public static final int $stable = 8;

    public MutableIntervalList() {
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.intervals = new MutableVector<IntervalList.Interval>(new IntervalList.Interval[capacity$iv$iv], 0);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public final void addInterval(int size, T value2) {
        boolean value$iv = size >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("size should be >=0");
        }
        if (size == 0) {
            return;
        }
        IntervalList.Interval<T> interval = new IntervalList.Interval<T>(this.getSize(), size, value2);
        this.size = this.getSize() + size;
        this.intervals.add(interval);
    }

    @Override
    public void forEach(int fromIndex, int toIndex, @NotNull Function1<? super IntervalList.Interval<? extends T>, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        MutableIntervalList this_$iv = this;
        boolean $i$f$checkIndexBounds = false;
        if (!(0 <= fromIndex ? fromIndex < this_$iv.getSize() : false)) {
            InlineClassHelperKt.throwIndexOutOfBoundsException("Index " + fromIndex + ", size " + this_$iv.getSize());
        }
        this_$iv = this;
        $i$f$checkIndexBounds = false;
        if (!(0 <= toIndex ? toIndex < this_$iv.getSize() : false)) {
            InlineClassHelperKt.throwIndexOutOfBoundsException("Index " + toIndex + ", size " + this_$iv.getSize());
        }
        boolean value$iv = toIndex >= fromIndex;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("toIndex (" + toIndex + ") should be not smaller than fromIndex (" + fromIndex + ")");
        }
        int intervalIndex = IntervalListKt.access$binarySearch(this.intervals, fromIndex);
        MutableVector<IntervalList.Interval<T>> this_$iv2 = this.intervals;
        boolean $i$f$get = false;
        int itemIndex = ((IntervalList.Interval)this_$iv2.content[intervalIndex]).getStartIndex();
        while (itemIndex <= toIndex) {
            MutableVector<IntervalList.Interval<T>> this_$iv3 = this.intervals;
            boolean $i$f$get2 = false;
            IntervalList.Interval interval = (IntervalList.Interval)this_$iv3.content[intervalIndex];
            block.invoke((Object)interval);
            itemIndex += interval.getSize();
            ++intervalIndex;
        }
    }

    @Override
    @NotNull
    public IntervalList.Interval<T> get(int index) {
        MutableIntervalList this_$iv = this;
        boolean $i$f$checkIndexBounds = false;
        if (!(0 <= index ? index < this_$iv.getSize() : false)) {
            InlineClassHelperKt.throwIndexOutOfBoundsException("Index " + index + ", size " + this_$iv.getSize());
        }
        return this.getIntervalForIndex(index);
    }

    /*
     * WARNING - void declaration
     */
    private final IntervalList.Interval<T> getIntervalForIndex(int itemIndex) {
        IntervalList.Interval interval;
        IntervalList.Interval lastInterval = this.lastInterval;
        if (lastInterval != null && this.contains(lastInterval, itemIndex)) {
            interval = lastInterval;
        } else {
            void this_$iv;
            MutableVector<IntervalList.Interval<T>> mutableVector = this.intervals;
            int index$iv = IntervalListKt.access$binarySearch(this.intervals, itemIndex);
            boolean $i$f$get = false;
            mutableVector = this_$iv.content[index$iv];
            IntervalList.Interval it = (IntervalList.Interval)((Object)mutableVector);
            boolean bl = false;
            this.lastInterval = it;
            interval = (IntervalList.Interval)((Object)mutableVector);
        }
        return interval;
    }

    private final boolean contains(IntervalList.Interval<? extends T> $this$contains, int index) {
        int n = $this$contains.getStartIndex();
        return index < $this$contains.getStartIndex() + $this$contains.getSize() ? n <= index : false;
    }
}

