/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.WindowInsets;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UnionInsets
implements WindowInsets {
    @NotNull
    private final WindowInsets first;
    @NotNull
    private final WindowInsets second;

    public UnionInsets(@NotNull WindowInsets first, @NotNull WindowInsets second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        this.first = first;
        this.second = second;
    }

    @Override
    public int getLeft(@NotNull Density density, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        return Math.max(this.first.getLeft(density, layoutDirection), this.second.getLeft(density, layoutDirection));
    }

    @Override
    public int getTop(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return Math.max(this.first.getTop(density), this.second.getTop(density));
    }

    @Override
    public int getRight(@NotNull Density density, @NotNull LayoutDirection layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)((Object)layoutDirection), (String)"layoutDirection");
        return Math.max(this.first.getRight(density, layoutDirection), this.second.getRight(density, layoutDirection));
    }

    @Override
    public int getBottom(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return Math.max(this.first.getBottom(density), this.second.getBottom(density));
    }

    public int hashCode() {
        return this.first.hashCode() + this.second.hashCode() * 31;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnionInsets)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((UnionInsets)other).first, (Object)this.first) && Intrinsics.areEqual((Object)((UnionInsets)other).second, (Object)this.second);
    }

    @NotNull
    public String toString() {
        return "(" + this.first + " \u222a " + this.second + ")";
    }
}

