/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.layout;

import androidx.compose.foundation.layout.IntrinsicSize;
import androidx.compose.foundation.layout.IntrinsicWidthNode;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.platform.InspectorInfo;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IntrinsicWidthElement
extends ModifierNodeElement<IntrinsicWidthNode> {
    @NotNull
    private final IntrinsicSize width;
    private final boolean enforceIncoming;
    @NotNull
    private final Function1<InspectorInfo, Unit> inspectorInfo;

    public IntrinsicWidthElement(@NotNull IntrinsicSize width, boolean enforceIncoming, @NotNull Function1<? super InspectorInfo, Unit> inspectorInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)width), (String)"width");
        Intrinsics.checkNotNullParameter(inspectorInfo, (String)"inspectorInfo");
        this.width = width;
        this.enforceIncoming = enforceIncoming;
        this.inspectorInfo = inspectorInfo;
    }

    @Override
    @NotNull
    public IntrinsicWidthNode create() {
        return new IntrinsicWidthNode(this.width, this.enforceIncoming);
    }

    @Override
    public void update(@NotNull IntrinsicWidthNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.setWidth(this.width);
        node2.setEnforceIncoming(this.enforceIncoming);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        IntrinsicWidthElement intrinsicWidthElement = other instanceof IntrinsicWidthElement ? (IntrinsicWidthElement)other : null;
        if (intrinsicWidthElement == null) {
            return false;
        }
        IntrinsicWidthElement otherModifierElement = intrinsicWidthElement;
        return this.width == otherModifierElement.width && this.enforceIncoming == otherModifierElement.enforceIncoming;
    }

    public int hashCode() {
        return 31 * this.width.hashCode() + Boolean.hashCode(this.enforceIncoming);
    }
}

