/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures;

import androidx.compose.foundation.gestures.DraggableNode;
import androidx.compose.foundation.gestures.DraggableState;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.interaction.MutableInteractionSource;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.node.ModifierNodeElement;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DraggableElement
extends ModifierNodeElement<DraggableNode> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DraggableState state;
    @NotNull
    private final Orientation orientation;
    private final boolean enabled;
    @Nullable
    private final MutableInteractionSource interactionSource;
    private final boolean startDragImmediately;
    @NotNull
    private final Function3<CoroutineScope, Offset, Continuation<? super Unit>, Object> onDragStarted;
    @NotNull
    private final Function3<CoroutineScope, Float, Continuation<? super Unit>, Object> onDragStopped;
    private final boolean reverseDirection;
    @NotNull
    private static final Function1<PointerInputChange, Boolean> CanDrag = DraggableElement::CanDrag$lambda$0;

    public DraggableElement(@NotNull DraggableState state2, @NotNull Orientation orientation, boolean enabled, @Nullable MutableInteractionSource interactionSource, boolean startDragImmediately, @NotNull Function3<? super CoroutineScope, ? super Offset, ? super Continuation<? super Unit>, ? extends Object> onDragStarted2, @NotNull Function3<? super CoroutineScope, ? super Float, ? super Continuation<? super Unit>, ? extends Object> onDragStopped2, boolean reverseDirection) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter(onDragStarted2, (String)"onDragStarted");
        Intrinsics.checkNotNullParameter(onDragStopped2, (String)"onDragStopped");
        this.state = state2;
        this.orientation = orientation;
        this.enabled = enabled;
        this.interactionSource = interactionSource;
        this.startDragImmediately = startDragImmediately;
        this.onDragStarted = onDragStarted2;
        this.onDragStopped = onDragStopped2;
        this.reverseDirection = reverseDirection;
    }

    @Override
    @NotNull
    public DraggableNode create() {
        return new DraggableNode(this.state, CanDrag, this.orientation, this.enabled, this.interactionSource, this.startDragImmediately, this.onDragStarted, this.onDragStopped, this.reverseDirection);
    }

    @Override
    public void update(@NotNull DraggableNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.update(this.state, CanDrag, this.orientation, this.enabled, this.interactionSource, this.startDragImmediately, this.onDragStarted, this.onDragStopped, this.reverseDirection);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        DraggableElement cfr_ignored_0 = (DraggableElement)other;
        if (!Intrinsics.areEqual((Object)this.state, (Object)((DraggableElement)other).state)) {
            return false;
        }
        if (this.orientation != ((DraggableElement)other).orientation) {
            return false;
        }
        if (this.enabled != ((DraggableElement)other).enabled) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.interactionSource, (Object)((DraggableElement)other).interactionSource)) {
            return false;
        }
        if (this.startDragImmediately != ((DraggableElement)other).startDragImmediately) {
            return false;
        }
        if (!Intrinsics.areEqual(this.onDragStarted, ((DraggableElement)other).onDragStarted)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.onDragStopped, ((DraggableElement)other).onDragStopped)) {
            return false;
        }
        return this.reverseDirection == ((DraggableElement)other).reverseDirection;
    }

    public int hashCode() {
        int result2 = this.state.hashCode();
        result2 = 31 * result2 + this.orientation.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.enabled);
        MutableInteractionSource mutableInteractionSource = this.interactionSource;
        result2 = 31 * result2 + (mutableInteractionSource != null ? mutableInteractionSource.hashCode() : 0);
        result2 = 31 * result2 + Boolean.hashCode(this.startDragImmediately);
        result2 = 31 * result2 + this.onDragStarted.hashCode();
        result2 = 31 * result2 + this.onDragStopped.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.reverseDirection);
        return result2;
    }

    private static final boolean CanDrag$lambda$0(PointerInputChange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

