/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation;

import androidx.compose.foundation.OverscrollEffect;
import androidx.compose.foundation.OverscrollFactory;
import androidx.compose.foundation.OverscrollKt;
import androidx.compose.foundation.gestures.BringIntoViewSpec;
import androidx.compose.foundation.gestures.FlingBehavior;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollableDefaults;
import androidx.compose.foundation.gestures.ScrollableNode;
import androidx.compose.foundation.gestures.ScrollableState;
import androidx.compose.foundation.interaction.MutableInteractionSource;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNode;
import androidx.compose.ui.node.CompositionLocalConsumerModifierNodeKt;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DelegatingNode;
import androidx.compose.ui.node.ObserverModifierNode;
import androidx.compose.ui.node.ObserverModifierNodeKt;
import androidx.compose.ui.unit.LayoutDirection;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nScrollingContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollingContainer.kt\nandroidx/compose/foundation/ScrollingContainerNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,338:1\n1#2:339\n*E\n"})
final class ScrollingContainerNode
extends DelegatingNode
implements CompositionLocalConsumerModifierNode,
ObserverModifierNode {
    @NotNull
    private ScrollableState state;
    @NotNull
    private Orientation orientation;
    private boolean enabled;
    private boolean reverseScrolling;
    @Nullable
    private FlingBehavior flingBehavior;
    @Nullable
    private MutableInteractionSource interactionSource;
    @Nullable
    private BringIntoViewSpec bringIntoViewSpec;
    private boolean useLocalOverscrollFactory;
    @Nullable
    private OverscrollEffect userProvidedOverscrollEffect;
    private final boolean shouldAutoInvalidate;
    @Nullable
    private ScrollableNode scrollableNode;
    @Nullable
    private DelegatableNode overscrollNode;
    @Nullable
    private OverscrollFactory localOverscrollFactory;
    @Nullable
    private OverscrollEffect localOverscrollFactoryCreatedOverscrollEffect;
    private boolean shouldReverseDirection;

    public ScrollingContainerNode(@NotNull ScrollableState state2, @NotNull Orientation orientation, boolean enabled, boolean reverseScrolling, @Nullable FlingBehavior flingBehavior, @Nullable MutableInteractionSource interactionSource, @Nullable BringIntoViewSpec bringIntoViewSpec, boolean useLocalOverscrollFactory, @Nullable OverscrollEffect userProvidedOverscrollEffect) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.state = state2;
        this.orientation = orientation;
        this.enabled = enabled;
        this.reverseScrolling = reverseScrolling;
        this.flingBehavior = flingBehavior;
        this.interactionSource = interactionSource;
        this.bringIntoViewSpec = bringIntoViewSpec;
        this.useLocalOverscrollFactory = useLocalOverscrollFactory;
        this.userProvidedOverscrollEffect = userProvidedOverscrollEffect;
    }

    @Override
    public boolean getShouldAutoInvalidate() {
        return this.shouldAutoInvalidate;
    }

    @Nullable
    public final OverscrollEffect getOverscrollEffect() {
        return this.useLocalOverscrollFactory ? this.localOverscrollFactoryCreatedOverscrollEffect : this.userProvidedOverscrollEffect;
    }

    @Override
    public void onAttach() {
        this.shouldReverseDirection = this.shouldReverseDirection();
        this.attachOverscrollNodeIfNeeded();
        if (this.scrollableNode == null) {
            this.scrollableNode = (ScrollableNode)this.delegate((DelegatableNode)new ScrollableNode(this.state, this.getOverscrollEffect(), this.flingBehavior, this.orientation, this.enabled, this.shouldReverseDirection, this.interactionSource, this.bringIntoViewSpec));
        }
    }

    @Override
    public void onDetach() {
        block0: {
            DelegatableNode delegatableNode = this.overscrollNode;
            if (delegatableNode == null) break block0;
            DelegatableNode it = delegatableNode;
            boolean bl = false;
            this.undelegate(it);
        }
    }

    @Override
    public void onLayoutDirectionChange() {
        boolean reverseDirection = this.shouldReverseDirection();
        if (this.shouldReverseDirection != reverseDirection) {
            this.shouldReverseDirection = reverseDirection;
            this.update(this.state, this.orientation, this.useLocalOverscrollFactory, this.getOverscrollEffect(), this.enabled, this.reverseScrolling, this.flingBehavior, this.interactionSource, this.bringIntoViewSpec);
        }
    }

    public final void update(@NotNull ScrollableState state2, @NotNull Orientation orientation, boolean useLocalOverscrollFactory, @Nullable OverscrollEffect overscrollEffect, boolean enabled, boolean reverseScrolling, @Nullable FlingBehavior flingBehavior, @Nullable MutableInteractionSource interactionSource, @Nullable BringIntoViewSpec bringIntoViewSpec) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            this.state = state2;
            this.orientation = orientation;
            boolean useLocalOverscrollFactoryChanged = false;
            if (this.useLocalOverscrollFactory != useLocalOverscrollFactory) {
                useLocalOverscrollFactoryChanged = true;
                this.useLocalOverscrollFactory = useLocalOverscrollFactory;
            }
            boolean overscrollEffectChanged = false;
            if (!Intrinsics.areEqual((Object)this.userProvidedOverscrollEffect, (Object)overscrollEffect)) {
                overscrollEffectChanged = true;
                this.userProvidedOverscrollEffect = overscrollEffect;
            }
            if (useLocalOverscrollFactoryChanged || overscrollEffectChanged && !useLocalOverscrollFactory) {
                DelegatableNode delegatableNode = this.overscrollNode;
                if (delegatableNode != null) {
                    DelegatableNode it = delegatableNode;
                    boolean bl = false;
                    this.undelegate(it);
                }
                this.overscrollNode = null;
                this.attachOverscrollNodeIfNeeded();
            }
            this.enabled = enabled;
            this.reverseScrolling = reverseScrolling;
            this.flingBehavior = flingBehavior;
            this.interactionSource = interactionSource;
            this.bringIntoViewSpec = bringIntoViewSpec;
            this.shouldReverseDirection = this.shouldReverseDirection();
            ScrollableNode scrollableNode = this.scrollableNode;
            if (scrollableNode == null) break block4;
            scrollableNode.update(state2, orientation, this.getOverscrollEffect(), enabled, this.shouldReverseDirection, flingBehavior, interactionSource, bringIntoViewSpec);
        }
    }

    public final boolean shouldReverseDirection() {
        LayoutDirection layoutDirection = LayoutDirection.Ltr;
        if (this.isAttached()) {
            layoutDirection = DelegatableNodeKt.requireLayoutDirection(this);
        }
        return ScrollableDefaults.INSTANCE.reverseDirection(layoutDirection, this.orientation, this.reverseScrolling);
    }

    private final void attachOverscrollNodeIfNeeded() {
        block3: {
            block2: {
                DelegatableNode node2;
                OverscrollEffect effect2;
                if (this.overscrollNode != null) break block2;
                if (this.useLocalOverscrollFactory) {
                    ObserverModifierNodeKt.observeReads((Modifier.Node)this, (Function0<Unit>)((Function0)() -> ScrollingContainerNode.attachOverscrollNodeIfNeeded$lambda$2(this)));
                }
                if ((effect2 = this.getOverscrollEffect()) == null || (node2 = effect2.getNode()).getNode().isAttached()) break block3;
                this.overscrollNode = this.delegate(node2);
                break block3;
            }
            DelegatableNode delegatableNode = this.overscrollNode;
            if (delegatableNode == null) break block3;
            DelegatableNode it = delegatableNode;
            boolean bl = false;
            if (!it.getNode().isAttached()) {
                this.delegate(it);
            }
        }
    }

    @Override
    public void onObservedReadsChanged() {
        block2: {
            OverscrollFactory factory2 = (OverscrollFactory)CompositionLocalConsumerModifierNodeKt.currentValueOf(this, OverscrollKt.getLocalOverscrollFactory());
            if (Intrinsics.areEqual((Object)factory2, (Object)this.localOverscrollFactory)) break block2;
            this.localOverscrollFactory = factory2;
            this.localOverscrollFactoryCreatedOverscrollEffect = null;
            DelegatableNode delegatableNode = this.overscrollNode;
            if (delegatableNode != null) {
                DelegatableNode it = delegatableNode;
                boolean bl = false;
                this.undelegate(it);
            }
            this.overscrollNode = null;
            this.attachOverscrollNodeIfNeeded();
            ScrollableNode scrollableNode = this.scrollableNode;
            if (scrollableNode != null) {
                scrollableNode.update(this.state, this.orientation, this.getOverscrollEffect(), this.enabled, this.shouldReverseDirection, this.flingBehavior, this.interactionSource, this.bringIntoViewSpec);
            }
        }
    }

    private static final Unit attachOverscrollNodeIfNeeded$lambda$2(ScrollingContainerNode this$0) {
        OverscrollFactory overscrollFactory = this$0.localOverscrollFactory = (OverscrollFactory)CompositionLocalConsumerModifierNodeKt.currentValueOf(this$0, OverscrollKt.getLocalOverscrollFactory());
        this$0.localOverscrollFactoryCreatedOverscrollEffect = overscrollFactory != null ? overscrollFactory.createOverscrollEffect() : null;
        return Unit.INSTANCE;
    }
}

