/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.collection.IntList;
import androidx.collection.IntObjectMap;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.ArcMode;
import androidx.compose.animation.core.ArcSpline;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import androidx.compose.animation.core.VectorizedKeyframeSpecElementInfo;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nVectorizedAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedKeyframesSpec\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 IntList.kt\nandroidx/collection/IntList\n+ 4 VectorConverters.kt\nandroidx/compose/animation/core/VectorConvertersKt\n*L\n1#1,1038:1\n216#2,2:1039\n216#2,2:1041\n65#3:1043\n65#3:1044\n65#3:1045\n70#3:1047\n71#4:1046\n*S KotlinDebug\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedKeyframesSpec\n*L\n246#1:1039,2\n259#1:1041,2\n301#1:1043\n304#1:1044\n335#1:1045\n469#1:1047\n418#1:1046\n*E\n"})
public final class VectorizedKeyframesSpec<V extends AnimationVector>
implements VectorizedDurationBasedAnimationSpec<V> {
    @NotNull
    private final IntList timestamps;
    @NotNull
    private final IntObjectMap<VectorizedKeyframeSpecElementInfo<V>> keyframes;
    private final int durationMillis;
    private final int delayMillis;
    @NotNull
    private final Easing defaultEasing;
    private final int initialArcMode;
    @NotNull
    private int[] modes;
    @NotNull
    private float[] times;
    @Nullable
    private V valueVector;
    @Nullable
    private V velocityVector;
    @Nullable
    private V lastInitialValue;
    @Nullable
    private V lastTargetValue;
    @NotNull
    private float[] posArray;
    @NotNull
    private float[] slopeArray;
    @NotNull
    private ArcSpline arcSpline;
    public static final int $stable = 8;

    private VectorizedKeyframesSpec(IntList timestamps, IntObjectMap<VectorizedKeyframeSpecElementInfo<V>> keyframes, int durationMillis, int delayMillis, Easing defaultEasing, int initialArcMode) {
        Intrinsics.checkNotNullParameter((Object)timestamps, (String)"timestamps");
        Intrinsics.checkNotNullParameter(keyframes, (String)"keyframes");
        Intrinsics.checkNotNullParameter((Object)defaultEasing, (String)"defaultEasing");
        this.timestamps = timestamps;
        this.keyframes = keyframes;
        this.durationMillis = durationMillis;
        this.delayMillis = delayMillis;
        this.defaultEasing = defaultEasing;
        this.initialArcMode = initialArcMode;
        this.modes = VectorizedAnimationSpecKt.access$getEmptyIntArray$p();
        this.times = VectorizedAnimationSpecKt.access$getEmptyFloatArray$p();
        this.posArray = VectorizedAnimationSpecKt.access$getEmptyFloatArray$p();
        this.slopeArray = VectorizedAnimationSpecKt.access$getEmptyFloatArray$p();
        this.arcSpline = VectorizedAnimationSpecKt.access$getEmptyArcSpline$p();
    }

    @Override
    public int getDurationMillis() {
        return this.durationMillis;
    }

    @Override
    public int getDelayMillis() {
        return this.delayMillis;
    }

    private final void init(V initialValue, V targetValue, V initialVelocity) {
        int n;
        Object object;
        boolean requiresArcSpline;
        boolean bl = requiresArcSpline = this.arcSpline != VectorizedAnimationSpecKt.access$getEmptyArcSpline$p();
        if (this.valueVector == null) {
            this.valueVector = AnimationVectorsKt.newInstance(initialValue);
            this.velocityVector = AnimationVectorsKt.newInstance(initialVelocity);
            int n2 = 0;
            Object this_$iv = this.timestamps;
            int $i$f$getSize = 0;
            int n3 = this_$iv._size;
            this_$iv = new float[n3];
            object = this;
            while (n2 < n3) {
                $i$f$getSize = n2++;
                this_$iv[$i$f$getSize] = (IntList)((float)this.timestamps.get($i$f$getSize) / (float)1000L);
            }
            ((VectorizedKeyframesSpec)object).times = (float[])this_$iv;
            this_$iv = this.timestamps;
            $i$f$getSize = 0;
            n3 = this_$iv._size;
            int[] nArray = new int[n3];
            object = this;
            for (n2 = 0; n2 < n3; ++n2) {
                int mode;
                n = n2;
                VectorizedKeyframeSpecElementInfo vectorizedKeyframeSpecElementInfo = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(this.timestamps.get(n));
                int n4 = mode = vectorizedKeyframeSpecElementInfo != null ? vectorizedKeyframeSpecElementInfo.getArcMode--9T-Mq4() : this.initialArcMode;
                if (!ArcMode.equals-impl0(mode, ArcMode.Companion.getArcLinear--9T-Mq4())) {
                    requiresArcSpline = true;
                }
                nArray[n] = mode;
            }
            ((VectorizedKeyframesSpec)object).modes = nArray;
        }
        if (!requiresArcSpline) {
            return;
        }
        if (this.arcSpline == VectorizedAnimationSpecKt.access$getEmptyArcSpline$p() || !Intrinsics.areEqual(this.lastInitialValue, initialValue) || !Intrinsics.areEqual(this.lastTargetValue, targetValue)) {
            this.lastInitialValue = initialValue;
            this.lastTargetValue = targetValue;
            int dimensionCount = ((AnimationVector)initialValue).getSize$animation_core() % 2 + ((AnimationVector)initialValue).getSize$animation_core();
            this.posArray = new float[dimensionCount];
            this.slopeArray = new float[dimensionCount];
            IntList this_$iv = this.timestamps;
            boolean $i$f$getSize = false;
            n = this_$iv._size;
            float[][] fArrayArray = new float[n][];
            for (int j = 0; j < n; ++j) {
                float[] fArray;
                int n5;
                Object object2;
                int n6;
                int n7 = j;
                int timestamp2 = this.timestamps.get(n7);
                VectorizedKeyframeSpecElementInfo info = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(timestamp2);
                if (timestamp2 == 0 && info == null) {
                    int n8 = 0;
                    float[] fArray2 = new float[dimensionCount];
                    n6 = n7;
                    object = fArrayArray;
                    while (n8 < dimensionCount) {
                        int n9 = n8++;
                        fArray2[n9] = ((AnimationVector)initialValue).get$animation_core(n9);
                    }
                    object2 = object;
                    n5 = n6;
                    fArray = fArray2;
                } else if (timestamp2 == this.getDurationMillis() && info == null) {
                    int n10 = 0;
                    float[] fArray3 = new float[dimensionCount];
                    object = fArrayArray;
                    while (n10 < dimensionCount) {
                        int n11 = n10++;
                        fArray3[n11] = ((AnimationVector)targetValue).get$animation_core(n11);
                    }
                    object2 = object;
                    n5 = n6;
                    fArray = fArray3;
                } else {
                    VectorizedKeyframeSpecElementInfo vectorizedKeyframeSpecElementInfo = info;
                    Intrinsics.checkNotNull((Object)vectorizedKeyframeSpecElementInfo);
                    Object vectorValue = vectorizedKeyframeSpecElementInfo.getVectorValue();
                    int n12 = 0;
                    float[] fArray4 = new float[dimensionCount];
                    object = fArrayArray;
                    while (n12 < dimensionCount) {
                        int n13 = n12++;
                        fArray4[n13] = ((AnimationVector)vectorValue).get$animation_core(n13);
                    }
                    object2 = object;
                    n5 = n6;
                    fArray = fArray4;
                }
                object2[n5] = fArray;
            }
            float[][] values = fArrayArray;
            this.arcSpline = new ArcSpline(this.modes, this.times, values);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        int timestampEnd;
        VectorizedKeyframeSpecElementInfo endKeyframe;
        VectorizedKeyframeSpecElementInfo vectorizedKeyframeSpecElementInfo;
        VectorizedKeyframeSpecElementInfo startValue;
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        int clampedPlayTime = (int)VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        VectorizedKeyframeSpecElementInfo keyframe = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(clampedPlayTime);
        if (keyframe != null) {
            return keyframe.getVectorValue();
        }
        if (clampedPlayTime >= this.getDurationMillis()) {
            return targetValue;
        }
        if (clampedPlayTime <= 0) {
            return initialValue;
        }
        this.init(initialValue, targetValue, initialVelocity);
        V v = this.valueVector;
        Intrinsics.checkNotNull(v);
        V valueVector = v;
        if (this.arcSpline != VectorizedAnimationSpecKt.access$getEmptyArcSpline$p()) {
            float easedTime = this.getEasedTime(clampedPlayTime);
            float[] posArray = this.posArray;
            this.arcSpline.getPos(easedTime, posArray);
            int n = posArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                ((AnimationVector)valueVector).set$animation_core(i2, posArray[i2]);
            }
            return valueVector;
        }
        int index = this.findEntryForTimeMillis(clampedPlayTime);
        float easedTime = this.getEasedTimeFromIndex(index, clampedPlayTime, true);
        int timestampStart = this.timestamps.get(index);
        VectorizedKeyframeSpecElementInfo startKeyframe = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(timestampStart);
        VectorizedKeyframeSpecElementInfo vectorizedKeyframeSpecElementInfo2 = startKeyframe;
        if (vectorizedKeyframeSpecElementInfo2 == null || (vectorizedKeyframeSpecElementInfo2 = vectorizedKeyframeSpecElementInfo2.getVectorValue()) == null) {
            vectorizedKeyframeSpecElementInfo2 = startValue = initialValue;
        }
        if ((vectorizedKeyframeSpecElementInfo = (endKeyframe = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(timestampEnd = this.timestamps.get(index + 1)))) == null || (vectorizedKeyframeSpecElementInfo = vectorizedKeyframeSpecElementInfo.getVectorValue()) == null) {
            vectorizedKeyframeSpecElementInfo = targetValue;
        }
        VectorizedKeyframeSpecElementInfo endValue = vectorizedKeyframeSpecElementInfo;
        int n = ((AnimationVector)valueVector).getSize$animation_core();
        for (int i3 = 0; i3 < n; ++i3) {
            void start$iv;
            float f = ((AnimationVector)((Object)startValue)).get$animation_core(i3);
            float stop$iv = ((AnimationVector)((Object)endValue)).get$animation_core(i3);
            boolean $i$f$lerp = false;
            ((AnimationVector)valueVector).set$animation_core(i3, (float)(start$iv * (1.0f - easedTime) + stop$iv * easedTime));
        }
        return valueVector;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        long playTimeMillis = playTimeNanos / 1000000L;
        long clampedPlayTime = VectorizedAnimationSpecKt.clampPlayTime(this, playTimeMillis);
        if (clampedPlayTime < 0L) {
            return initialVelocity;
        }
        this.init(initialValue, targetValue, initialVelocity);
        V v = this.velocityVector;
        Intrinsics.checkNotNull(v);
        V velocityVector = v;
        if (this.arcSpline != VectorizedAnimationSpecKt.access$getEmptyArcSpline$p()) {
            float easedTime = this.getEasedTime((int)clampedPlayTime);
            float[] slopeArray = this.slopeArray;
            this.arcSpline.getSlope(easedTime, slopeArray);
            int n = slopeArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                ((AnimationVector)velocityVector).set$animation_core(i2, slopeArray[i2]);
            }
            return velocityVector;
        }
        V startNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime - 1L, initialValue, targetValue, initialVelocity);
        V endNum = VectorizedAnimationSpecKt.getValueFromMillis(this, clampedPlayTime, initialValue, targetValue, initialVelocity);
        int n = ((AnimationVector)startNum).getSize$animation_core();
        for (int i3 = 0; i3 < n; ++i3) {
            ((AnimationVector)velocityVector).set$animation_core(i3, (((AnimationVector)startNum).get$animation_core(i3) - ((AnimationVector)endNum).get$animation_core(i3)) * 1000.0f);
        }
        return velocityVector;
    }

    private final float getEasedTime(int timeMillis) {
        int index = this.findEntryForTimeMillis(timeMillis);
        return this.getEasedTimeFromIndex(index, timeMillis, false);
    }

    private final float getEasedTimeFromIndex(int index, int timeMillis, boolean asFraction) {
        IntList this_$iv = this.timestamps;
        boolean $i$f$getLastIndex = false;
        if (index >= this_$iv._size - 1) {
            return (float)timeMillis / (float)1000L;
        }
        int timeMin = this.timestamps.get(index);
        int timeMax = this.timestamps.get(index + 1);
        if (timeMillis == timeMin) {
            return (float)timeMin / (float)1000L;
        }
        int timeRange = timeMax - timeMin;
        Object object = (VectorizedKeyframeSpecElementInfo)this.keyframes.get(timeMin);
        if (object == null || (object = ((VectorizedKeyframeSpecElementInfo)object).getEasing()) == null) {
            object = this.defaultEasing;
        }
        Object easing = object;
        float rawFraction = (float)(timeMillis - timeMin) / (float)timeRange;
        float easedFraction = easing.transform(rawFraction);
        if (asFraction) {
            return easedFraction;
        }
        return ((float)timeRange * easedFraction + (float)timeMin) / (float)1000L;
    }

    private final int findEntryForTimeMillis(int timeMillis) {
        int index = IntList.binarySearch$default((IntList)this.timestamps, (int)timeMillis, (int)0, (int)0, (int)6, null);
        return index < -1 ? -(index + 2) : index;
    }

    public /* synthetic */ VectorizedKeyframesSpec(IntList timestamps, IntObjectMap keyframes, int durationMillis, int delayMillis, Easing defaultEasing, int initialArcMode, DefaultConstructorMarker $constructor_marker) {
        this(timestamps, keyframes, durationMillis, delayMillis, defaultEasing, initialArcMode);
    }
}

