/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.annotation.RestrictTo;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.animation.core.AnimationStateKt;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.AnimationVectorsKt;
import androidx.compose.animation.core.FiniteAnimationSpec;
import androidx.compose.animation.core.MutableTransitionState;
import androidx.compose.animation.core.SeekableTransitionState;
import androidx.compose.animation.core.SpringSpec;
import androidx.compose.animation.core.SuspendAnimationKt;
import androidx.compose.animation.core.TargetBasedAnimation;
import androidx.compose.animation.core.TransitionState;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VisibilityThresholdsKt;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.DisposableEffectResult;
import androidx.compose.runtime.DisposableEffectScope;
import androidx.compose.runtime.EffectsKt;
import androidx.compose.runtime.FloatState;
import androidx.compose.runtime.LongState;
import androidx.compose.runtime.MonotonicFrameClockKt;
import androidx.compose.runtime.MutableFloatState;
import androidx.compose.runtime.MutableLongState;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.PrimitiveSnapshotStateKt;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.SnapshotLongStateKt;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.snapshots.SnapshotStateList;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import kotlin.PublishedApi;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.CoroutineStart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nTransition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transition.kt\nandroidx/compose/animation/core/Transition\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 SnapshotLongState.kt\nandroidx/compose/runtime/SnapshotLongStateKt__SnapshotLongStateKt\n+ 4 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 5 Effects.kt\nandroidx/compose/runtime/EffectsKt\n+ 6 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 7 Effects.kt\nandroidx/compose/runtime/EffectsKt$rememberCoroutineScope$1\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 9 Effects.kt\nandroidx/compose/runtime/DisposableEffectScope\n*L\n1#1,2141:1\n85#2:2142\n113#2,2:2143\n85#2:2145\n113#2,2:2146\n85#2:2154\n113#2,2:2155\n85#2:2157\n113#2,2:2158\n85#2:2174\n78#3:2148\n107#3,2:2149\n78#3:2151\n107#3,2:2152\n103#4:2160\n35#4,5:2161\n104#4:2166\n103#4:2167\n35#4,5:2168\n104#4:2173\n35#4,5:2175\n35#4,5:2180\n35#4,5:2185\n35#4,5:2190\n35#4,5:2195\n35#4,5:2200\n35#4,5:2205\n35#4,5:2210\n35#4,5:2235\n35#4,5:2240\n35#4,5:2245\n35#4,5:2250\n35#4,5:2255\n35#4,5:2260\n35#4,5:2265\n35#4,5:2270\n35#4,5:2275\n35#4,5:2280\n270#4,2:2285\n35#4,5:2287\n272#4:2292\n35#4,5:2293\n557#5:2215\n554#5,6:2216\n1247#6,3:2222\n1250#6,3:2226\n1247#6,6:2229\n555#7:2225\n1#8:2298\n64#9,5:2299\n*S KotlinDebug\n*F\n+ 1 Transition.kt\nandroidx/compose/animation/core/Transition\n*L\n916#1:2142\n916#1:2143,2\n923#1:2145\n923#1:2146,2\n953#1:2154\n953#1:2155,2\n969#1:2157\n969#1:2158,2\n998#1:2174\n930#1:2148\n930#1:2149,2\n950#1:2151\n950#1:2152,2\n987#1:2160\n987#1:2161,5\n987#1:2166\n988#1:2167\n988#1:2168,5\n988#1:2173\n1002#1:2175,5\n1003#1:2180,5\n1036#1:2185,5\n1045#1:2190,5\n1083#1:2195,5\n1121#1:2200,5\n1134#1:2205,5\n1168#1:2210,5\n1220#1:2235,5\n1221#1:2240,5\n1236#1:2245,5\n1237#1:2250,5\n1245#1:2255,5\n1246#1:2260,5\n1251#1:2265,5\n1252#1:2270,5\n1262#1:2275,5\n1263#1:2280,5\n1267#1:2285,2\n1267#1:2287,5\n1267#1:2292\n1276#1:2293,5\n1185#1:2215\n1185#1:2216,6\n1185#1:2222,3\n1185#1:2226,3\n1186#1:2229,6\n1185#1:2225\n1202#1:2299,5\n*E\n"})
public final class Transition<S> {
    @NotNull
    private final TransitionState<S> transitionState;
    @Nullable
    private final Transition<?> parentTransition;
    @Nullable
    private final String label;
    @NotNull
    private final MutableState targetState$delegate;
    @NotNull
    private final MutableState segment$delegate;
    @NotNull
    private final MutableLongState _playTimeNanos$delegate;
    @NotNull
    private final MutableLongState startTimeNanos$delegate;
    @NotNull
    private final MutableState updateChildrenNeeded$delegate;
    @NotNull
    private final SnapshotStateList<TransitionAnimationState<?, ?>> _animations;
    @NotNull
    private final SnapshotStateList<Transition<?>> _transitions;
    @NotNull
    private final MutableState isSeeking$delegate;
    private long lastSeekedTimeNanos;
    @NotNull
    private final State totalDurationNanos$delegate;

    public Transition(@NotNull TransitionState<S> transitionState, @Nullable Transition<?> parentTransition, @Nullable String label) {
        Intrinsics.checkNotNullParameter(transitionState, (String)"transitionState");
        this.transitionState = transitionState;
        this.parentTransition = parentTransition;
        this.label = label;
        this.targetState$delegate = SnapshotStateKt.mutableStateOf$default(this.getCurrentState(), null, 2, null);
        this.segment$delegate = SnapshotStateKt.mutableStateOf$default(new SegmentImpl<S>(this.getCurrentState(), this.getCurrentState()), null, 2, null);
        this._playTimeNanos$delegate = SnapshotLongStateKt.mutableLongStateOf(0L);
        this.startTimeNanos$delegate = SnapshotLongStateKt.mutableLongStateOf(Long.MIN_VALUE);
        this.updateChildrenNeeded$delegate = SnapshotStateKt.mutableStateOf$default(false, null, 2, null);
        this._animations = SnapshotStateKt.mutableStateListOf();
        this._transitions = SnapshotStateKt.mutableStateListOf();
        this.isSeeking$delegate = SnapshotStateKt.mutableStateOf$default(false, null, 2, null);
        this.totalDurationNanos$delegate = SnapshotStateKt.derivedStateOf(() -> Transition.totalDurationNanos_delegate$lambda$2(this));
        this.transitionState.transitionConfigured$animation_core(this);
    }

    @Nullable
    public final String getLabel() {
        return this.label;
    }

    @PublishedApi
    public Transition(@NotNull TransitionState<S> transitionState, @Nullable String label) {
        Intrinsics.checkNotNullParameter(transitionState, (String)"transitionState");
        this(transitionState, null, label);
    }

    public Transition(S initialState, @Nullable String label) {
        this(new MutableTransitionState<S>(initialState), null, label);
    }

    public final S getCurrentState() {
        return this.transitionState.getCurrentState();
    }

    /*
     * WARNING - void declaration
     */
    public final S getTargetState() {
        void $this$getValue$iv;
        State state2 = this.targetState$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (S)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setTargetState$animation_core(S s) {
        void $this$setValue$iv;
        MutableState mutableState = this.targetState$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(s);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Segment<S> getSegment() {
        void $this$getValue$iv;
        State state2 = this.segment$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Segment)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setSegment(Segment<S> segment) {
        void $this$setValue$iv;
        MutableState mutableState = this.segment$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(segment);
    }

    public final boolean isRunning() {
        return this.getStartTimeNanos$animation_core() != Long.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private final long get_playTimeNanos() {
        void $this$getValue$iv;
        LongState longState = this._playTimeNanos$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getLongValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void set_playTimeNanos(long l) {
        void $this$setValue$iv;
        MutableLongState mutableLongState = this._playTimeNanos$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setLongValue(l);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final long getPlayTimeNanos() {
        Transition<?> transition = this.parentTransition;
        return transition != null ? transition.getPlayTimeNanos() : this.get_playTimeNanos();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setPlayTimeNanos(long value2) {
        if (this.parentTransition == null) {
            this.set_playTimeNanos(value2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final long getStartTimeNanos$animation_core() {
        void $this$getValue$iv;
        LongState longState = this.startTimeNanos$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getLongValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setStartTimeNanos$animation_core(long l) {
        void $this$setValue$iv;
        MutableLongState mutableLongState = this.startTimeNanos$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setLongValue(l);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean getUpdateChildrenNeeded() {
        void $this$getValue$iv;
        State state2 = this.updateChildrenNeeded$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setUpdateChildrenNeeded(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.updateChildrenNeeded$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(value$iv);
    }

    @NotNull
    public final List<TransitionAnimationState<?, ?>> getAnimations() {
        return this._animations;
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final boolean isSeeking() {
        void $this$getValue$iv;
        State state2 = this.isSeeking$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setSeeking$animation_core(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this.isSeeking$delegate;
        Object var3_3 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(value$iv);
    }

    public final long getLastSeekedTimeNanos$animation_core() {
        return this.lastSeekedTimeNanos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getHasInitialValueAnimations() {
        Object it;
        boolean bl;
        Object it$iv;
        Object item$iv$iv;
        int index$iv$iv;
        List $this$fastAny$iv = this._animations;
        boolean $i$f$fastAny = false;
        List $this$fastForEach$iv$iv = $this$fastAny$iv;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv$iv).size();
        for (index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
            bl = false;
            it = (TransitionAnimationState)it$iv;
            boolean bl2 = false;
            if (((TransitionAnimationState)it).getInitialValueState$animation_core() != null) {
                return true;
            }
            boolean bl3 = false;
            if (!bl3) continue;
            return true;
        }
        boolean bl4 = false;
        if (bl4) return true;
        $this$fastAny$iv = this._transitions;
        $i$f$fastAny = false;
        $this$fastForEach$iv$iv = $this$fastAny$iv;
        $i$f$fastForEach = false;
        index$iv$iv = 0;
        n = ((Collection)$this$fastForEach$iv$iv).size();
        while (index$iv$iv < n) {
            it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
            bl = false;
            it = (Transition)it$iv;
            boolean bl5 = false;
            if (((Transition)it).getHasInitialValueAnimations()) {
                return true;
            }
            ++index$iv$iv;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final long getTotalDurationNanos() {
        void $this$getValue$iv;
        State state2 = this.totalDurationNanos$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).longValue();
    }

    private final long calculateTotalDurationNanos() {
        Object it;
        Object item$iv;
        int index$iv;
        long maxDurationNanos = 0L;
        List $this$fastForEach$iv = this._animations;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            item$iv = $this$fastForEach$iv.get(index$iv);
            it = (TransitionAnimationState)item$iv;
            boolean bl = false;
            maxDurationNanos = Math.max(maxDurationNanos, ((TransitionAnimationState)it).getDurationNanos$animation_core());
        }
        $this$fastForEach$iv = this._transitions;
        $i$f$fastForEach = false;
        n = ((Collection)$this$fastForEach$iv).size();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            item$iv = $this$fastForEach$iv.get(index$iv);
            it = (Transition)item$iv;
            boolean bl = false;
            maxDurationNanos = Math.max(maxDurationNanos, super.calculateTotalDurationNanos());
        }
        return maxDurationNanos;
    }

    public final void onFrame$animation_core(long frameTimeNanos, float durationScale) {
        if (this.getStartTimeNanos$animation_core() == Long.MIN_VALUE) {
            this.onTransitionStart$animation_core(frameTimeNanos);
        }
        long deltaT = frameTimeNanos - this.getStartTimeNanos$animation_core();
        long scaledPlayTimeNanos = durationScale == 0.0f ? deltaT : MathKt.roundToLong((double)((double)deltaT / (double)durationScale));
        this.setPlayTimeNanos(scaledPlayTimeNanos);
        this.onFrame$animation_core(scaledPlayTimeNanos, durationScale == 0.0f);
    }

    public final void onFrame$animation_core(long scaledPlayTimeNanos, boolean scaleToEnd) {
        Object it;
        Object item$iv;
        int index$iv;
        if (this.getStartTimeNanos$animation_core() == Long.MIN_VALUE) {
            this.onTransitionStart$animation_core(scaledPlayTimeNanos);
        } else if (!this.transitionState.isRunning$animation_core()) {
            this.transitionState.setRunning$animation_core(true);
        }
        this.setUpdateChildrenNeeded(false);
        boolean allFinished = false;
        allFinished = true;
        List $this$fastForEach$iv = this._animations;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            item$iv = $this$fastForEach$iv.get(index$iv);
            it = (TransitionAnimationState)item$iv;
            boolean bl = false;
            if (!((TransitionAnimationState)it).isFinished$animation_core()) {
                ((TransitionAnimationState)it).onPlayTimeChanged$animation_core(scaledPlayTimeNanos, scaleToEnd);
            }
            if (((TransitionAnimationState)it).isFinished$animation_core()) continue;
            allFinished = false;
        }
        $this$fastForEach$iv = this._transitions;
        $i$f$fastForEach = false;
        n = ((Collection)$this$fastForEach$iv).size();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            item$iv = $this$fastForEach$iv.get(index$iv);
            it = (Transition)item$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(((Transition)it).getTargetState(), ((Transition)it).getCurrentState())) {
                ((Transition)it).onFrame$animation_core(scaledPlayTimeNanos, scaleToEnd);
            }
            if (Intrinsics.areEqual(((Transition)it).getTargetState(), ((Transition)it).getCurrentState())) continue;
            allFinished = false;
        }
        if (allFinished) {
            this.onTransitionEnd$animation_core();
        }
    }

    public final void onTransitionStart$animation_core(long frameTimeNanos) {
        this.setStartTimeNanos$animation_core(frameTimeNanos);
        this.transitionState.setRunning$animation_core(true);
    }

    public final void onDisposed$animation_core() {
        this.onTransitionEnd$animation_core();
        this.transitionState.transitionRemoved$animation_core();
    }

    public final void onTransitionEnd$animation_core() {
        this.setStartTimeNanos$animation_core(Long.MIN_VALUE);
        if (this.transitionState instanceof MutableTransitionState) {
            ((MutableTransitionState)this.transitionState).setCurrentState$animation_core(this.getTargetState());
        }
        this.setPlayTimeNanos(0L);
        this.transitionState.setRunning$animation_core(false);
        List $this$fastForEach$iv = this._transitions;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            Object item$iv = $this$fastForEach$iv.get(index$iv);
            Transition it = (Transition)item$iv;
            boolean bl = false;
            it.onTransitionEnd$animation_core();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @JvmName(name="seek")
    public final void seek(S initialState, S targetState, long playTimeNanos) {
        Object it;
        Object item$iv;
        int index$iv;
        this.setStartTimeNanos$animation_core(Long.MIN_VALUE);
        this.transitionState.setRunning$animation_core(false);
        if (!(this.isSeeking() && Intrinsics.areEqual(this.getCurrentState(), initialState) && Intrinsics.areEqual(this.getTargetState(), targetState))) {
            if (!Intrinsics.areEqual(this.getCurrentState(), initialState) && this.transitionState instanceof MutableTransitionState) {
                ((MutableTransitionState)this.transitionState).setCurrentState$animation_core(initialState);
            }
            this.setTargetState$animation_core(targetState);
            this.setSeeking$animation_core(true);
            this.setSegment(new SegmentImpl<S>(initialState, targetState));
        }
        List $this$fastForEach$iv = this._transitions;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            item$iv = $this$fastForEach$iv.get(index$iv);
            it = (Transition)item$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type androidx.compose.animation.core.Transition<kotlin.Any>");
            Transition it2 = it;
            boolean bl2 = false;
            if (!it2.isSeeking()) continue;
            it2.seek(it2.getCurrentState(), it2.getTargetState(), playTimeNanos);
        }
        $this$fastForEach$iv = this._animations;
        $i$f$fastForEach = false;
        n = ((Collection)$this$fastForEach$iv).size();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            item$iv = $this$fastForEach$iv.get(index$iv);
            it = (TransitionAnimationState)item$iv;
            boolean bl = false;
            ((TransitionAnimationState)it).seekTo$animation_core(playTimeNanos);
        }
        this.lastSeekedTimeNanos = playTimeNanos;
    }

    public final boolean addTransition$animation_core(@NotNull Transition<?> transition) {
        Intrinsics.checkNotNullParameter(transition, (String)"transition");
        return this._transitions.add(transition);
    }

    public final boolean removeTransition$animation_core(@NotNull Transition<?> transition) {
        Intrinsics.checkNotNullParameter(transition, (String)"transition");
        return this._transitions.remove(transition);
    }

    public final boolean addAnimation$animation_core(@NotNull TransitionAnimationState<?, ?> animation) {
        Intrinsics.checkNotNullParameter(animation, (String)"animation");
        return this._animations.add(animation);
    }

    public final void removeAnimation$animation_core(@NotNull TransitionAnimationState<?, ?> animation) {
        Intrinsics.checkNotNullParameter(animation, (String)"animation");
        this._animations.remove(animation);
    }

    public final void updateTarget$animation_core(S targetState) {
        if (!Intrinsics.areEqual(this.getTargetState(), targetState)) {
            this.setSegment(new SegmentImpl<S>(this.getTargetState(), targetState));
            if (!Intrinsics.areEqual(this.getCurrentState(), this.getTargetState())) {
                this.transitionState.setCurrentState$animation_core(this.getTargetState());
            }
            this.setTargetState$animation_core(targetState);
            if (!this.isRunning()) {
                this.setUpdateChildrenNeeded(true);
            }
            List $this$fastForEach$iv = this._animations;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                TransitionAnimationState it = (TransitionAnimationState)item$iv;
                boolean bl = false;
                it.resetAnimation$animation_core();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void animateTo$animation_core(S targetState, @Nullable Composer $composer, int $changed) {
        block14: {
            $composer = $composer.startRestartGroup(-1493585151);
            ComposerKt.sourceInformation($composer, "C(animateTo):Transition.kt#pdpnli");
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= (($changed & 8) == 0 ? $composer.changed(targetState) : $composer.changedInstance(targetState)) ? 4 : 2;
            }
            if (($changed & 0x30) == 0) {
                $dirty |= $composer.changed(this) ? 32 : 16;
            }
            if (($dirty & 0x13) != 18 || !$composer.getSkipping()) {
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart(-1493585151, $dirty, -1, "androidx.compose.animation.core.Transition.animateTo (Transition.kt:1176)");
                }
                if (!this.isSeeking()) {
                    $composer.startReplaceGroup(1822801203);
                    ComposerKt.sourceInformation($composer, "");
                    this.updateTarget$animation_core(targetState);
                    if (!Intrinsics.areEqual(targetState, this.getCurrentState()) || this.isRunning() || this.getUpdateChildrenNeeded()) {
                        Object object;
                        void $this$cache$iv;
                        CoroutineScope coroutineScope;
                        Object object2;
                        void $this$cache$iv$iv;
                        $composer.startReplaceGroup(1823032494);
                        ComposerKt.sourceInformation($composer, "1184@50127L24,1185@50207L1011,1185@50168L1050");
                        boolean bl = false;
                        boolean $i$f$rememberCoroutineScope = false;
                        ComposerKt.sourceInformationMarkerStart($composer, 773894976, "CC(rememberCoroutineScope)558@25470L68:Effects.kt#9igjgp");
                        Composer composer$iv = $composer;
                        ComposerKt.sourceInformationMarkerStart($composer, -954203484, "CC(remember):Effects.kt#9igjgp");
                        Composer composer = $composer;
                        boolean invalid$iv$iv = false;
                        boolean $i$f$cache = false;
                        Object it$iv$iv = $this$cache$iv$iv.rememberedValue();
                        boolean bl2 = false;
                        if (it$iv$iv == Composer.Companion.getEmpty()) {
                            boolean bl3 = false;
                            boolean bl4 = false;
                            CoroutineScope value$iv$iv = EffectsKt.createCompositionCoroutineScope((CoroutineContext)EmptyCoroutineContext.INSTANCE, composer$iv);
                            $this$cache$iv$iv.updateRememberedValue(value$iv$iv);
                            object2 = value$iv$iv;
                        } else {
                            object2 = it$iv$iv;
                        }
                        CoroutineScope coroutineScope2 = (CoroutineScope)object2;
                        ComposerKt.sourceInformationMarkerEnd($composer);
                        CoroutineScope coroutineScope3 = coroutineScope2;
                        ComposerKt.sourceInformationMarkerEnd($composer);
                        CoroutineScope coroutineScope4 = coroutineScope = coroutineScope3;
                        Transition transition = this;
                        ComposerKt.sourceInformationMarkerStart($composer, 335910458, "CC(remember):Transition.kt#9igjgp");
                        Composer $changed$iv = $composer;
                        boolean invalid$iv = $composer.changedInstance(coroutineScope) | ($dirty & 0x70) == 32;
                        boolean $i$f$cache2 = false;
                        Object it$iv = $this$cache$iv.rememberedValue();
                        boolean bl5 = false;
                        if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
                            Transition transition2 = transition;
                            CoroutineScope coroutineScope5 = coroutineScope4;
                            boolean bl6 = false;
                            Function1 function1 = arg_0 -> Transition.animateTo$lambda$14$lambda$13(coroutineScope, this, arg_0);
                            coroutineScope4 = coroutineScope5;
                            transition = transition2;
                            Function1 value$iv = function1;
                            $this$cache$iv.updateRememberedValue(value$iv);
                            object = value$iv;
                        } else {
                            object = it$iv;
                        }
                        Function1 function1 = (Function1)object;
                        ComposerKt.sourceInformationMarkerEnd($composer);
                        EffectsKt.DisposableEffect(coroutineScope4, transition, (Function1<? super DisposableEffectScope, ? extends DisposableEffectResult>)function1, $composer, 0x70 & $dirty);
                        $composer.endReplaceGroup();
                    } else {
                        $composer.startReplaceGroup(1824275067);
                        $composer.endReplaceGroup();
                    }
                    $composer.endReplaceGroup();
                } else {
                    $composer.startReplaceGroup(1824284987);
                    $composer.endReplaceGroup();
                }
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block14;
            scopeUpdateScope.updateScope((Function2<? super Composer, ? super Integer, Unit>)((Function2)(arg_0, arg_1) -> Transition.animateTo$lambda$15(this, targetState, $changed, arg_0, arg_1)));
        }
    }

    public final void seekAnimations$animation_core(long playTimeNanos) {
        Object it;
        Object item$iv;
        int index$iv;
        if (this.getStartTimeNanos$animation_core() == Long.MIN_VALUE) {
            this.setStartTimeNanos$animation_core(playTimeNanos);
        }
        this.setPlayTimeNanos(playTimeNanos);
        this.setUpdateChildrenNeeded(false);
        List $this$fastForEach$iv = this._animations;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            item$iv = $this$fastForEach$iv.get(index$iv);
            it = (TransitionAnimationState)item$iv;
            boolean bl = false;
            ((TransitionAnimationState)it).seekTo$animation_core(playTimeNanos);
        }
        $this$fastForEach$iv = this._transitions;
        $i$f$fastForEach = false;
        n = ((Collection)$this$fastForEach$iv).size();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            item$iv = $this$fastForEach$iv.get(index$iv);
            it = (Transition)item$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(((Transition)it).getTargetState(), ((Transition)it).getCurrentState())) continue;
            ((Transition)it).seekAnimations$animation_core(playTimeNanos);
        }
    }

    public final void clearInitialAnimations$animation_core() {
        Object it;
        Object item$iv;
        int index$iv;
        List $this$fastForEach$iv = this._animations;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            item$iv = $this$fastForEach$iv.get(index$iv);
            it = (TransitionAnimationState)item$iv;
            boolean bl = false;
            ((TransitionAnimationState)it).clearInitialAnimation$animation_core();
        }
        $this$fastForEach$iv = this._transitions;
        $i$f$fastForEach = false;
        n = ((Collection)$this$fastForEach$iv).size();
        for (index$iv = 0; index$iv < n; ++index$iv) {
            item$iv = $this$fastForEach$iv.get(index$iv);
            it = (Transition)item$iv;
            boolean bl = false;
            ((Transition)it).clearInitialAnimations$animation_core();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$fastFold$iv;
        List<TransitionAnimationState<?, ?>> list2 = this.getAnimations();
        String initial$iv = "Transition animation values: ";
        boolean $i$f$fastFold = false;
        Object accumulator$iv = null;
        accumulator$iv = initial$iv;
        void $this$fastForEach$iv$iv = $this$fastFold$iv;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv$iv).size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            void anim;
            Object item$iv$iv;
            Object e$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
            boolean bl = false;
            TransitionAnimationState transitionAnimationState = (TransitionAnimationState)e$iv;
            String acc = accumulator$iv;
            boolean bl2 = false;
            accumulator$iv = acc + (TransitionAnimationState)anim + ", ";
        }
        return accumulator$iv;
    }

    private final void onChildAnimationUpdated() {
        this.setUpdateChildrenNeeded(true);
        if (this.isSeeking()) {
            long maxDurationNanos = 0L;
            List $this$fastForEach$iv = this._animations;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                Object item$iv = $this$fastForEach$iv.get(index$iv);
                TransitionAnimationState it = (TransitionAnimationState)item$iv;
                boolean bl = false;
                maxDurationNanos = Math.max(maxDurationNanos, it.getDurationNanos$animation_core());
                it.seekTo$animation_core(this.lastSeekedTimeNanos);
            }
            this.setUpdateChildrenNeeded(false);
        }
    }

    public final void removeAnimation$animation_core(@NotNull DeferredAnimation<?, ?> deferredAnimation) {
        block0: {
            Intrinsics.checkNotNullParameter(deferredAnimation, (String)"deferredAnimation");
            DeferredAnimation.DeferredAnimationData<?, ?> deferredAnimationData = deferredAnimation.getData$animation_core();
            if (deferredAnimationData == null || (deferredAnimationData = deferredAnimationData.getAnimation()) == null) break block0;
            DeferredAnimation.DeferredAnimationData<?, ?> it = deferredAnimationData;
            boolean bl = false;
            this.removeAnimation$animation_core((TransitionAnimationState<?, ?>)((Object)it));
        }
    }

    private static final long totalDurationNanos_delegate$lambda$2(Transition this$0) {
        return this$0.calculateTotalDurationNanos();
    }

    private static final DisposableEffectResult animateTo$lambda$14$lambda$13(CoroutineScope $coroutineScope, Transition this$0, DisposableEffectScope $this$DisposableEffect) {
        Intrinsics.checkNotNullParameter((Object)$this$DisposableEffect, (String)"$this$DisposableEffect");
        BuildersKt.launch$default((CoroutineScope)$coroutineScope, null, (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            float F$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Transition<S> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        durationScale = SuspendAnimationKt.getDurationScale($this$launch.getCoroutineContext());
lbl7:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            this.L$0 = $this$launch;
                            this.F$0 = durationScale;
                            this.label = 1;
                            v0 = MonotonicFrameClockKt.withFrameNanos((Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(androidx.compose.animation.core.Transition float long ), (Ljava/lang/Long;)Lkotlin/Unit;)(this.this$0, (float)durationScale), (Continuation)this);
                            if (v0 != var4_2) continue;
                            return var4_2;
                        }
                        break;
                    }
                    case 1: {
                        durationScale = this.F$0;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(Transition this$0, float $durationScale, long it) {
                if (!this$0.isSeeking()) {
                    this$0.onFrame$animation_core(it / 1L, $durationScale);
                }
                return Unit.INSTANCE;
            }
        }), (int)1, null);
        DisposableEffectScope this_$iv = $this$DisposableEffect;
        boolean $i$f$onDispose = false;
        return new DisposableEffectResult(){

            public void dispose() {
                boolean bl = false;
            }
        };
    }

    private static final Unit animateTo$lambda$15(Transition $tmp1_rcvr, Object $targetState, int $$changed, Composer $composer, int $force) {
        $tmp1_rcvr.animateTo$animation_core($targetState, $composer, RecomposeScopeImplKt.updateChangedFlags($$changed | 1));
        return Unit.INSTANCE;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @SourceDebugExtension(value={"SMAP\nTransition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transition.kt\nandroidx/compose/animation/core/Transition$DeferredAnimation\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,2141:1\n85#2:2142\n113#2,2:2143\n*S KotlinDebug\n*F\n+ 1 Transition.kt\nandroidx/compose/animation/core/Transition$DeferredAnimation\n*L\n1619#1:2142\n1619#1:2143,2\n*E\n"})
    public final class DeferredAnimation<T, V extends AnimationVector> {
        @NotNull
        private final TwoWayConverter<T, V> typeConverter;
        @NotNull
        private final String label;
        @NotNull
        private final MutableState data$delegate;

        public DeferredAnimation(@NotNull TwoWayConverter<T, V> typeConverter, String label) {
            Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.typeConverter = typeConverter;
            this.label = label;
            this.data$delegate = SnapshotStateKt.mutableStateOf$default(null, null, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final DeferredAnimationData<T, V> getData$animation_core() {
            void $this$getValue$iv;
            State state2 = this.data$delegate;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return (DeferredAnimationData)$this$getValue$iv.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public final void setData$animation_core(@Nullable DeferredAnimationData<T, V> deferredAnimationData) {
            void $this$setValue$iv;
            MutableState mutableState = this.data$delegate;
            Object property$iv = null;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setValue(deferredAnimationData);
        }

        @NotNull
        public final State<T> animate(@NotNull Function1<? super Segment<S>, ? extends FiniteAnimationSpec<T>> transitionSpec, @NotNull Function1<? super S, ? extends T> targetValueByState) {
            DeferredAnimationData<? extends T, V> animData;
            Object object;
            Intrinsics.checkNotNullParameter(transitionSpec, (String)"transitionSpec");
            Intrinsics.checkNotNullParameter(targetValueByState, (String)"targetValueByState");
            DeferredAnimationData<? extends T, V> deferredAnimationData = this.getData$animation_core();
            if (deferredAnimationData == null) {
                object = new DeferredAnimationData(new TransitionAnimationState(Transition.this, targetValueByState.invoke(Transition.this.getCurrentState()), AnimationStateKt.createZeroVectorFrom(this.typeConverter, targetValueByState.invoke(Transition.this.getCurrentState())), this.typeConverter, this.label), transitionSpec, targetValueByState);
                Transition transition = Transition.this;
                Object $this$animate_u24lambda_u240 = object;
                boolean bl = false;
                this.setData$animation_core((DeferredAnimationData<T, V>)$this$animate_u24lambda_u240);
                transition.addAnimation$animation_core(((DeferredAnimationData)$this$animate_u24lambda_u240).getAnimation());
                deferredAnimationData = object;
            }
            DeferredAnimationData<? extends T, V> deferredAnimationData2 = animData = deferredAnimationData;
            object = Transition.this;
            DeferredAnimationData<? extends T, V> $this$animate_u24lambda_u241 = deferredAnimationData2;
            boolean bl = false;
            $this$animate_u24lambda_u241.setTargetValueByState(targetValueByState);
            $this$animate_u24lambda_u241.setTransitionSpec(transitionSpec);
            $this$animate_u24lambda_u241.updateAnimationStates(((Transition)object).getSegment());
            return deferredAnimationData2;
        }

        public final void setupSeeking$animation_core() {
            block0: {
                DeferredAnimationData<T, V> deferredAnimationData = this.getData$animation_core();
                if (deferredAnimationData == null) break block0;
                DeferredAnimationData<T, V> deferredAnimationData2 = deferredAnimationData;
                Transition transition = Transition.this;
                DeferredAnimationData<T, V> $this$setupSeeking_u24lambda_u242 = deferredAnimationData2;
                boolean bl = false;
                $this$setupSeeking_u24lambda_u242.getAnimation().updateInitialAndTargetValue$animation_core($this$setupSeeking_u24lambda_u242.getTargetValueByState().invoke(transition.getSegment().getInitialState()), $this$setupSeeking_u24lambda_u242.getTargetValueByState().invoke(transition.getSegment().getTargetState()), (FiniteAnimationSpec)$this$setupSeeking_u24lambda_u242.getTransitionSpec().invoke(transition.getSegment()));
            }
        }

        public final class DeferredAnimationData<T, V extends AnimationVector>
        implements State<T> {
            @NotNull
            private final TransitionAnimationState<T, V> animation;
            @NotNull
            private Function1<? super Segment<S>, ? extends FiniteAnimationSpec<T>> transitionSpec;
            @NotNull
            private Function1<? super S, ? extends T> targetValueByState;

            public DeferredAnimationData(@NotNull TransitionAnimationState<T, V> animation, @NotNull Function1<? super Segment<S>, ? extends FiniteAnimationSpec<T>> transitionSpec, Function1<? super S, ? extends T> targetValueByState) {
                Intrinsics.checkNotNullParameter(animation, (String)"animation");
                Intrinsics.checkNotNullParameter(transitionSpec, (String)"transitionSpec");
                Intrinsics.checkNotNullParameter(targetValueByState, (String)"targetValueByState");
                this.animation = animation;
                this.transitionSpec = transitionSpec;
                this.targetValueByState = targetValueByState;
            }

            @NotNull
            public final TransitionAnimationState<T, V> getAnimation() {
                return this.animation;
            }

            @NotNull
            public final Function1<Segment<S>, FiniteAnimationSpec<T>> getTransitionSpec() {
                return this.transitionSpec;
            }

            public final void setTransitionSpec(@NotNull Function1<? super Segment<S>, ? extends FiniteAnimationSpec<T>> function1) {
                Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
                this.transitionSpec = function1;
            }

            @NotNull
            public final Function1<S, T> getTargetValueByState() {
                return this.targetValueByState;
            }

            public final void setTargetValueByState(@NotNull Function1<? super S, ? extends T> function1) {
                Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
                this.targetValueByState = function1;
            }

            public final void updateAnimationStates(@NotNull Segment<S> segment) {
                Intrinsics.checkNotNullParameter(segment, (String)"segment");
                Object targetValue = this.targetValueByState.invoke(segment.getTargetState());
                if (Transition.this.isSeeking()) {
                    Object initialValue = this.targetValueByState.invoke(segment.getInitialState());
                    this.animation.updateInitialAndTargetValue$animation_core(initialValue, targetValue, (FiniteAnimationSpec)this.transitionSpec.invoke(segment));
                } else {
                    this.animation.updateTargetValue$animation_core(targetValue, (FiniteAnimationSpec)this.transitionSpec.invoke(segment));
                }
            }

            @Override
            public T getValue() {
                this.updateAnimationStates(Transition.this.getSegment());
                return this.animation.getValue();
            }
        }
    }

    public static interface Segment<S> {
        public S getInitialState();

        public S getTargetState();

        default public boolean isTransitioningTo(S $this$isTransitioningTo, S targetState) {
            return Intrinsics.areEqual($this$isTransitioningTo, this.getInitialState()) && Intrinsics.areEqual(targetState, this.getTargetState());
        }
    }

    private static final class SegmentImpl<S>
    implements Segment<S> {
        private final S initialState;
        private final S targetState;

        public SegmentImpl(S initialState, S targetState) {
            this.initialState = initialState;
            this.targetState = targetState;
        }

        @Override
        public S getInitialState() {
            return this.initialState;
        }

        @Override
        public S getTargetState() {
            return this.targetState;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Segment && Intrinsics.areEqual(this.getInitialState(), ((Segment)other).getInitialState()) && Intrinsics.areEqual(this.getTargetState(), ((Segment)other).getTargetState());
        }

        public int hashCode() {
            S s = this.getInitialState();
            S s2 = this.getTargetState();
            return (s != null ? s.hashCode() : 0) * 31 + (s2 != null ? s2.hashCode() : 0);
        }
    }

    @SourceDebugExtension(value={"SMAP\nTransition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transition.kt\nandroidx/compose/animation/core/Transition$TransitionAnimationState\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 SnapshotFloatState.kt\nandroidx/compose/runtime/PrimitiveSnapshotStateKt__SnapshotFloatStateKt\n+ 4 SnapshotLongState.kt\nandroidx/compose/runtime/SnapshotLongStateKt__SnapshotLongStateKt\n*L\n1#1,2141:1\n85#2:2142\n113#2,2:2143\n85#2:2145\n113#2,2:2146\n85#2:2148\n113#2,2:2149\n85#2:2151\n113#2,2:2152\n85#2:2157\n113#2,2:2158\n79#3:2154\n112#3,2:2155\n78#4:2160\n107#4,2:2161\n*S KotlinDebug\n*F\n+ 1 Transition.kt\nandroidx/compose/animation/core/Transition$TransitionAnimationState\n*L\n1300#1:2142\n1300#1:2143,2\n1308#1:2145\n1308#1:2146,2\n1316#1:2148\n1316#1:2149,2\n1330#1:2151\n1330#1:2152,2\n1343#1:2157\n1343#1:2158,2\n1331#1:2154\n1331#1:2155,2\n1347#1:2160\n1347#1:2161,2\n*E\n"})
    public static final class TransitionAnimationState<T, V extends AnimationVector>
    implements State<T> {
        @NotNull
        private final TwoWayConverter<T, V> typeConverter;
        @NotNull
        private final String label;
        @NotNull
        private final MutableState targetValue$delegate;
        @NotNull
        private final SpringSpec<T> defaultSpring;
        @NotNull
        private final MutableState animationSpec$delegate;
        @NotNull
        private final MutableState animation$delegate;
        @Nullable
        private SeekableTransitionState.SeekingAnimationState initialValueState;
        @Nullable
        private TargetBasedAnimation<T, V> initialValueAnimation;
        @NotNull
        private final MutableState isFinished$delegate;
        @NotNull
        private final MutableFloatState resetSnapValue$delegate;
        private boolean useOnlyInitialValue;
        @NotNull
        private final MutableState value$delegate;
        @NotNull
        private V velocityVector;
        @NotNull
        private final MutableLongState durationNanos$delegate;
        private boolean isSeeking;
        @NotNull
        private final FiniteAnimationSpec<T> interruptionSpec;
        final /* synthetic */ Transition<S> this$0;

        public TransitionAnimationState(@NotNull T initialValue, @NotNull V initialVelocityVector, @NotNull TwoWayConverter<T, V> typeConverter, String label) {
            Object object;
            Intrinsics.checkNotNullParameter(initialVelocityVector, (String)"initialVelocityVector");
            Intrinsics.checkNotNullParameter(typeConverter, (String)"typeConverter");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.this$0 = this$0;
            this.typeConverter = typeConverter;
            this.label = label;
            this.targetValue$delegate = SnapshotStateKt.mutableStateOf$default(initialValue, null, 2, null);
            this.defaultSpring = AnimationSpecKt.spring$default(0.0f, 0.0f, null, 7, null);
            this.animationSpec$delegate = SnapshotStateKt.mutableStateOf$default(this.defaultSpring, null, 2, null);
            this.animation$delegate = SnapshotStateKt.mutableStateOf$default(new TargetBasedAnimation<T, V>(this.getAnimationSpec(), this.typeConverter, initialValue, this.getTargetValue(), initialVelocityVector), null, 2, null);
            this.isFinished$delegate = SnapshotStateKt.mutableStateOf$default(true, null, 2, null);
            this.resetSnapValue$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf(-1.0f);
            this.value$delegate = SnapshotStateKt.mutableStateOf$default(initialValue, null, 2, null);
            this.velocityVector = initialVelocityVector;
            this.durationNanos$delegate = SnapshotLongStateKt.mutableLongStateOf(this.getAnimation().getDurationNanos());
            Float f = VisibilityThresholdsKt.getVisibilityThresholdMap().get(this.typeConverter);
            if (f != null) {
                float it = ((Number)f).floatValue();
                boolean bl = false;
                AnimationVector vector = (AnimationVector)this.typeConverter.getConvertToVector().invoke(initialValue);
                int n = vector.getSize$animation_core();
                for (int id = 0; id < n; ++id) {
                    vector.set$animation_core(id, it);
                }
                object = this.typeConverter.getConvertFromVector().invoke((Object)vector);
            } else {
                object = null;
            }
            Object visibilityThreshold = object;
            this.interruptionSpec = AnimationSpecKt.spring$default(0.0f, 0.0f, visibilityThreshold, 3, null);
        }

        /*
         * WARNING - void declaration
         */
        private final T getTargetValue() {
            void $this$getValue$iv;
            State state2 = this.targetValue$delegate;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return $this$getValue$iv.getValue();
        }

        /*
         * WARNING - void declaration
         */
        private final void setTargetValue(T t2) {
            void $this$setValue$iv;
            MutableState mutableState = this.targetValue$delegate;
            Object property$iv = null;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setValue(t2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FiniteAnimationSpec<T> getAnimationSpec() {
            void $this$getValue$iv;
            State state2 = this.animationSpec$delegate;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return (FiniteAnimationSpec)$this$getValue$iv.getValue();
        }

        /*
         * WARNING - void declaration
         */
        private final void setAnimationSpec(FiniteAnimationSpec<T> finiteAnimationSpec) {
            void $this$setValue$iv;
            MutableState mutableState = this.animationSpec$delegate;
            Object property$iv = null;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setValue(finiteAnimationSpec);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TargetBasedAnimation<T, V> getAnimation() {
            void $this$getValue$iv;
            State state2 = this.animation$delegate;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return (TargetBasedAnimation)$this$getValue$iv.getValue();
        }

        /*
         * WARNING - void declaration
         */
        private final void setAnimation(TargetBasedAnimation<T, V> targetBasedAnimation) {
            void $this$setValue$iv;
            MutableState mutableState = this.animation$delegate;
            Object property$iv = null;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setValue(targetBasedAnimation);
        }

        @Nullable
        public final SeekableTransitionState.SeekingAnimationState getInitialValueState$animation_core() {
            return this.initialValueState;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isFinished$animation_core() {
            void $this$getValue$iv;
            State state2 = this.isFinished$delegate;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return (Boolean)$this$getValue$iv.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public final void setFinished$animation_core(boolean bl) {
            void $this$setValue$iv;
            MutableState mutableState = this.isFinished$delegate;
            Object var3_3 = null;
            Boolean value$iv = bl;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setValue(value$iv);
        }

        /*
         * WARNING - void declaration
         */
        public final float getResetSnapValue$animation_core() {
            void $this$getValue$iv;
            FloatState floatState = this.resetSnapValue$delegate;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return $this$getValue$iv.getFloatValue();
        }

        /*
         * WARNING - void declaration
         */
        public final void setResetSnapValue$animation_core(float f) {
            void $this$setValue$iv;
            MutableFloatState mutableFloatState = this.resetSnapValue$delegate;
            Object property$iv = null;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setFloatValue(f);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T getValue() {
            void $this$getValue$iv;
            State state2 = this.value$delegate;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return $this$getValue$iv.getValue();
        }

        /*
         * WARNING - void declaration
         */
        public void setValue$animation_core(T t2) {
            void $this$setValue$iv;
            MutableState mutableState = this.value$delegate;
            Object property$iv = null;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setValue(t2);
        }

        /*
         * WARNING - void declaration
         */
        public final long getDurationNanos$animation_core() {
            void $this$getValue$iv;
            LongState longState = this.durationNanos$delegate;
            Object property$iv = null;
            boolean $i$f$getValue = false;
            return $this$getValue$iv.getLongValue();
        }

        /*
         * WARNING - void declaration
         */
        public final void setDurationNanos$animation_core(long l) {
            void $this$setValue$iv;
            MutableLongState mutableLongState = this.durationNanos$delegate;
            Object property$iv = null;
            boolean $i$f$setValue = false;
            $this$setValue$iv.setLongValue(l);
        }

        public final void onPlayTimeChanged$animation_core(long playTimeNanos, boolean scaleToEnd) {
            long playTime = scaleToEnd ? this.getAnimation().getDurationNanos() : playTimeNanos;
            this.setValue$animation_core(this.getAnimation().getValueFromNanos(playTime));
            this.velocityVector = this.getAnimation().getVelocityVectorFromNanos(playTime);
            if (this.getAnimation().isFinishedFromNanos(playTime)) {
                this.setFinished$animation_core(true);
            }
        }

        public final void seekTo$animation_core(long playTimeNanos) {
            if (!(this.getResetSnapValue$animation_core() == -1.0f)) {
                return;
            }
            this.isSeeking = true;
            if (Intrinsics.areEqual(this.getAnimation().getTargetValue(), this.getAnimation().getInitialValue())) {
                this.setValue$animation_core(this.getAnimation().getTargetValue());
            } else {
                this.setValue$animation_core(this.getAnimation().getValueFromNanos(playTimeNanos));
                this.velocityVector = this.getAnimation().getVelocityVectorFromNanos(playTimeNanos);
            }
        }

        private final void updateAnimation(T initialValue, boolean isInterrupted) {
            TargetBasedAnimation<T, V> targetBasedAnimation = this.initialValueAnimation;
            if (Intrinsics.areEqual(targetBasedAnimation != null ? targetBasedAnimation.getTargetValue() : null, this.getTargetValue())) {
                this.setAnimation(new TargetBasedAnimation<T, V>(this.interruptionSpec, this.typeConverter, initialValue, initialValue, AnimationVectorsKt.newInstance(this.velocityVector)));
                this.useOnlyInitialValue = true;
                this.setDurationNanos$animation_core(this.getAnimation().getDurationNanos());
                return;
            }
            FiniteAnimationSpec<T> specWithoutDelay = isInterrupted && !this.isSeeking ? (this.getAnimationSpec() instanceof SpringSpec ? this.getAnimationSpec() : this.interruptionSpec) : this.getAnimationSpec();
            AnimationSpec spec = this.this$0.getPlayTimeNanos() <= 0L ? (AnimationSpec)specWithoutDelay : AnimationSpecKt.delayed(specWithoutDelay, this.this$0.getPlayTimeNanos());
            this.setAnimation(new TargetBasedAnimation(spec, this.typeConverter, initialValue, this.getTargetValue(), this.velocityVector));
            this.setDurationNanos$animation_core(this.getAnimation().getDurationNanos());
            this.useOnlyInitialValue = false;
            this.this$0.onChildAnimationUpdated();
        }

        static /* synthetic */ void updateAnimation$default(TransitionAnimationState transitionAnimationState, Object object, boolean bl, int n, Object object2) {
            if ((n & 1) != 0) {
                object = transitionAnimationState.getValue();
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            transitionAnimationState.updateAnimation(object, bl);
        }

        public final void resetAnimation$animation_core() {
            this.setResetSnapValue$animation_core(-2.0f);
        }

        public final void clearInitialAnimation$animation_core() {
            this.initialValueAnimation = null;
            this.initialValueState = null;
            this.useOnlyInitialValue = false;
        }

        @NotNull
        public String toString() {
            return "current value: " + this.getValue() + ", target: " + this.getTargetValue() + ", spec: " + this.getAnimationSpec();
        }

        public final void updateTargetValue$animation_core(T targetValue, @NotNull FiniteAnimationSpec<T> animationSpec) {
            Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
            if (this.useOnlyInitialValue) {
                TargetBasedAnimation<T, V> targetBasedAnimation = this.initialValueAnimation;
                if (Intrinsics.areEqual(targetValue, targetBasedAnimation != null ? targetBasedAnimation.getTargetValue() : null)) {
                    return;
                }
            }
            if (Intrinsics.areEqual(this.getTargetValue(), targetValue) && this.getResetSnapValue$animation_core() == -1.0f) {
                return;
            }
            this.setTargetValue(targetValue);
            this.setAnimationSpec(animationSpec);
            T initialValue = this.getResetSnapValue$animation_core() == -3.0f ? targetValue : this.getValue();
            this.updateAnimation(initialValue, !this.isFinished$animation_core());
            this.setFinished$animation_core(this.getResetSnapValue$animation_core() == -3.0f);
            if (this.getResetSnapValue$animation_core() >= 0.0f) {
                long duration = this.getAnimation().getDurationNanos();
                this.setValue$animation_core(this.getAnimation().getValueFromNanos((long)((float)duration * this.getResetSnapValue$animation_core())));
            } else if (this.getResetSnapValue$animation_core() == -3.0f) {
                this.setValue$animation_core(targetValue);
            }
            this.useOnlyInitialValue = false;
            this.setResetSnapValue$animation_core(-1.0f);
        }

        public final void updateInitialAndTargetValue$animation_core(T initialValue, T targetValue, @NotNull FiniteAnimationSpec<T> animationSpec) {
            Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
            this.setTargetValue(targetValue);
            this.setAnimationSpec(animationSpec);
            if (Intrinsics.areEqual(this.getAnimation().getInitialValue(), initialValue) && Intrinsics.areEqual(this.getAnimation().getTargetValue(), targetValue)) {
                return;
            }
            TransitionAnimationState.updateAnimation$default(this, initialValue, false, 2, null);
        }
    }
}

