/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StartDelayVectorizedAnimationSpec<V extends AnimationVector>
implements VectorizedAnimationSpec<V> {
    @NotNull
    private final VectorizedAnimationSpec<V> vectorizedAnimationSpec;
    private final long startDelayNanos;

    public StartDelayVectorizedAnimationSpec(@NotNull VectorizedAnimationSpec<V> vectorizedAnimationSpec, long startDelayNanos) {
        Intrinsics.checkNotNullParameter(vectorizedAnimationSpec, (String)"vectorizedAnimationSpec");
        this.vectorizedAnimationSpec = vectorizedAnimationSpec;
        this.startDelayNanos = startDelayNanos;
    }

    @Override
    public boolean isInfinite() {
        return this.vectorizedAnimationSpec.isInfinite();
    }

    @Override
    public long getDurationNanos(@NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return this.vectorizedAnimationSpec.getDurationNanos(initialValue, targetValue, initialVelocity) + this.startDelayNanos;
    }

    @Override
    @NotNull
    public V getVelocityFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return playTimeNanos < this.startDelayNanos ? initialVelocity : this.vectorizedAnimationSpec.getVelocityFromNanos(playTimeNanos - this.startDelayNanos, initialValue, targetValue, initialVelocity);
    }

    @Override
    @NotNull
    public V getValueFromNanos(long playTimeNanos, @NotNull V initialValue, @NotNull V targetValue, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return playTimeNanos < this.startDelayNanos ? initialValue : this.vectorizedAnimationSpec.getValueFromNanos(playTimeNanos - this.startDelayNanos, initialValue, targetValue, initialVelocity);
    }

    public int hashCode() {
        return 31 * this.vectorizedAnimationSpec.hashCode() + Long.hashCode(this.startDelayNanos);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof StartDelayVectorizedAnimationSpec)) {
            return false;
        }
        return ((StartDelayVectorizedAnimationSpec)other).startDelayNanos == this.startDelayNanos && Intrinsics.areEqual(((StartDelayVectorizedAnimationSpec)other).vectorizedAnimationSpec, this.vectorizedAnimationSpec);
    }
}

