/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.annotation.IntRange;
import androidx.collection.IntList;
import androidx.collection.IntObjectMap;
import androidx.collection.MutableIntList;
import androidx.collection.MutableIntObjectMap;
import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.ArcMode;
import androidx.compose.animation.core.DurationBasedAnimationSpec;
import androidx.compose.animation.core.Easing;
import androidx.compose.animation.core.EasingKt;
import androidx.compose.animation.core.KeyframeBaseEntity;
import androidx.compose.animation.core.KeyframesSpecBaseConfig;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorizedKeyframeSpecElementInfo;
import androidx.compose.animation.core.VectorizedKeyframesSpec;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationSpec.kt\nandroidx/compose/animation/core/KeyframesSpec\n+ 2 IntObjectMap.kt\nandroidx/collection/IntObjectMap\n+ 3 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n*L\n1#1,1073:1\n382#2,4:1074\n354#2,6:1078\n364#2,3:1085\n367#2,9:1089\n386#2:1098\n425#2:1099\n425#2:1100\n1399#3:1084\n1270#3:1088\n*S KotlinDebug\n*F\n+ 1 AnimationSpec.kt\nandroidx/compose/animation/core/KeyframesSpec\n*L\n644#1:1074,4\n644#1:1078,6\n644#1:1085,3\n644#1:1089,9\n644#1:1098\n654#1:1099\n657#1:1100\n644#1:1084\n644#1:1088\n*E\n"})
public final class KeyframesSpec<T>
implements DurationBasedAnimationSpec<T> {
    @NotNull
    private final KeyframesSpecConfig<T> config;

    public KeyframesSpec(@NotNull KeyframesSpecConfig<T> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.config = config;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <V extends AnimationVector> VectorizedKeyframesSpec<V> vectorize(@NotNull TwoWayConverter<T, V> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        MutableIntList timestamps = new MutableIntList(this.config.getKeyframes$animation_core().getSize() + 2);
        MutableIntObjectMap timeToInfoMap = new MutableIntObjectMap(this.config.getKeyframes$animation_core().getSize());
        IntObjectMap this_$iv = (IntObjectMap)this.config.getKeyframes$animation_core();
        boolean $i$f$forEach = false;
        int[] k$iv = this_$iv.keys;
        Object[] v$iv = this_$iv.values;
        IntObjectMap this_$iv$iv = this_$iv;
        boolean $i$f$forEachIndexed = false;
        long[] m$iv$iv = this_$iv$iv.metadata;
        int lastIndex$iv$iv = m$iv$iv.length - 2;
        int i$iv$iv = 0;
        if (i$iv$iv <= lastIndex$iv$iv) {
            while (true) {
                long slot$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv = slot$iv$iv = m$iv$iv[i$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv = 8 - (~(i$iv$iv - lastIndex$iv$iv) >>> 31);
                    for (int j$iv$iv = 0; j$iv$iv < bitCount$iv$iv; ++j$iv$iv) {
                        long value$iv$iv$iv = slot$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv < 128L) {
                            void value2;
                            int index$iv$iv;
                            int index$iv = index$iv$iv = (i$iv$iv << 3) + j$iv$iv;
                            boolean bl = false;
                            KeyframeEntity keyframeEntity = (KeyframeEntity)v$iv[index$iv];
                            int key2 = k$iv[index$iv];
                            boolean bl2 = false;
                            timestamps.add(key2);
                            timeToInfoMap.set(key2, new VectorizedKeyframeSpecElementInfo((AnimationVector)converter.getConvertToVector().invoke(value2.getValue$animation_core()), value2.getEasing$animation_core(), value2.getArcMode--9T-Mq4$animation_core(), null));
                        }
                        slot$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv != 8) break;
                }
                if (i$iv$iv == lastIndex$iv$iv) break;
                ++i$iv$iv;
            }
        }
        this_$iv = (IntObjectMap)this.config.getKeyframes$animation_core();
        int key$iv = 0;
        boolean $i$f$contains = false;
        if (!this_$iv.containsKey(key$iv)) {
            timestamps.add(0, 0);
        }
        this_$iv = (IntObjectMap)this.config.getKeyframes$animation_core();
        key$iv = this.config.getDurationMillis();
        $i$f$contains = false;
        if (!this_$iv.containsKey(key$iv)) {
            timestamps.add(this.config.getDurationMillis());
        }
        timestamps.sort();
        return new VectorizedKeyframesSpec((IntList)timestamps, (IntObjectMap)timeToInfoMap, this.config.getDurationMillis(), this.config.getDelayMillis(), EasingKt.getLinearEasing(), ArcMode.Companion.getArcLinear--9T-Mq4(), null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class KeyframeEntity<T>
    extends KeyframeBaseEntity<T> {
        private int arcMode;
        public static final int $stable = 8;

        private KeyframeEntity(T value2, Easing easing, int arcMode) {
            Intrinsics.checkNotNullParameter((Object)easing, (String)"easing");
            super(value2, easing, null);
            this.arcMode = arcMode;
        }

        public /* synthetic */ KeyframeEntity(Object object, Easing easing, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                easing = EasingKt.getLinearEasing();
            }
            if ((n2 & 4) != 0) {
                n = ArcMode.Companion.getArcLinear--9T-Mq4();
            }
            this(object, easing, n, null);
        }

        public final int getArcMode--9T-Mq4$animation_core() {
            return this.arcMode;
        }

        public boolean equals(@Nullable Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof KeyframeEntity)) {
                return false;
            }
            return Intrinsics.areEqual(((KeyframeEntity)other).getValue$animation_core(), this.getValue$animation_core()) && Intrinsics.areEqual((Object)((KeyframeEntity)other).getEasing$animation_core(), (Object)this.getEasing$animation_core()) && ArcMode.equals-impl0(((KeyframeEntity)other).arcMode, this.arcMode);
        }

        public int hashCode() {
            Object t2 = this.getValue$animation_core();
            int result2 = t2 != null ? t2.hashCode() : 0;
            result2 = 31 * result2 + ArcMode.hashCode-impl(this.arcMode);
            result2 = 31 * result2 + this.getEasing$animation_core().hashCode();
            return result2;
        }

        public /* synthetic */ KeyframeEntity(Object value2, Easing easing, int arcMode, DefaultConstructorMarker $constructor_marker) {
            this(value2, easing, arcMode);
        }
    }

    @SourceDebugExtension(value={"SMAP\nAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationSpec.kt\nandroidx/compose/animation/core/KeyframesSpec$KeyframesSpecConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,1073:1\n1#2:1074\n26#3:1075\n*S KotlinDebug\n*F\n+ 1 AnimationSpec.kt\nandroidx/compose/animation/core/KeyframesSpec$KeyframesSpecConfig\n*L\n594#1:1075\n*E\n"})
    public static final class KeyframesSpecConfig<T>
    extends KeyframesSpecBaseConfig<T, KeyframeEntity<T>> {
        public KeyframesSpecConfig() {
            super(null);
        }

        @NotNull
        public KeyframeEntity<T> at(T $this$at, @IntRange(from=0L) int timeStamp) {
            KeyframeEntity keyframeEntity;
            KeyframeEntity it = keyframeEntity = new KeyframeEntity($this$at, null, 0, 6, null);
            boolean bl = false;
            this.getKeyframes$animation_core().set(timeStamp, it);
            return keyframeEntity;
        }
    }
}

