/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.FlingCalculator;
import androidx.compose.animation.SplineBasedDecayAnimationSpec_desktopKt;
import androidx.compose.animation.core.FloatDecayAnimationSpec;
import androidx.compose.ui.unit.Density;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class SplineBasedFloatDecayAnimationSpec
implements FloatDecayAnimationSpec {
    @NotNull
    private final FlingCalculator flingCalculator;

    public SplineBasedFloatDecayAnimationSpec(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        this.flingCalculator = new FlingCalculator(SplineBasedDecayAnimationSpec_desktopKt.getPlatformFlingScrollFriction(), density);
    }

    @Override
    public float getAbsVelocityThreshold() {
        return 0.0f;
    }

    private final float flingDistance(float startVelocity) {
        return this.flingCalculator.flingDistance(startVelocity) * Math.signum(startVelocity);
    }

    @Override
    public float getTargetValue(float initialValue, float initialVelocity) {
        return initialValue + this.flingDistance(initialVelocity);
    }

    @Override
    public float getValueFromNanos(long playTimeNanos, float initialValue, float initialVelocity) {
        long playTimeMillis = playTimeNanos / 1000000L;
        return initialValue + this.flingCalculator.flingInfo(initialVelocity).position(playTimeMillis);
    }

    @Override
    public long getDurationNanos(float initialValue, float initialVelocity) {
        return this.flingCalculator.flingDuration(initialVelocity) * 1000000L;
    }

    @Override
    public float getVelocityFromNanos(long playTimeNanos, float initialValue, float initialVelocity) {
        long playTimeMillis = playTimeNanos / 1000000L;
        return this.flingCalculator.flingInfo(initialVelocity).velocity(playTimeMillis);
    }
}

