/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.SplineBasedFloatDecayAnimationSpec;
import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.DecayAnimationSpecKt;
import androidx.compose.ui.unit.Density;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class SplineBasedDecayKt {
    private static final void computeSplineInfo(float[] splinePositions, float[] splineTimes, int nbSamples) {
        float xMin = 0.0f;
        float yMin = 0.0f;
        for (int i2 = 0; i2 < nbSamples; ++i2) {
            float alpha2 = (float)i2 / (float)nbSamples;
            float xMax = 1.0f;
            float x = 0.0f;
            float tx = 0.0f;
            float coef = 0.0f;
            while (!((double)Math.abs((tx = (coef = 3.0f * (x = xMin + (xMax - xMin) / 2.0f) * (1.0f - x)) * ((1.0f - x) * 0.175f + x * 0.35000002f) + x * x * x) - alpha2) < 1.0E-5)) {
                if (tx > alpha2) {
                    xMax = x;
                    continue;
                }
                xMin = x;
            }
            splinePositions[i2] = coef * ((1.0f - x) * 0.5f + x) + x * x * x;
            float yMax = 1.0f;
            float y = 0.0f;
            float dy = 0.0f;
            while (!((double)Math.abs((dy = (coef = 3.0f * (y = yMin + (yMax - yMin) / 2.0f) * (1.0f - y)) * ((1.0f - y) * 0.5f + y) + y * y * y) - alpha2) < 1.0E-5)) {
                if (dy > alpha2) {
                    yMax = y;
                    continue;
                }
                yMin = y;
            }
            splineTimes[i2] = coef * ((1.0f - y) * 0.175f + y * 0.35000002f) + y * y * y;
        }
        splineTimes[nbSamples] = 1.0f;
        splinePositions[nbSamples] = splineTimes[nbSamples];
    }

    @NotNull
    public static final <T> DecayAnimationSpec<T> splineBasedDecay(@NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return DecayAnimationSpecKt.generateDecayAnimationSpec(new SplineBasedFloatDecayAnimationSpec(density));
    }

    public static final /* synthetic */ void access$computeSplineInfo(float[] splinePositions, float[] splineTimes, int nbSamples) {
        SplineBasedDecayKt.computeSplineInfo(splinePositions, splineTimes, nbSamples);
    }
}

