/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.SizeAnimationModifierNode;
import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.FiniteAnimationSpec;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.unit.IntSize;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SizeAnimationModifierElement
extends ModifierNodeElement<SizeAnimationModifierNode> {
    @NotNull
    private final FiniteAnimationSpec<IntSize> animationSpec;
    @NotNull
    private final Alignment alignment;
    @Nullable
    private final Function2<IntSize, IntSize, Unit> finishedListener;

    public SizeAnimationModifierElement(@NotNull FiniteAnimationSpec<IntSize> animationSpec, @NotNull Alignment alignment, @Nullable Function2<? super IntSize, ? super IntSize, Unit> finishedListener) {
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
        this.animationSpec = animationSpec;
        this.alignment = alignment;
        this.finishedListener = finishedListener;
    }

    @Override
    @NotNull
    public SizeAnimationModifierNode create() {
        return new SizeAnimationModifierNode((AnimationSpec<IntSize>)this.animationSpec, this.alignment, this.finishedListener);
    }

    @Override
    public void update(@NotNull SizeAnimationModifierNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        node2.setAnimationSpec((AnimationSpec<IntSize>)this.animationSpec);
        node2.setListener(this.finishedListener);
        node2.setAlignment(this.alignment);
    }

    @NotNull
    public String toString() {
        return "SizeAnimationModifierElement(animationSpec=" + this.animationSpec + ", alignment=" + this.alignment + ", finishedListener=" + this.finishedListener + ")";
    }

    public int hashCode() {
        int result2 = this.animationSpec.hashCode();
        result2 = result2 * 31 + this.alignment.hashCode();
        result2 = result2 * 31 + (this.finishedListener == null ? 0 : this.finishedListener.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SizeAnimationModifierElement)) {
            return false;
        }
        SizeAnimationModifierElement sizeAnimationModifierElement = (SizeAnimationModifierElement)other;
        if (!Intrinsics.areEqual(this.animationSpec, sizeAnimationModifierElement.animationSpec)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.alignment, (Object)sizeAnimationModifierElement.alignment)) {
            return false;
        }
        return Intrinsics.areEqual(this.finishedListener, sizeAnimationModifierElement.finishedListener);
    }
}

