/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.core.FiniteAnimationSpec;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Fade {
    private final float alpha;
    @NotNull
    private final FiniteAnimationSpec<Float> animationSpec;

    public Fade(float alpha2, @NotNull FiniteAnimationSpec<Float> animationSpec) {
        Intrinsics.checkNotNullParameter(animationSpec, (String)"animationSpec");
        this.alpha = alpha2;
        this.animationSpec = animationSpec;
    }

    public final float getAlpha() {
        return this.alpha;
    }

    @NotNull
    public final FiniteAnimationSpec<Float> getAnimationSpec() {
        return this.animationSpec;
    }

    @NotNull
    public String toString() {
        return "Fade(alpha=" + this.alpha + ", animationSpec=" + this.animationSpec + ")";
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.alpha);
        result2 = result2 * 31 + this.animationSpec.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Fade)) {
            return false;
        }
        Fade fade = (Fade)other;
        if (Float.compare(this.alpha, fade.alpha) != 0) {
            return false;
        }
        return Intrinsics.areEqual(this.animationSpec, fade.animationSpec);
    }
}

