/*
 * Copyright (c) 2023, Azul Systems, Inc. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

// Mirror: none

package java.text;

import sun.text.CollatorUtilities;
import jdk.internal.icu.text.NormalizerBase;

final class NBNormalizedAzulIterator implements NormalizedAzulIterator {
    private NormalizerBase text;
    private RuleBasedCollator owner;

    private NBNormalizedAzulIterator(NormalizerBase text, RuleBasedCollator owner) {
        this.text = text;
        this.owner = owner;
    }

    public NBNormalizedAzulIterator(CharacterIterator sourceText, RuleBasedCollator owner) {
        NormalizerBase.Mode mode = CollatorUtilities.toNormalizerMode(owner.getDecomposition());
        text = new NormalizerBase(sourceText, mode);
        this.owner = owner;
    }

    public NBNormalizedAzulIterator(String sourceText, RuleBasedCollator owner) {
        NormalizerBase.Mode mode = CollatorUtilities.toNormalizerMode(owner.getDecomposition());
        text = new NormalizerBase(sourceText, mode);
        this.owner = owner;
    }

    @Override
    public int next() {
        return text.next();
    }

    @Override
    public int previous() {
        return text.previous();
    }

    // #ifdef AZ_LINUX
    @SuppressWarnings("deprecation")
    // #endif
    public int getBeginIndex() {
        return text.getBeginIndex();
    }

    // #ifdef AZ_LINUX
    @SuppressWarnings("deprecation")
    // #endif
    public int getEndIndex() {
        return text.getEndIndex();
    }

    public int getIndex() {
        return text.getIndex();
    }

    public int setIndex(int index) {
        return text.setIndex(index);
    }

    public void setIndexOnly(int index) {
        text.setIndexOnly(index);
    }

    @Override
    public void reset() {
        text.reset();
        NormalizerBase.Mode mode = CollatorUtilities.toNormalizerMode(owner.getDecomposition());
        text.setMode(mode);
    }

    @Override
    public boolean updateMode() {
        NormalizerBase.Mode textMode = text.getMode();
        NormalizerBase.Mode ownerMode = CollatorUtilities.toNormalizerMode(owner.getDecomposition());
        if (textMode != ownerMode) {
            text.setMode(ownerMode);
        }
        return true;
    }

    @Override
    public int done() {
        return NormalizerBase.DONE;
    }

    @Override
    public Object clone() {
        return new NBNormalizedAzulIterator((NormalizerBase) text.clone(), owner);
    }
}
