/* Copyright 2013 Azul Systems, Inc.    All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU General Public License version 2 only, as published by 
 * the Free Software Foundation. 
 *
 * Azul designates this particular file as subject to the "Classpath" exception 
 * as provided by Azul in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE.    See the GNU General Public License version 2 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 2 
 * along with this work; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please contact Azul Systems, Inc., 1173 Borregas Avenue, Sunnyvale, CA 94089
 * USA or visit www.azulsystems.com if you need additional information or have
 * any questions.
 *
 * File: @(#)Prefetch.java	1.5 06/06/06
 */

package com.azulsystems.util;

public final class Prefetch {

    // Sizes and offsets for arrays. These are currently hardcoded into this class.
    // The might need to be set by the Zing at classload time.
    private static final int _boolean_arr_offset = 20;
    private static final int _byte_arr_offset    = 20;
    private static final int _short_arr_offset   = 20;
    private static final int _char_arr_offset    = 20;
    private static final int _int_arr_offset     = 20;
    private static final int _long_arr_offset    = 24;
    private static final int _float_arr_offset   = 20;
    private static final int _double_arr_offset  = 24;
    private static final int _Object_arr_offset  = 24;
    
    private static final int _boolean_arr_scale = 0;
    private static final int _byte_arr_scale    = 0;
    private static final int _short_arr_scale   = 1;
    private static final int _char_arr_scale    = 1;
    private static final int _int_arr_scale     = 2;
    private static final int _long_arr_scale    = 3;
    private static final int _float_arr_scale   = 2;
    private static final int _double_arr_scale  = 3;
    private static final int _Object_arr_scale  = 3;  
    
    // Basic intrinsic operations recognized by the compiler.
    public static void shared   (Object o, long offset) { /* intrinsic operation */ }
    public static void exclusive(Object o, long offset) { /* intrinsic operation */ }
    
    /*
    // prefetch for read in arr at index
    public static void read(boolean arr[], int index) { read_many((Object)arr, ((long)index<<_boolean_arr_scale) + _boolean_arr_offset); }
    public static void read(byte    arr[], int index) { read_many((Object)arr, ((long)index<<_byte_arr_scale)    + _byte_arr_offset);    }
    public static void read(short   arr[], int index) { read_many((Object)arr, ((long)index<<_short_arr_scale)   + _short_arr_offset);   }
    public static void read(char    arr[], int index) { read_many((Object)arr, ((long)index<<_char_arr_scale)    + _char_arr_offset);    }
    public static void read(int     arr[], int index) { read_many((Object)arr, ((long)index<<_int_arr_scale)     + _int_arr_offset);     }
    public static void read(long    arr[], int index) { read_many((Object)arr, ((long)index<<_long_arr_scale)    + _long_arr_offset);    }
    public static void read(float   arr[], int index) { read_many((Object)arr, ((long)index<<_float_arr_scale)   + _float_arr_offset);   }
    public static void read(double  arr[], int index) { read_many((Object)arr, ((long)index<<_double_arr_scale)  + _double_arr_offset);  }
    public static void read(Object  arr[], int index) { read_many((Object)arr, ((long)index<<_Object_arr_scale)  + _Object_arr_offset);  }
    
    // prefetch for write in arr at index
    public static void write(boolean arr[], int index) { write_many((Object)arr, ((long)index<<_boolean_arr_scale) + _boolean_arr_offset); }
    public static void write(byte    arr[], int index) { write_many((Object)arr, ((long)index<<_byte_arr_scale)    + _byte_arr_offset);    }
    public static void write(short   arr[], int index) { write_many((Object)arr, ((long)index<<_short_arr_scale)   + _short_arr_offset);   }
    public static void write(char    arr[], int index) { write_many((Object)arr, ((long)index<<_char_arr_scale)    + _char_arr_offset);    }
    public static void write(int     arr[], int index) { write_many((Object)arr, ((long)index<<_int_arr_scale)     + _int_arr_offset);     }
    public static void write(long    arr[], int index) { write_many((Object)arr, ((long)index<<_long_arr_scale)    + _long_arr_offset);    }
    public static void write(float   arr[], int index) { write_many((Object)arr, ((long)index<<_float_arr_scale)   + _float_arr_offset);   }
    public static void write(double  arr[], int index) { write_many((Object)arr, ((long)index<<_double_arr_scale)  + _double_arr_offset);  }
    public static void write(Object  arr[], int index) { write_many((Object)arr, ((long)index<<_Object_arr_scale)  + _Object_arr_offset);  }
    
    // Basic intrinsic operations recognized by the compiler.
    public static void read_stream (Object o, long offset) { read_many (o, offset); }
    public static void write_stream(Object o, long offset) { write_many(o, offset); }
    
    // prefetch for read in arr at index
    public static void read_stream(boolean arr[], int index) { read_many((Object)arr, ((long)index<<_boolean_arr_scale) + _boolean_arr_offset); }
    public static void read_stream(byte    arr[], int index) { read_many((Object)arr, ((long)index<<_byte_arr_scale)    + _byte_arr_offset);    }
    public static void read_stream(short   arr[], int index) { read_many((Object)arr, ((long)index<<_short_arr_scale)   + _short_arr_offset);   }
    public static void read_stream(char    arr[], int index) { read_many((Object)arr, ((long)index<<_char_arr_scale)    + _char_arr_offset);    }
    public static void read_stream(int     arr[], int index) { read_many((Object)arr, ((long)index<<_int_arr_scale)     + _int_arr_offset);     }
    public static void read_stream(long    arr[], int index) { read_many((Object)arr, ((long)index<<_long_arr_scale)    + _long_arr_offset);    }
    public static void read_stream(float   arr[], int index) { read_many((Object)arr, ((long)index<<_float_arr_scale)   + _float_arr_offset);   }
    public static void read_stream(double  arr[], int index) { read_many((Object)arr, ((long)index<<_double_arr_scale)  + _double_arr_offset);  }
    public static void read_stream(Object  arr[], int index) { read_many((Object)arr, ((long)index<<_Object_arr_scale)  + _Object_arr_offset);  }
    
    // prefetch for write in arr at index
    public static void write_stream(boolean arr[], int index) { write_many((Object)arr, ((long)index<<_boolean_arr_scale) + _boolean_arr_offset); }
    public static void write_stream(byte    arr[], int index) { write_many((Object)arr, ((long)index<<_byte_arr_scale)    + _byte_arr_offset);    }
    public static void write_stream(short   arr[], int index) { write_many((Object)arr, ((long)index<<_short_arr_scale)   + _short_arr_offset);   }
    public static void write_stream(char    arr[], int index) { write_many((Object)arr, ((long)index<<_char_arr_scale)    + _char_arr_offset);    }
    public static void write_stream(int     arr[], int index) { write_many((Object)arr, ((long)index<<_int_arr_scale)     + _int_arr_offset);     }
    public static void write_stream(long    arr[], int index) { write_many((Object)arr, ((long)index<<_long_arr_scale)    + _long_arr_offset);    }
    public static void write_stream(float   arr[], int index) { write_many((Object)arr, ((long)index<<_float_arr_scale)   + _float_arr_offset);   }
    public static void write_stream(double  arr[], int index) { write_many((Object)arr, ((long)index<<_double_arr_scale)  + _double_arr_offset);  }
    public static void write_stream(Object  arr[], int index) { write_many((Object)arr, ((long)index<<_Object_arr_scale)  + _Object_arr_offset);  }
    */

}
