/* Copyright 2018 Azul Systems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU General Public License version 2 only, as published by 
 * the Free Software Foundation. 
 *
 * Azul designates this particular file as subject to the "Classpath" exception 
 * as provided by Azul in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE.  See the GNU General Public License version 2 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 2 
 * along with this work; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please contact Azul Systems, 385 Moffett Park Drive, Suite 115, Sunnyvale,
 * CA 94089 USA or visit www.azul.com if you need additional information or
 * have any questions.
 *
 * File: com/azulsystems/deduplication/StringDeduplicator.java
 */

package com.azulsystems.deduplication;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class StringDeduplicator {

    public static HashMap<HashMapEntry, HashMapEntry> map = new HashMap<>();

    public static int getMapSize() {
        return map == null ? 0 : map.size();
    }

    public static void deduplicate_batch(Object[] arrays, int[] hashCodes, Object[] results) {
        for(int i = 0; i < arrays.length; i++) {
            if(arrays[i] == null) continue;
            results[i] = deduplicate((byte[])arrays[i], hashCodes[i]);
        }
    }

    public static byte[] deduplicate(byte[] array, int hashCode) {
        {
            WeakReferencebyteArray freed_entry;
            while((freed_entry = (WeakReferencebyteArray)clearedReferencesQueue.poll()) != null) {
                map.remove(freed_entry.entry);
            }
        }

        HashMapEntry key = new HashMapEntry(array, hashCode);
        HashMapEntry existing = map.get(key);
        if(existing != null) {
            return existing.array_ref.get();
        } else {
            map.put(key, key);
            return null;
        }
    }

    public static ReferenceQueue<byte[]> clearedReferencesQueue = new ReferenceQueue<byte[]>();
    public static final class WeakReferencebyteArray extends WeakReference<byte[]>{
        private final HashMapEntry entry;
        public WeakReferencebyteArray(byte[] referent, HashMapEntry entry) {
            super(referent, clearedReferencesQueue);
            this.entry = entry;
        }
    }

    public static final class HashMapEntry {
        int hash;
        WeakReferencebyteArray array_ref;

        public HashMapEntry(byte[] array, int hash) {
            this.array_ref = new WeakReferencebyteArray(array, this);
            this.hash = hash;
        }

        @Override
        public int hashCode() {
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if(!(obj instanceof HashMapEntry)) return false;
            if(this.hash != ((HashMapEntry)obj).hash) return false;
            byte[] obj1 = array_ref.get();
            byte[] obj2 = ((HashMapEntry)obj).array_ref.get();
            if(obj1 == null || obj2 == null) return obj1 == obj2;
            return java.util.Arrays.equals(obj1,  obj2);
        }
    }

}
