//===- llvm/Orca/StripOrca.h - stripping azul specifics from IR--*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
// 
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// Defines a set of passes for removing Azul specific content from IR to ease
// reduction of upstream bugs starting w/a downstream Java example. 
//
//===----------------------------------------------------------------------===//

#include "llvm/IR/IRBuilder.h"
#include "llvm/IR/PassManager.h"

namespace llvm {

class Module;
class Function;
class Instruction;
class LoopInfo;
class LoadInst;
class PointerType;
class Value;

struct StripOrca : PassInfoMixin<StripOrca> {
public:
  StripOrca() = default;

  PreservedAnalyses run(Module &M, ModuleAnalysisManager &);
};

struct StripNames : PassInfoMixin<StripOrca> {
public:
  StripNames() = default;

  PreservedAnalyses run(Module &M, ModuleAnalysisManager &);
};

} // end namespace llvm
