//===- RememberNewInstanceTypes.h ---------------------------*- C++ -*-----===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2022 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
//
// This pass remembers the types of new instance allocations that exist in
// the top-level function in MD_NewInstanceTypes module level metadata. This
// metadata is used by OrcaAliasAnalysis to determine the types of new instance
// allocations after we rewrite or lower azul.new_instance abstraction calls.
//
// This pass is required for correctness of OrcaAliasAnalysis and it must be
// scheduled before we lower or otherwise optimize azul.new_instance abstraction.
//
//===----------------------------------------------------------------------===//

#ifndef REMEMBERNEWINSTANCETYPES_H
#define REMEMBERNEWINSTANCETYPES_H

#include "llvm/IR/PassManager.h"

namespace llvm {
class Module;
struct RememberNewInstanceTypes : PassInfoMixin<RememberNewInstanceTypes> {
  PreservedAnalyses run(Module &, ModuleAnalysisManager &);
};
}

#endif // REMEMBERNEWINSTANCETYPES_H
