//===- llvm/Orca/RThreadAccess.h --------------------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2021 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This file provides the interface for Azul's own RThreadAccess pass.
// This pass convers atomic loads into normal ones.
///
//===----------------------------------------------------------------------===//

#include "llvm/IR/PassManager.h"
#include "llvm/Support/CommandLine.h"

//===----------------------------------------------------------------------===//
//
// RThreadAccess - Add Thread Pointer Register (rthread, specified by
// the option -orca-reserved-thread-pointer-register) as a base to
// addrspace(azul::JavaThreadTLSAddrSpace) pointers.

extern llvm::cl::opt<std::string> ReservedThreadPointerRegister;

namespace llvm {

class FunctionPass;

FunctionPass *createRThreadAccessPass();

class RThreadAccess : public PassInfoMixin<RThreadAccess> {
public:
  PreservedAnalyses run(Function &F, FunctionAnalysisManager &AM);

  bool runImpl(Function &F);
};

} // end namespace llvm
