//===- llvm/Orca/PruneSwitchCases.h - Definition of the PruneSwitchCases class --------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
// 
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This file provides the interface for Azul's own Prune Switch Cases
// pass.
///
//===----------------------------------------------------------------------===//

#include "llvm/IR/PassManager.h"

namespace llvm {

class DominatorTree;
class Function;

struct PruneSwitchCases : PassInfoMixin<PruneSwitchCases> {

public:
  PruneSwitchCases() = default;

  PreservedAnalyses run(Function &F, FunctionAnalysisManager &FAM);

  /// Helper used by public run method and by the legacy pass
  bool runImpl(Function &F, DominatorTree *DT);
};

} // end namespace llvm
