//===- llvm/Orca/PropagateJavaTypes.h - Definition of the PropagateJavaTypes class --------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
// 
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This file provides the interface for Azul's own Propagate Java Types pass.
// The pass sets the java type for loads basing on function's attribute and
// return instruction.
//
//===----------------------------------------------------------------------===//

#include "llvm/IR/PassManager.h"

#ifndef LLVM_ORCA_PROPAGATEJAVATYPES_H
#define LLVM_ORCA_PROPAGATEJAVATYPES_H

namespace llvm {
class DominatorTree;
class PhiValues;

struct PropagateJavaTypes : PassInfoMixin<PropagateJavaTypes> {

public:
  PropagateJavaTypes() = default;

  PreservedAnalyses run(Function &F, FunctionAnalysisManager &FAM);

  /// Helper used by public run method and by the legacy pass
  PreservedAnalyses runImpl(Function &F, PhiValues &PV, DominatorTree &DT);
};

} // end namespace llvm

#endif
