//===- llvm/Orca/OrcaPipelineInterrupter.h - Definition of the
// OrcaIRStatsInstrumentation class --------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2019 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// Adds ability to interrupt pass pipeline. Relies on the availability of the
// AzulState inside of the LLVMContext.
//===----------------------------------------------------------------------===//
#ifndef LLVM_ORCA_PIPELINE_INTERRUPTER
#define LLVM_ORCA_PIPELINE_INTERRUPTER

#include "llvm/Passes/StandardInstrumentations.h"

namespace azul {
  namespace internal {
    class AzulState;
  }
}

namespace llvm {
class OrcaPipelineInterrupter {
public:
  OrcaPipelineInterrupter() = default;
  ~OrcaPipelineInterrupter() = default;

  void registerCallbacks(
      PassInstrumentationCallbacks &PIC,
      const azul::internal::AzulState &St);
};
}

#endif //LLVM_ORCA_PIPELINE_INTERRUPTER
