//===- OrcaCallPRE.h -- Orca specific PRE for Call ----------*- C++ -*-----===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2021 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//

#ifndef ORCACALLPRE_H
#define ORCACALLPRE_H

#include "llvm/IR/PassManager.h"
#include "llvm/IR/ValueHandle.h"
#include <optional>

namespace llvm {
class CallBase;
class DominatorTree;
class Module;

struct OrcaCallPRE : PassInfoMixin<OrcaCallPRE> {
  bool NonTrivial;

  DominatorTree *DT = nullptr;
  BlockFrequencyInfo *BFI = nullptr;
  BranchProbabilityInfo *BPI = nullptr;

  using PRECandidate = std::pair<WeakTrackingVH, BasicBlock *>;
  SmallVector<PRECandidate, 16> Worklist;

  OrcaCallPRE(bool NonTrivial) : NonTrivial(NonTrivial) {}
  PreservedAnalyses run(Function &M, FunctionAnalysisManager &FAM);
private:
  void addToWorklist(CallBase &Call);
  std::optional<Value *> getSimplifiedValueInBlock(CallBase &Call,
                                                   BasicBlock *Block);
  bool canExecuteInBlock(const CallBase &Call, const BasicBlock *Pred);
  CallBase *emitInBlock(CallBase &Call, BasicBlock *Block);
  bool tryPRE(CallBase &Call, BasicBlock *Block);
};
}

#endif
