//===- OptimizeKnownValues.h --- Optimize Known Values Pass Header ----*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2013-2020 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This file provides the interface for Optimize Known Values pass.
//
//===----------------------------------------------------------------------===//

#ifndef OPTIMIZEKNOWNVALUES_H
#define OPTIMIZEKNOWNVALUES_H

#include "llvm/IR/PassManager.h"

namespace azul {
namespace orca {
class OrcaPipeline;
}
} // namespace azul

namespace llvm {

class Module;

struct OptimizeKnownValues : PassInfoMixin<OptimizeKnownValues> {
  raw_ostream &OS = dbgs();

  PreservedAnalyses runOnOneFunction(Function &F);
  PreservedAnalyses run(Module &M, ModuleAnalysisManager &MAM);
};
}

#endif
