//===-- LowerGCLeafIntrinsics.h - lower gc leaf intrinsic calls -*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// This pass tries to inline gc-leaf versions of intrinsics that may also have a
// non gc-leaf implementation.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_TRANSFORMS_SCALAR_LOWERGCLEAFINTRINSICS_H
#define LLVM_TRANSFORMS_SCALAR_LOWERGCLEAFINTRINSICS_H

#include "llvm/IR/Module.h"
#include "llvm/IR/PassManager.h"

namespace llvm {
class LowerGCLeafIntrinsicsPass
    : public PassInfoMixin<LowerGCLeafIntrinsicsPass> {
public:
  PreservedAnalyses run(Function &F, FunctionAnalysisManager &AM);
};
}

#endif // LLVM_TRANSFORMS_SCALAR_LOWERGCLEAFINTRINSICS_H
