//===- llvm/Orca/IdentifyMissedOpts.h ---------------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//
//===----------------------------------------------------------------------===//
// Copyright 2013-2021 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This file provides the interface for Azul's own OptimizeSafepointPolls pass.
// This pass removes redundant safepoint polls.
///
//===----------------------------------------------------------------------===//

#ifndef IDENTIFYMISSEDOPTS_H
#define IDENTIFYMISSEDOPTS_H

#include "llvm/IR/PassManager.h"

namespace llvm {

namespace json {
  class OStream;
}

class IdentifyMissedOpts : public PassInfoMixin<IdentifyMissedOpts> {
public:
  enum PipelineLocation {
    NOT_SPECIFIED = 0,
    BEFORE_DROP_IC,
    BEFORE_MERGE_ALLOCATIONS,
    BEFORE_LATE_INLINE_0,
    BEFORE_LATE_INLINE_1,
    BEFORE_LATE_INLINE_2,
    AFTER_REWRITE_STATEPOINTS,
    BEFORE_LATE_INLINE_3,
    BEFORE_LATE_INLINE_4,
    AFTER_ALL_OPTIMIZATIONS,
  };

private:
  json::OStream *StatsOut = nullptr;
  PipelineLocation pipelineLocation;

public:
  IdentifyMissedOpts(json::OStream *StatsOut = nullptr,
                     PipelineLocation pipelineLocation =
                         PipelineLocation::NOT_SPECIFIED)
      : StatsOut(StatsOut), pipelineLocation(pipelineLocation) {}

  PreservedAnalyses run(Module &M, ModuleAnalysisManager &MAM);
};

} // end namespace llvm

#endif /* IDENTIFYMISSEDOPTS_H */
