//===- llvm/Orca/ExpandSmallObjArraycopy.h - Definition of the ExpandSmallObjArraycopy class --------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
// 
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
///
//===----------------------------------------------------------------------===//

#include "llvm/IR/PassManager.h"

namespace llvm {

class AtomicMemTransferInst;

struct ExpandSmallObjArraycopy
  : public PassInfoMixin<ExpandSmallObjArraycopy> {

  PreservedAnalyses run(Module &M, ModuleAnalysisManager &AM);

  bool runImpl(Module &M);

 protected:
  bool ExpandMemTransferInst(AtomicMemTransferInst &MT);
};

} // end namespace llvm
