//===- llvm/Orca/DropInliningCandidates.h - Definition of the DropInliningCandidates class --------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
// 
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This file provides the interface for Azul's own Drop Inlining Candidates
// pass. The pass deletes the inlining candidate functions and call stubs.
///
//===----------------------------------------------------------------------===//

#include "llvm/IR/PassManager.h"

namespace llvm {

class Module;

struct DropInliningCandidates : PassInfoMixin<DropInliningCandidates> {
  // If KeepJavaMethods is true, we do not drop inline candidates that are
  // java methods. We only drop intrinsics, VM stubs etc.
  // Note that this mode is off by default.
  const bool KeepJavaMethods;
public:
  DropInliningCandidates(bool KeepJavaMethods = false)
      : KeepJavaMethods(KeepJavaMethods){};

  PreservedAnalyses run(Module &M, ModuleAnalysisManager &MAM);

  /// Helper used by public run method and by the legacy pass
  PreservedAnalyses runImpl(Module &M);

  static bool isRequired() { return true; }
};

} // end namespace llvm
