//===- llvm/Orca/DevirtualizeCalls.h - Definition of the DevirtualizeCalls class --------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
// 
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This file provides the interface for Azul's own DevirtualizeCalls pass.
///
//===----------------------------------------------------------------------===//

#include "llvm/IR/PassManager.h"
#include "llvm/IR/Dominators.h"

namespace llvm {
class CallBase;
class Module;
class DevirtualizeCalls;

// NOTE: Even when RunOnlyOnFunc is specified and we devirtualize calls in only
// one function, devirtualization is still a module-level change since it can
// add new globals to the module.
class DevirtualizeCallsPass : public PassInfoMixin<DevirtualizeCallsPass> {
  llvm::SmallVectorImpl<llvm::CallBase *> *DevirtualizedCallSites;

public:
  DevirtualizeCallsPass(
      llvm::SmallVectorImpl<llvm::CallBase *> *DevirtualizedCallSites = nullptr)
      : DevirtualizedCallSites(DevirtualizedCallSites) {}

  PreservedAnalyses runOnOneFunction(Function &F, DevirtualizeCalls &DC);
  PreservedAnalyses run(Module &M, ModuleAnalysisManager &);
};

} // namespace llvm
