//===- BarrierOptimization.h - Definition of the BarrierOptimization class --------*- C++ -*-===// 
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
// \file
// This file provides the interface for Azul's own BarrierOpts pass.
// This pass optimizes GC barriers.
///
//===----------------------------------------------------------------------===//

#include "llvm/IR/PassManager.h"

namespace llvm {

class AAResults;
class BranchProbabilityInfo;
class DominatorTree;
class LoopInfo;
class TargetLibraryInfo;

struct BarrierOpts : public PassInfoMixin<BarrierOpts> {
  BarrierOpts(bool RunOptsBeforeSVBInlining = false)
      : RunOptsBeforeSVBInlining(RunOptsBeforeSVBInlining) {}
  PreservedAnalyses run(Function &F, FunctionAnalysisManager &AM);

  private:
  // When this option is true, we run optimization passes when both LVBs and
  // SVB calls exist in IR before these abstractions are inlined.
  const bool RunOptsBeforeSVBInlining;
  bool runImpl(Function &F, AAResults &AA, DominatorTree &DT,
               BranchProbabilityInfo &BPI, LoopInfo &LI,
               TargetLibraryInfo &TLI);
};

} // end namespace llvm
