//===-- QueryTypes.h -------------------------------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
//
// This file defines a database of the various kinds of queries the query cache
// supports.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_AZUL_QUERY_TYPES_H
#define LLVM_AZUL_QUERY_TYPES_H

// QUERY_TYPES_DO(F, ARGC, ARGV) invokes, for each query type:
//   F(ALL_CAPS_NAME, ReturnType, CamelCaseName, AssertIdempotent, CStringName, CallbackName)
//   ARGC(# arg count)
//   For each arg:  ARGV(ArgIndex, ArgType)
//   ARGEND(# arg count)

#define QUERY_TYPES_DO(F, ARGC, ARGV, ARGEND)                                                                  \
  F(IS_SUBTYPE_OF, bool, IsSubtypeOf, true, "is-subtype-of", _is_subtype_of_callback)                          \
  ARGC(2) ARGV(0, QueryArg::TYPE_UINT64) ARGV(1, QueryArg::TYPE_UINT64) ARGEND(2)                              \
                                                                                                               \
  F(REQUIRES_FINALIZER, bool, RequiresFinalizer, true, "requires-finalizer", _requires_finalizer_callback)     \
  ARGC(2) ARGV(0, QueryArg::TYPE_UINT64) ARGV(1, QueryArg::TYPE_UINT64) ARGEND(2)                              \
                                                                                                               \
  F(GET_INLINE_CANDIDATE, SerializedFunction *, GetInlineCandidate, false, "get-inline-candidate",             \
  _get_inline_candidate_callback) ARGC(2) ARGV(0, QueryArg::TYPE_STRING) ARGV(1, QueryArg::TYPE_STRING)        \
  ARGEND(2)                                                                                                    \
                                                                                                               \
  F(REPORT_JAVA_METHOD_INLINING_DECISION, bool, ReportJavaMethodInliningDecision, true,                        \
  "report-java-method-inlining-decision", _report_java_method_inlining_decision_callback)                      \
  ARGC(7)                                                                                                      \
  ARGV(0, QueryArg::TYPE_UINT64)                                                                               \
  ARGV(1, QueryArg::TYPE_STRING) ARGV(2, QueryArg::TYPE_STRING)                                                \
  ARGV(3, QueryArg::TYPE_UINT64_ARRAY) ARGV(4, QueryArg::TYPE_UINT64_ARRAY)                                    \
  ARGV(5, QueryArg::TYPE_STRING) ARGV(6, QueryArg::TYPE_UINT64)                                                \
  ARGEND(7)                                                                                                    \
                                                                                                               \
  F(GET_VM_INLINING_ADVICE, bool, GetVMInliningAdvice, true,                                                   \
  "get-vm-inlining-advice", _get_vm_inlining_advice)                                                           \
  ARGC(4)                                                                                                      \
  ARGV(0, QueryArg::TYPE_STRING) ARGV(1, QueryArg::TYPE_STRING)                                                \
  ARGV(2, QueryArg::TYPE_UINT64_ARRAY) ARGV(3, QueryArg::TYPE_UINT64_ARRAY)                                    \
  ARGEND(4)                                                                                                    \
                                                                                                               \
  F(GET_LOAD_RESULT_KLASS, uint64_t, GetLoadResultKlass, true, "get-load-result-klass",                        \
  _get_load_result_klass_callback) ARGC(3) ARGV(0, QueryArg::TYPE_UINT64) ARGV(1, QueryArg::TYPE_UINT64)       \
  ARGV(2, QueryArg::TYPE_UINT64) ARGEND(3)                                                                     \
                                                                                                               \
  F(GET_LOAD_RESULT_KNOWN_VALUE, uint64_t, GetLoadResultKnownValue, true, "get-load-result-known-value",       \
  _get_load_result_known_value_callback) ARGC(3) ARGV(0, QueryArg::TYPE_UINT64) ARGV(1, QueryArg::TYPE_UINT64) \
  ARGV(2, QueryArg::TYPE_UINT64) ARGEND(3)                                                                     \
                                                                                                               \
  F(GET_KNOWN_VALUE_KEY, uint64_t, GetKnownValueKey, true, "get-known-value-key",                              \
  _get_known_value_key_callback) ARGC(1) ARGV(0, QueryArg::TYPE_UINT64) ARGEND(1)                              \
                                                                                                               \
  F(GET_KNOWN_VALUE_KEY_DEPENDENT, uint64_t, GetKnownValueKeyDependent, true, "get-known-value-key-dependent", \
  _get_known_value_key_dependent_callback) ARGC(2) ARGV(0, QueryArg::TYPE_UINT64)                              \
  ARGV(1, QueryArg::TYPE_UINT64) ARGEND(2)                                                                     \
                                                                                                               \
  F(GET_UNIQUE_SUBTYPE, uint64_t, GetUniqueSubtype, true, "get-unique-subtype", _get_unique_subtype_callback)  \
  ARGC(2) ARGV(0, QueryArg::TYPE_UINT64) ARGV(1, QueryArg::TYPE_UINT64) ARGEND(2)                              \
                                                                                                               \
  F(IS_UNMODIFIED_BY_CALL, bool, IsUnmodifiedByCall, true, "is-unmodified-by-call",                            \
  _is_unmodified_by_call_callback) ARGC(4) ARGV(0, QueryArg::TYPE_UINT64) ARGV(1, QueryArg::TYPE_UINT64)       \
  ARGV(2, QueryArg::TYPE_UINT64) ARGV(3, QueryArg::TYPE_STRING) ARGEND(4)                                      \
                                                                                                               \
  F(IS_UNMODIFIED_BY_JAVA_CALL, bool, IsUnmodifiedByJavaCall, true, "is-unmodified-by-java-call",              \
  _is_unmodified_by_java_call_callback) ARGC(5) ARGV(0, QueryArg::TYPE_UINT64)                                 \
  ARGV(1, QueryArg::TYPE_UINT64) ARGV(2, QueryArg::TYPE_UINT64) ARGV(3, QueryArg::TYPE_UINT64)                 \
  ARGV(4, QueryArg::TYPE_UINT64) ARGEND(5)                                                                     \
                                                                                                               \
  F(GET_OBJ_ARRAY_ELEMENT_KID, uint64_t, GetObjArrayElementKid, true, "get-obj-array-element-kid",             \
  _get_obj_array_element_kid) ARGC(1) ARGV(0, QueryArg::TYPE_UINT64) ARGEND(1)                                 \
                                                                                                               \
  F(GET_INLINE_CACHE_CALL_STUB, SerializedFunction *, GetInlineCacheCallStub, false,                           \
    "get-inline-cache-call-stub", _get_inline_cache_call_stub_callback)                                        \
  ARGC(2) ARGV(0, QueryArg::TYPE_UINT64) ARGV(1, QueryArg::TYPE_UINT64) ARGEND(2)                              \
                                                                                                               \
  F(GET_VM_INTEGER_CONSTANT, uint64_t, GetVMIntegerConstant, true, "get-vm-integer-constant",                  \
  _get_vm_integer_constant) ARGC(1) ARGV(0, QueryArg::TYPE_STRING) ARGEND(1)                                   \
                                                                                                               \
  F(GET_JAVA_TYPE_INFO, azul::orca::JavaTypeInfo, GetJavaTypeInfo, true,                                       \
    "get-java-type-info", _get_java_type_info_callback)                                                        \
  ARGC(3) ARGV(0, QueryArg::TYPE_UINT64) ARGV(1, QueryArg::TYPE_UINT64)                                        \
          ARGV(2, QueryArg::TYPE_OPTIONAL_UINT64) ARGEND(3)                                                    \
                                                                                                               \
  F(GET_FIELD_INFO_AT_OFFSET, azul::orca::FieldInfo, GetFieldInfoAtOffset, true,                               \
    "get-field-info-at-offset", _get_field_info_at_offset_callback)                                            \
  ARGC(4) ARGV(0, QueryArg::TYPE_UINT64) ARGV(1, QueryArg::TYPE_UINT64) ARGV(2, QueryArg::TYPE_UINT64)         \
  ARGV(3, QueryArg::TYPE_UINT64) ARGEND(4)                                                                     \
                                                                                                               \
  F(LEAST_COMMON_ANCESTOR, uint64_t, LeastCommonAncestor, true, "least-common-ancestor",                       \
  _least_common_ancestor) ARGC(2) ARGV(0, QueryArg::TYPE_UINT64) ARGV(1, QueryArg::TYPE_UINT64) ARGEND(2)      \
                                                                                                               \
  F(GET_OBJECT_HASHCODE, uint64_t, GetObjectHashCode, true,                                                    \
    "get-object-hashcode", _get_object_hashcode_callback) ARGC(1) ARGV(0, QueryArg::TYPE_UINT64) ARGEND(1)     \
                                                                                                               \
  F(GET_OBJECT_GENERATION, uint64_t, GetObjectGeneration, true,                                                \
    "get-object-generation", _get_object_generation_callback) ARGC(1) ARGV(0, QueryArg::TYPE_UINT64) ARGEND(1) \
                                                                                                               \
  F(GET_OBJECT_KLASS_ID, uint64_t, GetObjectKlassID, true,                                                     \
    "get-object-klass-id", _get_object_klass_id_callback) ARGC(1) ARGV(0, QueryArg::TYPE_UINT64) ARGEND(1)     \
                                                                                                               \
  F(GET_KLASS_ID_FOR_JAVA_LANG_CLASS, uint64_t, GetKlassIDForJavaLangClass, true,                              \
    "get-klass-id-for-java-lang-class", _get_klass_id_for_java_lang_class_callback) ARGC(1)                    \
    ARGV(0, QueryArg::TYPE_UINT64) ARGEND(1)                                                                   \
                                                                                                               \
  F(GET_MERGED_ALLOC_FUNC, SerializedFunction *, GetMergedAllocFunc, false, "get-merged-alloc-func",           \
    _get_merged_alloc_func_callback) ARGC(1) ARGV(0, QueryArg::TYPE_UINT64_ARRAY) ARGEND(1)                    \
                                                                                                               \
  F(GET_SPECIALIZED_IMPLEMENTATION, SerializedFunction *, GetSpecializedImplementation, false,                 \
    "get-specialized-implementation", _get_specialized_implementation_callback) ARGC(7)                        \
    ARGV(0, QueryArg::TYPE_STRING) ARGV(1, QueryArg::TYPE_UINT64_ARRAY)                                        \
    ARGV(2, QueryArg::TYPE_UINT64_ARRAY) ARGV(3, QueryArg::TYPE_UINT64_ARRAY)                                  \
    ARGV(4, QueryArg::TYPE_STRING)                                                                             \
    ARGV(5, QueryArg::TYPE_UINT64_ARRAY) ARGV(6, QueryArg::TYPE_UINT64_ARRAY) ARGEND(7)                        \
                                                                                                               \
  F(GET_CONSTANT_RESULT, uint64_t, GetConstantResult, true,                                                    \
    "get-constant-result", _get_constant_result_callback) ARGC(6)                                              \
    ARGV(0, QueryArg::TYPE_STRING) ARGV(1, QueryArg::TYPE_UINT64_ARRAY)                                        \
    ARGV(2, QueryArg::TYPE_UINT64_ARRAY) ARGV(3, QueryArg::TYPE_UINT64_ARRAY)                                  \
    ARGV(4, QueryArg::TYPE_UINT64_ARRAY) ARGV(5, QueryArg::TYPE_UINT64_ARRAY) ARGEND(6)                        \
                                                                                                               \
  F(GET_KNOWN_VALUE_GLOBAL_NAME, std::string, GetKnownValueGlobalName, true,                                   \
    "get-known-value-global-name", _get_known_value_global_name_callback) ARGC(1)                              \
  ARGV(0, QueryArg::TYPE_UINT64) ARGEND(1)                                                                     \
                                                                                                               \
  F(GET_FUNCTION_INFO, azul::orca::FunctionInfo, GetFunctionInfo, true,                                        \
    "get-function-info", _get_function_info_callback) ARGC(1) ARGV(0, QueryArg::TYPE_UINT64) ARGEND(1)         \
                                                                                                               \
  F(GET_SPECIALIZED_FUNCTION_ID, uint32_t, GetSpecializedFunctionID, false,                                    \
    "get-specialized-function-id", _get_specialized_function_id_callback) ARGC(2)                              \
  ARGV(0, QueryArg::TYPE_STRING) ARGV(1, QueryArg::TYPE_STRING) ARGEND(2)                                      \
                                                                                                               \
  F(GET_KNOWN_VALUE_ID, uint64_t, GetKnownValueID, true,                                                       \
    "get-known-value-id", _get_known_value_id_callback) ARGC(1) ARGV(0, QueryArg::TYPE_STRING) ARGEND(1)       \
                                                                                                               \
  F(IS_CACHED_BOX_OBJECT, bool, IsCachedBoxObject, true,                                                       \
    "is-cached-box-object", _is_cached_box_object_callback) ARGC(1)                                            \
    ARGV(0, QueryArg::TYPE_UINT64) ARGEND(1)                                                                   \
                                                                                                               \
  F(GET_BOXED_VALUE_OFFSET, uint64_t, GetBoxedValueOffset, true,                                               \
    "get-boxed-value-offset", _get_boxed_value_offset_callback) ARGC(1)                                        \
    ARGV(0, QueryArg::TYPE_UINT64) ARGEND(1)                                                                   \
                                                                                                               \
  F(RUN_TIME_TO_COMPILE_TIME_KLASS_ID, uint64_t, RunTimeToCompileTimeKlassID, true,                            \
    "run-time-to-compile-time-klass-id", _run_time_to_compile_time_klass_id_callback) ARGC(1)                  \
    ARGV(0, QueryArg::TYPE_UINT64) ARGEND(1)                                                                   \
                                                                                                               \
  F(COMPILE_TIME_TO_RUN_TIME_KLASS_ID, uint64_t, CompileTimeToRunTimeKlassID, true,                            \
    "compile-time-to-run-time-klass-id", _compile_time_to_run_time_klass_id_callback) ARGC(1)                  \
    ARGV(0, QueryArg::TYPE_UINT64) ARGEND(1)

#define QUERY_TYPES_ARGC_NULL(C)
#define QUERY_TYPES_ARGV_NULL(I, Ty)
#define QUERY_TYPES_ARGEND_NULL(C)

// In most cases, ARGC, ARGV and ARGEND in QUERY_TYPES_DO don't have to do
// anything.  In such cases, QUERY_TYPES_DO_NOARGS can be used

#define QUERY_TYPES_DO_NOARGS(F)                                        \
  QUERY_TYPES_DO(F, QUERY_TYPES_ARGC_NULL, QUERY_TYPES_ARGV_NULL, QUERY_TYPES_ARGEND_NULL)

#endif
