//===-- Attributes.h ------------------------------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
// Copyright 2013-2018 Azul Systems, Inc.  All Rights Reserved.
// http://www.azul.com
// Azul Systems is a contributor to the LLVM Team.
// Distributed under the same license terms detailed in LICENSE.TXT above.
//===----------------------------------------------------------------------===//
//
// Defines the constant strings for our custom attributes
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_ORCA_ATTRIBUTES_H
#define LLVM_ORCA_ATTRIBUTES_H

// NB! We are in the middle of a migration here. See ZVM-22717 for details
// (string -> enum attributes as specified in AttributesOrca.td file).
// This file will be kept for couple of months (end of Summer'22) to maintain
// backward compatibility for IR.
namespace azul {
  constexpr const char *SpecializableFunctionAttributeName =
    "specializable-function-id";
  constexpr const char *FoldableFunctionAttributeName = "foldable-function";

  // Indicates that the given arguments contents can be assumed to match the
  // contents of the returned memory at the specified offset (in bytes).
  constexpr const char *AssumeResultMemAtAttributeName =
    "assume-mem-result-at";

  constexpr const char *InvariantCallAttributeName = "invariant-call";

  constexpr const char *InvariantObjectPropertyAttributeName =
    "invariant-object-property";

  // Call site frequency is a ratio between number of the enclosing method
  // calls and number of the call site is executed.
  constexpr const char *CallSiteFrequencyName = "callsite-frequency";

  constexpr const char *BytecodeSizeAttributeName = "bytecode-size";

  constexpr const char *FunctionIdAttributeName = "azul-function-id";

  constexpr const char *JavaTypeKidAttributeName = "java-type-kid";
  constexpr const char *JavaTypeExactAttributeName = "java-type-exact";

  constexpr const char *KnownValueIDAttributeName = "known-value-id";
  
  constexpr const char *AllocationJavaTypeKidAttributeName =
    "allocation-java-type-kid";

  constexpr const char *AllocationSiteAttributeName = "allocation-site";

  constexpr const char *AlwaysInlineTopLevelAttributeName =
    "alwaysinline-top-level";
  constexpr const char *LateInlineAttributeName = "azul-late-inline";
  constexpr const char *HasLatentUseAttributeName = "has-latent-use";

  constexpr const char *TopLevelMethodAttributeName = "azul-top-level-method";

  constexpr const char *TrivialMethodAttributeName = "azul-trivial-method";

  constexpr const char *TrivialDeadnessAttributeName = "azul-trivial-deadness";

  constexpr const char *ComputeTimeAttributeName = "compute-time";

  constexpr const char *InliningCandidateAttributeName =
    "azul-inlining-candidate";
  constexpr const char *ForceInliningCandidateGenerationAttributeName =
    "force-inlining-candidate-generation";

  constexpr const char *CallStubAttributeName = "azul-call-stub";
  constexpr const char *VirtualCallStubAttributeName = "azul-virtual-call-stub";

  // Generatable functions are those that can be generated by
  // VMInterface::getFunctionBody.
  constexpr const char *GeneratableAttributeName = "azul-generatable";

  constexpr const char *AddLVBsAttributeName = "azul-add-lvbs";
  constexpr const char *AddSVBsAttributeName = "azul-add-svbs";

  constexpr const char *ConsumesCallerVMStateAttributeName =
      "consumes-caller-vmstate";
  constexpr const char *ConsumesVMStateAttributeName = "consumes-vmstate";
  constexpr const char *ConsumesReplayVMStateAttributeName =
    "consumes-replay-vmstate";

  constexpr const char *GuaranteedToPollAttributeName = "guaranteed-to-poll";

  // A function level attribute to indicate that the function is specialized for
  // the context of a particular call site. The VM will not emit calls to this
  // function in other contexts.
  //
  // Note that this attribute doesn't guarantee that the function has only one
  // use. Multiple uses occur if the optimizer clones the specialized call site.
  constexpr const char *CallSiteSpecializedAttributeName = 
    "call-site-specialized";

  // OrcaInlinerPassManager attributes.
  //
  // The following attributes are used by OrcaInlinerPassManager in order to
  // cache the internal state of the inliner in the IR.

  // Function attribute to indicate that the function was simplified after the
  // last call was inlined into it.
  constexpr const char *FunctionSimplifiedAfterInliningAttributeName =
    "simplified-after-inlining";

  // End of OrcaInlinerPassManager attributes.

  constexpr const char *InlineCacheCandidateAttributeName =
    "inline-cache-candidate";

  constexpr const char *InlineCacheCallAttributeName = "inline-cache-call";

  constexpr const char *AzulDeoptOnThrowAttributeName = "azul-deopt-on-throw";

  // A call-site attribute to indicate that when inlining the call-site its
  // (presumably synthetic) deoptimization bundle should be merged with caller's
  // deopt state forming a state before call.
  // Needed to represent the state for uncommon traps in call-stubs.
  constexpr const char *AzulNeedDeoptBeforeCallAttributeName =
      "azul-need-deopt-before-call";

  /// Indicates that the value is a newly allocated box object.
  /// A box object is a wrapper over a primitive value produced as a
  /// result of a call to the corresponding valueOf method.
  /// This attribute can only be used on allocations.
  constexpr const char *NewBoxObjectAttributeName = "new-box-object";

  // If used on an argument - indicates that the given argument is a new
  // allocation which doesn't escape before the call.
  // If used on the return value - indicates that the returned value is a
  // new allocation which doesn't escape anywhere in the function.
  constexpr const char *UnescapedAllocationAttributeName =
      "unescaped-allocation";

  // Call site attribute indicating the total number of allocations escaped
  // through of this call.
  constexpr const char *NumOfEscapedAllocationsAttributeName =
      "num-of-escaped-allocations";

  // A call-site attribute for element atomic memcpy/memmove intrinsics.
  // If set PartialInlineMemoryIntrinsics pass will not inline the length check
  // for this intrinsic call.
  constexpr const char *DontInlineLengthCheckAttributeName =
      "dont-inline-length-check";

  // A function attribute indicating that the function implements an instance
  // initialization method (aka an instance constructor or the <init> method).
  constexpr const char *InstanceInitializationMethodAttributeName =
      "instance-initialization-method";

} // namespace azul

#endif
