/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Bits;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputFilter;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.SerialCallbackContext;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.io.WriteAbortedException;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import jdk.internal.access.SharedSecrets;
import jdk.internal.event.DeserializationEvent;
import jdk.internal.misc.Unsafe;
import jdk.internal.misc.VM;
import sun.reflect.misc.ReflectUtil;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int NULL_HANDLE = -1;
    private static final Object unsharedMarker = new Object();
    private static final Map<String, Class<?>> primClasses = Map.of("boolean", Boolean.TYPE, "byte", Byte.TYPE, "char", Character.TYPE, "short", Short.TYPE, "int", Integer.TYPE, "long", Long.TYPE, "float", Float.TYPE, "double", Double.TYPE, "void", Void.TYPE);
    private final BlockDataInputStream bin;
    private final ValidationList vlist;
    private long depth;
    private long totalObjectRefs;
    private boolean closed;
    private final HandleTable handles;
    private int passHandle = -1;
    private boolean defaultDataEnd = false;
    private final boolean enableOverride;
    private boolean enableResolve;
    private SerialCallbackContext curContext;
    private ObjectInputFilter serialFilter;
    private boolean streamFilterSet;
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();

    public ObjectInputStream(InputStream inputStream) throws IOException {
        this.verifySubclass();
        this.bin = new BlockDataInputStream(inputStream);
        this.handles = new HandleTable(10);
        this.vlist = new ValidationList();
        this.streamFilterSet = false;
        this.serialFilter = (ObjectInputFilter)ObjectInputFilter.Config.getSerialFilterFactorySingleton().apply(null, ObjectInputFilter.Config.getSerialFilter());
        this.enableOverride = false;
        this.readStreamHeader();
        this.bin.setBlockDataMode(true);
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bin = null;
        this.handles = null;
        this.vlist = null;
        this.streamFilterSet = false;
        this.serialFilter = (ObjectInputFilter)ObjectInputFilter.Config.getSerialFilterFactorySingleton().apply(null, ObjectInputFilter.Config.getSerialFilter());
        this.enableOverride = true;
    }

    @Override
    public final Object readObject() throws IOException, ClassNotFoundException {
        return this.readObject(Object.class);
    }

    private String readString() throws IOException {
        try {
            return (String)this.readObject(String.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object readObject(Class<?> clazz) throws IOException, ClassNotFoundException {
        if (this.enableOverride) {
            return this.readObjectOverride();
        }
        if (clazz != Object.class && clazz != String.class) {
            throw new AssertionError((Object)"internal error");
        }
        int n = this.passHandle;
        try {
            Object object = this.readObject0(clazz, false);
            this.handles.markDependency(n, this.passHandle);
            ClassNotFoundException classNotFoundException = this.handles.lookupException(this.passHandle);
            if (classNotFoundException != null) {
                throw classNotFoundException;
            }
            if (this.depth == 0L) {
                this.vlist.doCallbacks();
                this.freeze();
            }
            Object object2 = object;
            return object2;
        }
        finally {
            this.passHandle = n;
            if (this.closed && this.depth == 0L) {
                this.clear();
            }
        }
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readUnshared() throws IOException, ClassNotFoundException {
        int n = this.passHandle;
        try {
            Object object = this.readObject0(Object.class, true);
            this.handles.markDependency(n, this.passHandle);
            ClassNotFoundException classNotFoundException = this.handles.lookupException(this.passHandle);
            if (classNotFoundException != null) {
                throw classNotFoundException;
            }
            if (this.depth == 0L) {
                this.vlist.doCallbacks();
                this.freeze();
            }
            Object object2 = object;
            return object2;
        }
        finally {
            this.passHandle = n;
            if (this.closed && this.depth == 0L) {
                this.clear();
            }
        }
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        ClassNotFoundException classNotFoundException;
        SerialCallbackContext serialCallbackContext = this.curContext;
        if (serialCallbackContext == null) {
            throw new NotActiveException("not in call to readObject");
        }
        Object object = serialCallbackContext.getObj();
        ObjectStreamClass objectStreamClass = serialCallbackContext.getDesc();
        this.bin.setBlockDataMode(false);
        FieldValues fieldValues = new FieldValues(objectStreamClass, true);
        if (object != null) {
            fieldValues.defaultCheckFieldValues(object);
            fieldValues.defaultSetFieldValues(object);
        }
        this.bin.setBlockDataMode(true);
        if (!objectStreamClass.hasWriteObjectData()) {
            this.defaultDataEnd = true;
        }
        if ((classNotFoundException = this.handles.lookupException(this.passHandle)) != null) {
            throw classNotFoundException;
        }
    }

    public GetField readFields() throws IOException, ClassNotFoundException {
        SerialCallbackContext serialCallbackContext = this.curContext;
        if (serialCallbackContext == null) {
            throw new NotActiveException("not in call to readObject");
        }
        serialCallbackContext.checkAndSetUsed();
        ObjectStreamClass objectStreamClass = serialCallbackContext.getDesc();
        this.bin.setBlockDataMode(false);
        FieldValues fieldValues = new FieldValues(objectStreamClass, false);
        this.bin.setBlockDataMode(true);
        if (!objectStreamClass.hasWriteObjectData()) {
            this.defaultDataEnd = true;
        }
        return fieldValues;
    }

    public void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
        if (this.depth == 0L) {
            throw new NotActiveException("stream inactive");
        }
        this.vlist.register(objectInputValidation, n);
    }

    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        try {
            return Class.forName(string, false, ObjectInputStream.latestUserDefinedLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> clazz = primClasses.get(string);
            if (clazz != null) {
                return clazz;
            }
            throw classNotFoundException;
        }
    }

    protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = ObjectInputStream.latestUserDefinedLoader();
        ClassLoader classLoader2 = null;
        boolean bl = false;
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            Class<?> clazz = Class.forName(stringArray[i], false, classLoader);
            if ((clazz.getModifiers() & 1) == 0) {
                if (bl) {
                    if (classLoader2 != clazz.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    classLoader2 = clazz.getClassLoader();
                    bl = true;
                }
            }
            classArray[i] = clazz;
        }
        try {
            Class<?> clazz = Proxy.getProxyClass(bl ? classLoader2 : classLoader, classArray);
            return clazz;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableResolveObject(boolean bl) throws SecurityException {
        SecurityManager securityManager;
        if (bl == this.enableResolve) {
            return bl;
        }
        if (bl && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(SUBSTITUTION_PERMISSION);
        }
        this.enableResolve = bl;
        return !this.enableResolve;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        short s = this.bin.readShort();
        short s2 = this.bin.readShort();
        if (s != -21267 || s2 != 5) {
            throw new StreamCorruptedException(String.format("invalid stream header: %04X%04X", s, s2));
        }
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        objectStreamClass.readNonProxy(this);
        return objectStreamClass;
    }

    @Override
    public int read() throws IOException {
        return this.bin.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        int n3 = n + n2;
        if (n < 0 || n2 < 0 || n3 > byArray.length || n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.bin.read(byArray, n, n2, false);
    }

    @Override
    public int available() throws IOException {
        return this.bin.available();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.depth == 0L) {
            this.clear();
        }
        this.bin.close();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.bin.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.bin.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.bin.readUnsignedByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.bin.readChar();
    }

    @Override
    public short readShort() throws IOException {
        return this.bin.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.bin.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.bin.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.bin.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.bin.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.bin.readDouble();
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.bin.readFully(byArray, 0, byArray.length, false);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        if (n < 0 || n2 < 0 || n3 > byArray.length || n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.bin.readFully(byArray, n, n2, false);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.bin.skipBytes(n);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.bin.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.bin.readUTF();
    }

    public final ObjectInputFilter getObjectInputFilter() {
        return this.serialFilter;
    }

    public final void setObjectInputFilter(ObjectInputFilter objectInputFilter) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ObjectStreamConstants.SERIAL_FILTER_PERMISSION);
        }
        if (this.totalObjectRefs > 0L && !Caches.SET_FILTER_AFTER_READ) {
            throw new IllegalStateException("filter can not be set after an object has been read");
        }
        if (this.streamFilterSet) {
            throw new IllegalStateException("filter can not be set more than once");
        }
        this.streamFilterSet = true;
        ObjectInputFilter objectInputFilter2 = (ObjectInputFilter)ObjectInputFilter.Config.getSerialFilterFactory().apply(this.serialFilter, objectInputFilter);
        if (this.serialFilter != null && objectInputFilter2 == null) {
            throw new IllegalStateException("filter can not be replaced with null filter");
        }
        this.serialFilter = objectInputFilter2;
    }

    private void filterCheck(Class<?> clazz, int n) throws InvalidClassException {
        DeserializationEvent deserializationEvent;
        long l = this.bin == null ? 0L : this.bin.getBytesRead();
        RuntimeException runtimeException = null;
        ObjectInputFilter.Status status = null;
        if (this.serialFilter != null) {
            try {
                status = this.serialFilter.checkInput(new FilterValues(clazz, n, this.totalObjectRefs, this.depth, l));
            }
            catch (RuntimeException runtimeException2) {
                status = ObjectInputFilter.Status.REJECTED;
                runtimeException = runtimeException2;
            }
            if (Logging.filterLogger != null) {
                Logging.filterLogger.log(status == null || status == ObjectInputFilter.Status.REJECTED ? System.Logger.Level.DEBUG : System.Logger.Level.TRACE, "ObjectInputFilter {0}: {1}, array length: {2}, nRefs: {3}, depth: {4}, bytes: {5}, ex: {6}", new Object[]{status, clazz, n, this.totalObjectRefs, this.depth, l, Objects.toString(runtimeException, "n/a")});
            }
        }
        if ((deserializationEvent = new DeserializationEvent()).shouldCommit()) {
            deserializationEvent.filterConfigured = this.serialFilter != null;
            deserializationEvent.filterStatus = status != null ? status.name() : null;
            deserializationEvent.type = clazz;
            deserializationEvent.arrayLength = n;
            deserializationEvent.objectReferences = this.totalObjectRefs;
            deserializationEvent.depth = this.depth;
            deserializationEvent.bytesRead = l;
            deserializationEvent.exceptionType = runtimeException != null ? runtimeException.getClass() : null;
            deserializationEvent.exceptionMessage = runtimeException != null ? runtimeException.getMessage() : null;
            deserializationEvent.commit();
        }
        if (this.serialFilter != null && (status == null || status == ObjectInputFilter.Status.REJECTED)) {
            InvalidClassException invalidClassException = new InvalidClassException("filter status: " + status);
            invalidClassException.initCause(runtimeException);
            throw invalidClassException;
        }
    }

    private void checkArray(Class<?> clazz, int n) throws InvalidClassException {
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("not an array type");
        }
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        this.filterCheck(clazz, n);
    }

    private void verifySubclass() {
        Class<?> clazz = this.getClass();
        if (clazz == ObjectInputStream.class) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        boolean bl = Caches.subclassAudits.get(clazz);
        if (!bl) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
    }

    private static Boolean auditSubclass(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Class clazz2 = clazz; clazz2 != ObjectInputStream.class; clazz2 = clazz2.getSuperclass()) {
                    try {
                        clazz2.getDeclaredMethod("readUnshared", null);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            clazz2.getDeclaredMethod("readFields", null);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        });
    }

    private void clear() {
        this.handles.clear();
        this.vlist.clear();
    }

    private Object readObject0(Class<?> clazz, boolean bl) throws IOException {
        int n;
        boolean bl2 = this.bin.getBlockDataMode();
        if (bl2) {
            n = this.bin.currentBlockRemaining();
            if (n > 0) {
                throw new OptionalDataException(n);
            }
            if (this.defaultDataEnd) {
                throw new OptionalDataException(true);
            }
            this.bin.setBlockDataMode(false);
        }
        while (true) {
            byte by = this.bin.peekByte();
            n = by;
            if (by != 121) break;
            this.bin.readByte();
            this.handleReset();
        }
        ++this.depth;
        ++this.totalObjectRefs;
        try {
            switch (n) {
                case 112: {
                    Object object = this.readNull();
                    return object;
                }
                case 113: {
                    Object obj = clazz.cast(this.readHandle(bl));
                    return obj;
                }
                case 118: {
                    if (clazz == String.class) {
                        throw new ClassCastException("Cannot cast a class to java.lang.String");
                    }
                    Class<?> clazz2 = this.readClass(bl);
                    return clazz2;
                }
                case 114: 
                case 125: {
                    if (clazz == String.class) {
                        throw new ClassCastException("Cannot cast a class to java.lang.String");
                    }
                    ObjectStreamClass objectStreamClass = this.readClassDesc(bl);
                    return objectStreamClass;
                }
                case 116: 
                case 124: {
                    Object object = this.checkResolve(this.readString(bl));
                    return object;
                }
                case 117: {
                    if (clazz == String.class) {
                        throw new ClassCastException("Cannot cast an array to java.lang.String");
                    }
                    Object object = this.checkResolve(this.readArray(bl));
                    return object;
                }
                case 126: {
                    if (clazz == String.class) {
                        throw new ClassCastException("Cannot cast an enum to java.lang.String");
                    }
                    Object object = this.checkResolve(this.readEnum(bl));
                    return object;
                }
                case 115: {
                    if (clazz == String.class) {
                        throw new ClassCastException("Cannot cast an object to java.lang.String");
                    }
                    Object object = this.checkResolve(this.readOrdinaryObject(bl));
                    return object;
                }
                case 123: {
                    if (clazz == String.class) {
                        throw new ClassCastException("Cannot cast an exception to java.lang.String");
                    }
                    IOException iOException = this.readFatalException();
                    throw new WriteAbortedException("writing aborted", iOException);
                }
                case 119: 
                case 122: {
                    if (bl2) {
                        this.bin.setBlockDataMode(true);
                        this.bin.peek();
                        throw new OptionalDataException(this.bin.currentBlockRemaining());
                    }
                    throw new StreamCorruptedException("unexpected block data");
                }
                case 120: {
                    if (bl2) {
                        throw new OptionalDataException(true);
                    }
                    throw new StreamCorruptedException("unexpected end of block data");
                }
            }
            throw new StreamCorruptedException(String.format("invalid type code: %02X", (byte)n));
        }
        finally {
            --this.depth;
            this.bin.setBlockDataMode(bl2);
        }
    }

    private Object checkResolve(Object object) throws IOException {
        if (!this.enableResolve || this.handles.lookupException(this.passHandle) != null) {
            return object;
        }
        Object object2 = this.resolveObject(object);
        if (object2 != object) {
            if (object2 != null) {
                if (object2.getClass().isArray()) {
                    this.filterCheck(object2.getClass(), Array.getLength(object2));
                } else {
                    this.filterCheck(object2.getClass(), -1);
                }
            }
            this.handles.setObject(this.passHandle, object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readTypeString() throws IOException {
        int n = this.passHandle;
        try {
            byte by = this.bin.peekByte();
            String string = switch (by) {
                case 112 -> (String)this.readNull();
                case 113 -> (String)this.readHandle(false);
                case 116, 124 -> this.readString(false);
                default -> throw new StreamCorruptedException(String.format("invalid type code: %02X", by));
            };
            return string;
        }
        finally {
            this.passHandle = n;
        }
    }

    private Object readNull() throws IOException {
        if (this.bin.readByte() != 112) {
            throw new InternalError();
        }
        this.passHandle = -1;
        return null;
    }

    private Object readHandle(boolean bl) throws IOException {
        if (this.bin.readByte() != 113) {
            throw new InternalError();
        }
        this.passHandle = this.bin.readInt() - 0x7E0000;
        if (this.passHandle < 0 || this.passHandle >= this.handles.size()) {
            throw new StreamCorruptedException(String.format("invalid handle value: %08X", this.passHandle + 0x7E0000));
        }
        if (bl) {
            throw new InvalidObjectException("cannot read back reference as unshared");
        }
        Object object = this.handles.lookupObject(this.passHandle);
        if (object == unsharedMarker) {
            throw new InvalidObjectException("cannot read back reference to unshared object");
        }
        this.filterCheck(null, -1);
        return object;
    }

    private Class<?> readClass(boolean bl) throws IOException {
        if (this.bin.readByte() != 118) {
            throw new InternalError();
        }
        ObjectStreamClass objectStreamClass = this.readClassDesc(false);
        Class<?> clazz = objectStreamClass.forClass();
        this.passHandle = this.handles.assign(bl ? unsharedMarker : clazz);
        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
        if (classNotFoundException != null) {
            this.handles.markException(this.passHandle, classNotFoundException);
        }
        this.handles.finish(this.passHandle);
        return clazz;
    }

    private ObjectStreamClass readClassDesc(boolean bl) throws IOException {
        byte by = this.bin.peekByte();
        return switch (by) {
            case 112 -> (ObjectStreamClass)this.readNull();
            case 125 -> this.readProxyDesc(bl);
            case 114 -> this.readNonProxyDesc(bl);
            case 113 -> {
                ObjectStreamClass var3_3 = (ObjectStreamClass)this.readHandle(bl);
                var3_3.checkInitialized();
                yield var3_3;
            }
            default -> throw new StreamCorruptedException(String.format("invalid type code: %02X", by));
        };
    }

    private boolean isCustomSubclass() {
        return this.getClass().getClassLoader() != ObjectInputStream.class.getClassLoader();
    }

    private ObjectStreamClass readProxyDesc(boolean bl) throws IOException {
        if (this.bin.readByte() != 125) {
            throw new InternalError();
        }
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        int n = this.handles.assign(bl ? unsharedMarker : objectStreamClass);
        this.passHandle = -1;
        int n2 = this.bin.readInt();
        if (n2 > 65535) {
            throw new InvalidObjectException("interface limit exceeded: " + n2 + ", limit: " + Caches.PROXY_INTERFACE_LIMIT);
        }
        Object[] objectArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this.bin.readUTF();
        }
        if (n2 > Caches.PROXY_INTERFACE_LIMIT) {
            throw new InvalidObjectException("interface limit exceeded: " + n2 + ", limit: " + Caches.PROXY_INTERFACE_LIMIT + "; " + Arrays.toString(objectArray));
        }
        Class<?> clazz = null;
        ClassNotFoundException classNotFoundException = null;
        this.bin.setBlockDataMode(true);
        try {
            clazz = this.resolveProxyClass((String[])objectArray);
            if (clazz == null) {
                classNotFoundException = new ClassNotFoundException("null class");
            } else {
                if (!Proxy.isProxyClass(clazz)) {
                    throw new InvalidClassException("Not a proxy");
                }
                ReflectUtil.checkProxyPackageAccess(this.getClass().getClassLoader(), clazz.getInterfaces());
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    this.filterCheck(clazz2, -1);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InvalidObjectException invalidObjectException = new InvalidObjectException("Proxy interface limit exceeded: " + Arrays.toString(objectArray));
            invalidObjectException.initCause(outOfMemoryError);
            throw invalidObjectException;
        }
        this.filterCheck(clazz, -1);
        this.skipCustomData();
        try {
            ++this.totalObjectRefs;
            ++this.depth;
            objectStreamClass.initProxy(clazz, classNotFoundException, this.readClassDesc(false));
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InvalidObjectException invalidObjectException = new InvalidObjectException("Proxy interface limit exceeded: " + Arrays.toString(objectArray));
            invalidObjectException.initCause(outOfMemoryError);
            throw invalidObjectException;
        }
        finally {
            --this.depth;
        }
        this.handles.finish(n);
        this.passHandle = n;
        return objectStreamClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectStreamClass readNonProxyDesc(boolean bl) throws IOException {
        ObjectStreamClass objectStreamClass;
        if (this.bin.readByte() != 114) {
            throw new InternalError();
        }
        ObjectStreamClass objectStreamClass2 = new ObjectStreamClass();
        int n = this.handles.assign(bl ? unsharedMarker : objectStreamClass2);
        this.passHandle = -1;
        try {
            objectStreamClass = this.readClassDescriptor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (IOException)new InvalidClassException("failed to read class descriptor").initCause(classNotFoundException);
        }
        Class<?> clazz = null;
        ClassNotFoundException classNotFoundException = null;
        this.bin.setBlockDataMode(true);
        boolean bl2 = this.isCustomSubclass();
        try {
            clazz = this.resolveClass(objectStreamClass);
            if (clazz == null) {
                classNotFoundException = new ClassNotFoundException("null class");
            } else if (bl2) {
                ReflectUtil.checkPackageAccess(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException2) {
            classNotFoundException = classNotFoundException2;
        }
        this.filterCheck(clazz, -1);
        this.skipCustomData();
        try {
            ++this.totalObjectRefs;
            ++this.depth;
            objectStreamClass2.initNonProxy(objectStreamClass, clazz, classNotFoundException, this.readClassDesc(false));
            if (clazz != null) {
                ObjectStreamClass objectStreamClass3;
                ObjectStreamClass objectStreamClass4 = null;
                for (objectStreamClass3 = objectStreamClass2.getSuperDesc(); objectStreamClass3 != null && (objectStreamClass4 = objectStreamClass3.getLocalDesc()) == null; objectStreamClass3 = objectStreamClass3.getSuperDesc()) {
                }
                for (objectStreamClass3 = objectStreamClass2.getLocalDesc().getSuperDesc(); objectStreamClass3 != null && objectStreamClass3 != objectStreamClass4; objectStreamClass3 = objectStreamClass3.getSuperDesc()) {
                    this.filterCheck(objectStreamClass3.forClass(), -1);
                }
            }
        }
        finally {
            --this.depth;
        }
        this.handles.finish(n);
        this.passHandle = n;
        return objectStreamClass2;
    }

    private String readString(boolean bl) throws IOException {
        byte by = this.bin.readByte();
        String string = switch (by) {
            case 116 -> this.bin.readUTF();
            case 124 -> this.bin.readLongUTF();
            default -> throw new StreamCorruptedException(String.format("invalid type code: %02X", by));
        };
        this.passHandle = this.handles.assign(bl ? unsharedMarker : string);
        this.handles.finish(this.passHandle);
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readArray(boolean bl) throws IOException {
        if (this.bin.readByte() != 117) {
            throw new InternalError();
        }
        ObjectStreamClass objectStreamClass = this.readClassDesc(false);
        int n = this.bin.readInt();
        this.filterCheck(objectStreamClass.forClass(), n);
        Object object = null;
        Class<?> clazz = null;
        Class<?> clazz2 = objectStreamClass.forClass();
        if (clazz2 != null) {
            clazz = clazz2.getComponentType();
            object = Array.newInstance(clazz, n);
        }
        int n2 = this.handles.assign(bl ? unsharedMarker : object);
        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
        if (classNotFoundException != null) {
            this.handles.markException(n2, classNotFoundException);
        }
        if (clazz == null) {
            for (int i = 0; i < n; ++i) {
                this.readObject0(Object.class, false);
            }
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                this.bin.readInts((int[])object, 0, n);
            } else if (clazz == Byte.TYPE) {
                this.bin.readFully((byte[])object, 0, n, true);
            } else if (clazz == Long.TYPE) {
                this.bin.readLongs((long[])object, 0, n);
            } else if (clazz == Float.TYPE) {
                this.bin.readFloats((float[])object, 0, n);
            } else if (clazz == Double.TYPE) {
                this.bin.readDoubles((double[])object, 0, n);
            } else if (clazz == Short.TYPE) {
                this.bin.readShorts((short[])object, 0, n);
            } else if (clazz == Character.TYPE) {
                this.bin.readChars((char[])object, 0, n);
            } else {
                if (clazz != Boolean.TYPE) throw new InternalError();
                this.bin.readBooleans((boolean[])object, 0, n);
            }
        } else {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.readObject0(Object.class, false);
                this.handles.markDependency(n2, this.passHandle);
            }
        }
        this.handles.finish(n2);
        this.passHandle = n2;
        return object;
    }

    private Enum<?> readEnum(boolean bl) throws IOException {
        if (this.bin.readByte() != 126) {
            throw new InternalError();
        }
        ObjectStreamClass objectStreamClass = this.readClassDesc(false);
        if (!objectStreamClass.isEnum()) {
            throw new InvalidClassException("non-enum class: " + objectStreamClass);
        }
        int n = this.handles.assign(bl ? unsharedMarker : null);
        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
        if (classNotFoundException != null) {
            this.handles.markException(n, classNotFoundException);
        }
        String string = this.readString(false);
        Enum<?> enum_ = null;
        Class<?> clazz = objectStreamClass.forClass();
        if (clazz != null) {
            try {
                Object obj = Enum.valueOf(clazz, string);
                enum_ = (Enum<?>)obj;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (IOException)new InvalidObjectException("enum constant " + string + " does not exist in " + clazz).initCause(illegalArgumentException);
            }
            if (!bl) {
                this.handles.setObject(n, enum_);
            }
        }
        this.handles.finish(n);
        this.passHandle = n;
        return enum_;
    }

    private Object readOrdinaryObject(boolean bl) throws IOException {
        boolean bl2;
        Object object;
        if (this.bin.readByte() != 115) {
            throw new InternalError();
        }
        ObjectStreamClass objectStreamClass = this.readClassDesc(false);
        objectStreamClass.checkDeserialize();
        Class<?> clazz = objectStreamClass.forClass();
        if (clazz == String.class || clazz == Class.class || clazz == ObjectStreamClass.class) {
            throw new InvalidClassException("invalid class descriptor");
        }
        try {
            object = objectStreamClass.isInstantiable() ? objectStreamClass.newInstance() : null;
        }
        catch (Exception exception) {
            throw (IOException)new InvalidClassException(objectStreamClass.forClass().getName(), "unable to create instance").initCause(exception);
        }
        this.passHandle = this.handles.assign(bl ? unsharedMarker : object);
        ClassNotFoundException classNotFoundException = objectStreamClass.getResolveException();
        if (classNotFoundException != null) {
            this.handles.markException(this.passHandle, classNotFoundException);
        }
        if (bl2 = objectStreamClass.isRecord()) {
            assert (object == null);
            object = this.readRecord(objectStreamClass);
            if (!bl) {
                this.handles.setObject(this.passHandle, object);
            }
        } else if (objectStreamClass.isExternalizable()) {
            this.readExternalData((Externalizable)object, objectStreamClass);
        } else {
            this.readSerialData(object, objectStreamClass);
        }
        this.handles.finish(this.passHandle);
        if (object != null && this.handles.lookupException(this.passHandle) == null && objectStreamClass.hasReadResolveMethod()) {
            Object object2 = objectStreamClass.invokeReadResolve(object);
            if (bl && object2.getClass().isArray()) {
                object2 = ObjectInputStream.cloneArray(object2);
            }
            if (object2 != object) {
                if (object2 != null) {
                    if (object2.getClass().isArray()) {
                        this.filterCheck(object2.getClass(), Array.getLength(object2));
                    } else {
                        this.filterCheck(object2.getClass(), -1);
                    }
                }
                object = object2;
                this.handles.setObject(this.passHandle, object);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readExternalData(Externalizable externalizable, ObjectStreamClass objectStreamClass) throws IOException {
        SerialCallbackContext serialCallbackContext = this.curContext;
        if (serialCallbackContext != null) {
            serialCallbackContext.check();
        }
        this.curContext = null;
        try {
            boolean bl = objectStreamClass.hasBlockExternalData();
            if (bl) {
                this.bin.setBlockDataMode(true);
            }
            if (externalizable != null) {
                try {
                    externalizable.readExternal(this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.handles.markException(this.passHandle, classNotFoundException);
                }
            }
            if (bl) {
                this.skipCustomData();
            }
        }
        finally {
            if (serialCallbackContext != null) {
                serialCallbackContext.check();
            }
            this.curContext = serialCallbackContext;
        }
    }

    private Object readRecord(ObjectStreamClass objectStreamClass) throws IOException {
        ObjectStreamClass.ClassDataSlot[] classDataSlotArray = objectStreamClass.getClassDataLayout();
        if (classDataSlotArray.length != 1) {
            for (int i = 0; i < classDataSlotArray.length - 1; ++i) {
                if (!classDataSlotArray[i].hasData) continue;
                new FieldValues(classDataSlotArray[i].desc, true);
            }
        }
        FieldValues fieldValues = new FieldValues(objectStreamClass, true);
        MethodHandle methodHandle = ObjectStreamClass.RecordSupport.deserializationCtr(objectStreamClass);
        try {
            return methodHandle.invokeExact(fieldValues.primValues, fieldValues.objValues);
        }
        catch (Exception exception) {
            InvalidObjectException invalidObjectException = new InvalidObjectException(exception.getMessage());
            invalidObjectException.initCause(exception);
            throw invalidObjectException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            InvalidObjectException invalidObjectException = new InvalidObjectException("ReflectiveOperationException during deserialization");
            invalidObjectException.initCause(throwable);
            throw invalidObjectException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSerialData(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        ObjectStreamClass objectStreamClass2;
        int n;
        ObjectStreamClass.ClassDataSlot[] classDataSlotArray = objectStreamClass.getClassDataLayout();
        FieldValues[] fieldValuesArray = null;
        boolean bl = false;
        for (n = 1; n < classDataSlotArray.length; ++n) {
            objectStreamClass2 = classDataSlotArray[n].desc;
            if (!objectStreamClass2.hasReadObjectMethod() && !objectStreamClass2.hasReadObjectNoDataMethod()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            fieldValuesArray = new FieldValues[classDataSlotArray.length];
        }
        for (n = 0; n < classDataSlotArray.length; ++n) {
            objectStreamClass2 = classDataSlotArray[n].desc;
            if (classDataSlotArray[n].hasData) {
                if (object == null || this.handles.lookupException(this.passHandle) != null) {
                    new FieldValues(objectStreamClass2, true);
                } else if (objectStreamClass2.hasReadObjectMethod()) {
                    block29: {
                        var8_8 = null;
                        boolean bl2 = false;
                        SerialCallbackContext serialCallbackContext = this.curContext;
                        if (serialCallbackContext != null) {
                            serialCallbackContext.check();
                        }
                        try {
                            this.curContext = new SerialCallbackContext(object, objectStreamClass2);
                            this.bin.setBlockDataMode(true);
                            objectStreamClass2.invokeReadObject(object, this);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this.handles.markException(this.passHandle, classNotFoundException);
                        }
                        finally {
                            do {
                                try {
                                    this.curContext.setUsed();
                                    if (serialCallbackContext != null) {
                                        serialCallbackContext.check();
                                    }
                                    this.curContext = serialCallbackContext;
                                    bl2 = true;
                                }
                                catch (ThreadDeath threadDeath) {
                                    var8_8 = threadDeath;
                                }
                            } while (!bl2);
                            if (var8_8 == null) break block29;
                            throw var8_8;
                        }
                    }
                    this.defaultDataEnd = false;
                } else {
                    var8_8 = new FieldValues(objectStreamClass2, true);
                    if (fieldValuesArray != null) {
                        fieldValuesArray[n] = var8_8;
                    } else if (object != null) {
                        ((FieldValues)var8_8).defaultCheckFieldValues(object);
                        ((FieldValues)var8_8).defaultSetFieldValues(object);
                    }
                }
                if (objectStreamClass2.hasWriteObjectData()) {
                    this.skipCustomData();
                    continue;
                }
                this.bin.setBlockDataMode(false);
                continue;
            }
            if (object == null || !objectStreamClass2.hasReadObjectNoDataMethod() || this.handles.lookupException(this.passHandle) != null) continue;
            objectStreamClass2.invokeReadObjectNoData(object);
        }
        if (object != null && fieldValuesArray != null) {
            for (n = 0; n < classDataSlotArray.length; ++n) {
                if (fieldValuesArray[n] == null) continue;
                fieldValuesArray[n].defaultCheckFieldValues(object);
            }
            for (n = 0; n < classDataSlotArray.length; ++n) {
                if (fieldValuesArray[n] == null) continue;
                fieldValuesArray[n].defaultSetFieldValues(object);
            }
        }
    }

    private void skipCustomData() throws IOException {
        int n = this.passHandle;
        block4: while (true) {
            if (this.bin.getBlockDataMode()) {
                this.bin.skipBlockData();
                this.bin.setBlockDataMode(false);
            }
            switch (this.bin.peekByte()) {
                case 119: 
                case 122: {
                    this.bin.setBlockDataMode(true);
                    continue block4;
                }
                case 120: {
                    this.bin.readByte();
                    this.passHandle = n;
                    return;
                }
            }
            this.readObject0(Object.class, false);
        }
    }

    private IOException readFatalException() throws IOException {
        if (this.bin.readByte() != 123) {
            throw new InternalError();
        }
        this.clear();
        byte by = this.bin.peekByte();
        if (by != 115 && by != 113) {
            throw new StreamCorruptedException(String.format("invalid type code: %02X", by));
        }
        return (IOException)this.readObject0(Object.class, false);
    }

    private void handleReset() throws StreamCorruptedException {
        if (this.depth > 0L) {
            throw new StreamCorruptedException("unexpected reset; recursion depth: " + this.depth);
        }
        this.clear();
    }

    private static ClassLoader latestUserDefinedLoader() {
        return VM.latestUserDefinedLoader();
    }

    private void freeze() {
        UNSAFE.storeFence();
    }

    private static Object cloneArray(Object object) {
        if (object instanceof Object[]) {
            return ((Object[])object).clone();
        }
        if (object instanceof boolean[]) {
            return ((boolean[])object).clone();
        }
        if (object instanceof byte[]) {
            return ((byte[])object).clone();
        }
        if (object instanceof char[]) {
            return ((char[])object).clone();
        }
        if (object instanceof double[]) {
            return ((double[])object).clone();
        }
        if (object instanceof float[]) {
            return ((float[])object).clone();
        }
        if (object instanceof int[]) {
            return ((int[])object).clone();
        }
        if (object instanceof long[]) {
            return ((long[])object).clone();
        }
        if (object instanceof short[]) {
            return ((short[])object).clone();
        }
        throw new AssertionError();
    }

    static {
        SharedSecrets.setJavaObjectInputStreamAccess(ObjectInputStream::checkArray);
        SharedSecrets.setJavaObjectInputStreamReadString(ObjectInputStream::readString);
    }

    private class BlockDataInputStream
    extends InputStream
    implements DataInput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private static final int HEADER_BLOCKED = -2;
        private final byte[] buf = new byte[1024];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[256];
        private boolean blkmode = false;
        private int pos = 0;
        private int end = -1;
        private int unread = 0;
        private final PeekInputStream in;
        private final DataInputStream din;

        BlockDataInputStream(InputStream inputStream) {
            this.in = new PeekInputStream(inputStream);
            this.din = new DataInputStream(this);
        }

        boolean setBlockDataMode(boolean bl) throws IOException {
            if (this.blkmode == bl) {
                return this.blkmode;
            }
            if (bl) {
                this.pos = 0;
                this.end = 0;
                this.unread = 0;
            } else if (this.pos < this.end) {
                throw new IllegalStateException("unread block data");
            }
            this.blkmode = bl;
            return !this.blkmode;
        }

        boolean getBlockDataMode() {
            return this.blkmode;
        }

        void skipBlockData() throws IOException {
            if (!this.blkmode) {
                throw new IllegalStateException("not in block data mode");
            }
            while (this.end >= 0) {
                this.refill();
            }
        }

        private int readBlockHeader(boolean bl) throws IOException {
            if (ObjectInputStream.this.defaultDataEnd) {
                return -1;
            }
            try {
                int n;
                block7: while (true) {
                    int n2;
                    int n3 = n2 = bl ? Integer.MAX_VALUE : this.in.available();
                    if (n2 == 0) {
                        return -2;
                    }
                    n = this.in.peek();
                    switch (n) {
                        case 119: {
                            if (n2 < 2) {
                                return -2;
                            }
                            this.in.readFully(this.hbuf, 0, 2);
                            return this.hbuf[1] & 0xFF;
                        }
                        case 122: {
                            if (n2 < 5) {
                                return -2;
                            }
                            this.in.readFully(this.hbuf, 0, 5);
                            int n4 = Bits.getInt((byte[])this.hbuf, (int)1);
                            if (n4 < 0) {
                                throw new StreamCorruptedException("illegal block data header length: " + n4);
                            }
                            return n4;
                        }
                        case 121: {
                            this.in.read();
                            ObjectInputStream.this.handleReset();
                            continue block7;
                        }
                    }
                    break;
                }
                if (n >= 0 && (n < 112 || n > 126)) {
                    throw new StreamCorruptedException(String.format("invalid type code: %02X", n));
                }
                return -1;
            }
            catch (EOFException eOFException) {
                throw new StreamCorruptedException("unexpected EOF while reading block data header");
            }
        }

        private void refill() throws IOException {
            try {
                do {
                    int n;
                    this.pos = 0;
                    if (this.unread > 0) {
                        n = this.in.read(this.buf, 0, Math.min(this.unread, 1024));
                        if (n >= 0) {
                            this.end = n;
                            this.unread -= n;
                            continue;
                        }
                        throw new StreamCorruptedException("unexpected EOF in middle of data block");
                    }
                    n = this.readBlockHeader(true);
                    if (n >= 0) {
                        this.end = 0;
                        this.unread = n;
                        continue;
                    }
                    this.end = -1;
                    this.unread = 0;
                } while (this.pos == this.end);
            }
            catch (IOException iOException) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
                throw iOException;
            }
        }

        int currentBlockRemaining() {
            if (this.blkmode) {
                return this.end >= 0 ? this.end - this.pos + this.unread : 0;
            }
            throw new IllegalStateException();
        }

        int peek() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                return this.end >= 0 ? this.buf[this.pos] & 0xFF : -1;
            }
            return this.in.peek();
        }

        byte peekByte() throws IOException {
            int n = this.peek();
            if (n < 0) {
                throw new EOFException();
            }
            return (byte)n;
        }

        @Override
        public int read() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                return this.end >= 0 ? this.buf[this.pos++] & 0xFF : -1;
            }
            return this.in.read();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.read(byArray, n, n2, false);
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = l;
            while (l2 > 0L) {
                int n;
                if (this.blkmode) {
                    if (this.pos == this.end) {
                        this.refill();
                    }
                    if (this.end < 0) break;
                    n = (int)Math.min(l2, (long)(this.end - this.pos));
                    l2 -= (long)n;
                    this.pos += n;
                    continue;
                }
                n = (int)Math.min(l2, 1024L);
                if ((n = this.in.read(this.buf, 0, n)) < 0) break;
                l2 -= (long)n;
            }
            return l - l2;
        }

        @Override
        public int available() throws IOException {
            if (this.blkmode) {
                int n;
                if (this.pos == this.end && this.unread == 0) {
                    while ((n = this.readBlockHeader(false)) == 0) {
                    }
                    switch (n) {
                        case -2: {
                            break;
                        }
                        case -1: {
                            this.pos = 0;
                            this.end = -1;
                            break;
                        }
                        default: {
                            this.pos = 0;
                            this.end = 0;
                            this.unread = n;
                        }
                    }
                }
                n = this.unread > 0 ? Math.min(this.in.available(), this.unread) : 0;
                return this.end >= 0 ? this.end - this.pos + n : 0;
            }
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            if (this.blkmode) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
            }
            this.in.close();
        }

        int read(byte[] byArray, int n, int n2, boolean bl) throws IOException {
            if (n2 == 0) {
                return 0;
            }
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                if (this.end < 0) {
                    return -1;
                }
                int n3 = Math.min(n2, this.end - this.pos);
                System.arraycopy(this.buf, this.pos, byArray, n, n3);
                this.pos += n3;
                return n3;
            }
            if (bl) {
                int n4 = this.in.read(this.buf, 0, Math.min(n2, 1024));
                if (n4 > 0) {
                    System.arraycopy(this.buf, 0, byArray, n, n4);
                }
                return n4;
            }
            return this.in.read(byArray, n, n2);
        }

        @Override
        public void readFully(byte[] byArray) throws IOException {
            this.readFully(byArray, 0, byArray.length, false);
        }

        @Override
        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            this.readFully(byArray, n, n2, false);
        }

        public void readFully(byte[] byArray, int n, int n2, boolean bl) throws IOException {
            while (n2 > 0) {
                int n3 = this.read(byArray, n, n2, bl);
                if (n3 < 0) {
                    throw new EOFException();
                }
                n += n3;
                n2 -= n3;
            }
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return this.din.skipBytes(n);
        }

        @Override
        public boolean readBoolean() throws IOException {
            int n = this.read();
            if (n < 0) {
                throw new EOFException();
            }
            return n != 0;
        }

        @Override
        public byte readByte() throws IOException {
            int n = this.read();
            if (n < 0) {
                throw new EOFException();
            }
            return (byte)n;
        }

        @Override
        public int readUnsignedByte() throws IOException {
            int n = this.read();
            if (n < 0) {
                throw new EOFException();
            }
            return n;
        }

        @Override
        public char readChar() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readChar();
            }
            char c = Bits.getChar((byte[])this.buf, (int)this.pos);
            this.pos += 2;
            return c;
        }

        @Override
        public short readShort() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readShort();
            }
            short s = Bits.getShort((byte[])this.buf, (int)this.pos);
            this.pos += 2;
            return s;
        }

        @Override
        public int readUnsignedShort() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readUnsignedShort();
            }
            int n = Bits.getShort((byte[])this.buf, (int)this.pos) & 0xFFFF;
            this.pos += 2;
            return n;
        }

        @Override
        public int readInt() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 4);
            } else if (this.end - this.pos < 4) {
                return this.din.readInt();
            }
            int n = Bits.getInt((byte[])this.buf, (int)this.pos);
            this.pos += 4;
            return n;
        }

        @Override
        public float readFloat() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 4);
            } else if (this.end - this.pos < 4) {
                return this.din.readFloat();
            }
            float f = Bits.getFloat((byte[])this.buf, (int)this.pos);
            this.pos += 4;
            return f;
        }

        @Override
        public long readLong() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 8);
            } else if (this.end - this.pos < 8) {
                return this.din.readLong();
            }
            long l = Bits.getLong((byte[])this.buf, (int)this.pos);
            this.pos += 8;
            return l;
        }

        @Override
        public double readDouble() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 8);
            } else if (this.end - this.pos < 8) {
                return this.din.readDouble();
            }
            double d = Bits.getDouble((byte[])this.buf, (int)this.pos);
            this.pos += 8;
            return d;
        }

        @Override
        public String readUTF() throws IOException {
            return this.readUTFBody(this.readUnsignedShort());
        }

        @Override
        public String readLine() throws IOException {
            return this.din.readLine();
        }

        void readBooleans(boolean[] blArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            while (n < n3) {
                int n4;
                if (!this.blkmode) {
                    int n5 = Math.min(n3 - n, 1024);
                    this.in.readFully(this.buf, 0, n5);
                    n4 = n + n5;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 1) {
                        blArray[n++] = this.din.readBoolean();
                        continue;
                    }
                    n4 = Math.min(n3, n + this.end - this.pos);
                }
                while (n < n4) {
                    blArray[n++] = Bits.getBoolean((byte[])this.buf, (int)this.pos++);
                }
            }
        }

        void readChars(char[] cArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            while (n < n3) {
                int n4;
                if (!this.blkmode) {
                    int n5 = Math.min(n3 - n, 512);
                    this.in.readFully(this.buf, 0, n5 << 1);
                    n4 = n + n5;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 2) {
                        cArray[n++] = this.din.readChar();
                        continue;
                    }
                    n4 = Math.min(n3, n + (this.end - this.pos >> 1));
                }
                while (n < n4) {
                    cArray[n++] = Bits.getChar((byte[])this.buf, (int)this.pos);
                    this.pos += 2;
                }
            }
        }

        void readShorts(short[] sArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            while (n < n3) {
                int n4;
                if (!this.blkmode) {
                    int n5 = Math.min(n3 - n, 512);
                    this.in.readFully(this.buf, 0, n5 << 1);
                    n4 = n + n5;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 2) {
                        sArray[n++] = this.din.readShort();
                        continue;
                    }
                    n4 = Math.min(n3, n + (this.end - this.pos >> 1));
                }
                while (n < n4) {
                    sArray[n++] = Bits.getShort((byte[])this.buf, (int)this.pos);
                    this.pos += 2;
                }
            }
        }

        void readInts(int[] nArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            while (n < n3) {
                int n4;
                if (!this.blkmode) {
                    int n5 = Math.min(n3 - n, 256);
                    this.in.readFully(this.buf, 0, n5 << 2);
                    n4 = n + n5;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 4) {
                        nArray[n++] = this.din.readInt();
                        continue;
                    }
                    n4 = Math.min(n3, n + (this.end - this.pos >> 2));
                }
                while (n < n4) {
                    nArray[n++] = Bits.getInt((byte[])this.buf, (int)this.pos);
                    this.pos += 4;
                }
            }
        }

        void readFloats(float[] fArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            while (n < n3) {
                int n4;
                if (!this.blkmode) {
                    int n5 = Math.min(n3 - n, 256);
                    this.in.readFully(this.buf, 0, n5 << 2);
                    n4 = n + n5;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 4) {
                        fArray[n++] = this.din.readFloat();
                        continue;
                    }
                    n4 = Math.min(n3, this.end - this.pos >> 2);
                }
                while (n < n4) {
                    fArray[n++] = Bits.getFloat((byte[])this.buf, (int)this.pos);
                    this.pos += 4;
                }
            }
        }

        void readLongs(long[] lArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            while (n < n3) {
                int n4;
                if (!this.blkmode) {
                    int n5 = Math.min(n3 - n, 128);
                    this.in.readFully(this.buf, 0, n5 << 3);
                    n4 = n + n5;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 8) {
                        lArray[n++] = this.din.readLong();
                        continue;
                    }
                    n4 = Math.min(n3, n + (this.end - this.pos >> 3));
                }
                while (n < n4) {
                    lArray[n++] = Bits.getLong((byte[])this.buf, (int)this.pos);
                    this.pos += 8;
                }
            }
        }

        void readDoubles(double[] dArray, int n, int n2) throws IOException {
            int n3 = n + n2;
            while (n < n3) {
                int n4;
                if (!this.blkmode) {
                    int n5 = Math.min(n3 - n, 128);
                    this.in.readFully(this.buf, 0, n5 << 3);
                    n4 = n + n5;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 8) {
                        dArray[n++] = this.din.readDouble();
                        continue;
                    }
                    n4 = Math.min(n3 - n, this.end - this.pos >> 3);
                }
                while (n < n4) {
                    dArray[n++] = Bits.getDouble((byte[])this.buf, (int)this.pos);
                    this.pos += 8;
                }
            }
        }

        String readLongUTF() throws IOException {
            return this.readUTFBody(this.readLong());
        }

        private String readUTFBody(long l) throws IOException {
            StringBuilder stringBuilder;
            int n;
            if (l > 0L && l < Integer.MAX_VALUE) {
                n = Math.min((int)l, 65535);
                stringBuilder = new StringBuilder(n);
            } else {
                stringBuilder = new StringBuilder();
            }
            if (!this.blkmode) {
                this.pos = 0;
                this.end = 0;
            }
            while (l > 0L) {
                n = this.end - this.pos;
                if (n >= 3 || (long)n == l) {
                    l -= this.readUTFSpan(stringBuilder, l);
                    continue;
                }
                if (this.blkmode) {
                    l -= (long)this.readUTFChar(stringBuilder, l);
                    continue;
                }
                if (n > 0) {
                    System.arraycopy(this.buf, this.pos, this.buf, 0, n);
                }
                this.pos = 0;
                this.end = (int)Math.min(1024L, l);
                this.in.readFully(this.buf, n, this.end - n);
            }
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long readUTFSpan(StringBuilder stringBuilder, long l) throws IOException {
            int n;
            int n2;
            block13: {
                n2 = 0;
                n = this.pos;
                int n3 = Math.min(this.end - this.pos, 256);
                int n4 = this.pos + (l > (long)n3 ? n3 - 2 : (int)l);
                boolean bl = false;
                try {
                    block10: while (this.pos < n4) {
                        int n5 = this.buf[this.pos++] & 0xFF;
                        switch (n5 >> 4) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                this.cbuf[n2++] = (char)n5;
                                continue block10;
                            }
                            case 12: 
                            case 13: {
                                byte by2 = this.buf[this.pos++];
                                if ((by2 & 0xC0) != 128) {
                                    throw new UTFDataFormatException();
                                }
                                this.cbuf[n2++] = (char)((n5 & 0x1F) << 6 | (by2 & 0x3F) << 0);
                                continue block10;
                            }
                            case 14: {
                                byte by = this.buf[this.pos + 1];
                                byte by2 = this.buf[this.pos + 0];
                                this.pos += 2;
                                if ((by2 & 0xC0) != 128) throw new UTFDataFormatException();
                                if ((by & 0xC0) != 128) {
                                    throw new UTFDataFormatException();
                                }
                                this.cbuf[n2++] = (char)((n5 & 0xF) << 12 | (by2 & 0x3F) << 6 | (by & 0x3F) << 0);
                                continue block10;
                            }
                        }
                        throw new UTFDataFormatException();
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    bl = true;
                    return (long)bl;
                }
                finally {
                    if (!bl && (long)(this.pos - n) <= l) break block13;
                    this.pos = n + (int)l;
                    throw new UTFDataFormatException();
                }
            }
            stringBuilder.append(this.cbuf, 0, n2);
            return this.pos - n;
        }

        private int readUTFChar(StringBuilder stringBuilder, long l) throws IOException {
            int n = this.readByte() & 0xFF;
            switch (n >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    stringBuilder.append((char)n);
                    return 1;
                }
                case 12: 
                case 13: {
                    if (l < 2L) {
                        throw new UTFDataFormatException();
                    }
                    byte by = this.readByte();
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuilder.append((char)((n & 0x1F) << 6 | (by & 0x3F) << 0));
                    return 2;
                }
                case 14: {
                    if (l < 3L) {
                        if (l == 2L) {
                            this.readByte();
                        }
                        throw new UTFDataFormatException();
                    }
                    byte by = this.readByte();
                    byte by2 = this.readByte();
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuilder.append((char)((n & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0));
                    return 3;
                }
            }
            throw new UTFDataFormatException();
        }

        long getBytesRead() {
            return this.in.getBytesRead();
        }
    }

    private static class HandleTable {
        private static final byte STATUS_OK = 1;
        private static final byte STATUS_UNKNOWN = 2;
        private static final byte STATUS_EXCEPTION = 3;
        byte[] status;
        Object[] entries;
        HandleList[] deps;
        int lowDep = -1;
        int size = 0;

        HandleTable(int n) {
            this.status = new byte[n];
            this.entries = new Object[n];
            this.deps = new HandleList[n];
        }

        int assign(Object object) {
            if (this.size >= this.entries.length) {
                this.grow();
            }
            this.status[this.size] = 2;
            this.entries[this.size] = object;
            return this.size++;
        }

        void markDependency(int n, int n2) {
            if (n == n2 || n == -1 || n2 == -1) {
                return;
            }
            block0 : switch (this.status[n]) {
                case 2: {
                    switch (this.status[n2]) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            this.markException(n, (ClassNotFoundException)this.entries[n2]);
                            break block0;
                        }
                        case 2: {
                            if (this.deps[n2] == null) {
                                this.deps[n2] = new HandleList();
                            }
                            this.deps[n2].add(n);
                            if (this.lowDep >= 0 && this.lowDep <= n2) break block0;
                            this.lowDep = n2;
                            break block0;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        void markException(int n, ClassNotFoundException classNotFoundException) {
            switch (this.status[n]) {
                case 2: {
                    this.status[n] = 3;
                    this.entries[n] = classNotFoundException;
                    HandleList handleList = this.deps[n];
                    if (handleList == null) break;
                    int n2 = handleList.size();
                    for (int i = 0; i < n2; ++i) {
                        this.markException(handleList.get(i), classNotFoundException);
                    }
                    this.deps[n] = null;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        void finish(int n) {
            int n2;
            if (this.lowDep < 0) {
                n2 = n + 1;
            } else if (this.lowDep >= n) {
                n2 = this.size;
                this.lowDep = -1;
            } else {
                return;
            }
            block4: for (int i = n; i < n2; ++i) {
                switch (this.status[i]) {
                    case 2: {
                        this.status[i] = 1;
                        this.deps[i] = null;
                        continue block4;
                    }
                    case 1: 
                    case 3: {
                        continue block4;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void setObject(int n, Object object) {
            switch (this.status[n]) {
                case 1: 
                case 2: {
                    this.entries[n] = object;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        Object lookupObject(int n) {
            return n != -1 && this.status[n] != 3 ? this.entries[n] : null;
        }

        ClassNotFoundException lookupException(int n) {
            return n != -1 && this.status[n] == 3 ? (ClassNotFoundException)this.entries[n] : null;
        }

        void clear() {
            Arrays.fill(this.status, 0, this.size, (byte)0);
            Arrays.fill(this.entries, 0, this.size, null);
            Arrays.fill(this.deps, 0, this.size, null);
            this.lowDep = -1;
            this.size = 0;
        }

        int size() {
            return this.size;
        }

        private void grow() {
            int n = (this.entries.length << 1) + 1;
            byte[] byArray = new byte[n];
            Object[] objectArray = new Object[n];
            HandleList[] handleListArray = new HandleList[n];
            System.arraycopy(this.status, 0, byArray, 0, this.size);
            System.arraycopy(this.entries, 0, objectArray, 0, this.size);
            System.arraycopy(this.deps, 0, handleListArray, 0, this.size);
            this.status = byArray;
            this.entries = objectArray;
            this.deps = handleListArray;
        }

        private static class HandleList {
            private int[] list = new int[4];
            private int size = 0;

            public void add(int n) {
                if (this.size >= this.list.length) {
                    int[] nArray = new int[this.list.length << 1];
                    System.arraycopy(this.list, 0, nArray, 0, this.list.length);
                    this.list = nArray;
                }
                this.list[this.size++] = n;
            }

            public int get(int n) {
                if (n >= this.size) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return this.list[n];
            }

            public int size() {
                return this.size;
            }
        }
    }

    private static class ValidationList {
        private Callback list;

        ValidationList() {
        }

        void register(ObjectInputValidation objectInputValidation, int n) throws InvalidObjectException {
            if (objectInputValidation == null) {
                throw new InvalidObjectException("null callback");
            }
            Callback callback = null;
            Callback callback2 = this.list;
            while (callback2 != null && n < callback2.priority) {
                callback = callback2;
                callback2 = callback2.next;
            }
            AccessControlContext accessControlContext = AccessController.getContext();
            if (callback != null) {
                callback.next = new Callback(objectInputValidation, n, callback2, accessControlContext);
            } else {
                this.list = new Callback(objectInputValidation, n, this.list, accessControlContext);
            }
        }

        void doCallbacks() throws InvalidObjectException {
            try {
                while (this.list != null) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws InvalidObjectException {
                            list.obj.validateObject();
                            return null;
                        }
                    }, this.list.acc);
                    this.list = this.list.next;
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.list = null;
                throw (InvalidObjectException)privilegedActionException.getException();
            }
        }

        public void clear() {
            this.list = null;
        }

        private static class Callback {
            final ObjectInputValidation obj;
            final int priority;
            Callback next;
            final AccessControlContext acc;

            Callback(ObjectInputValidation objectInputValidation, int n, Callback callback, AccessControlContext accessControlContext) {
                this.obj = objectInputValidation;
                this.priority = n;
                this.next = callback;
                this.acc = accessControlContext;
            }
        }
    }

    private final class FieldValues
    extends GetField {
        private final ObjectStreamClass desc;
        final byte[] primValues;
        final Object[] objValues;
        private final int[] objHandles;

        FieldValues(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
            int n;
            this.desc = objectStreamClass;
            int n2 = objectStreamClass.getPrimDataSize();
            byte[] byArray = this.primValues = n2 > 0 ? new byte[n2] : null;
            if (n2 > 0) {
                ObjectInputStream.this.bin.readFully(this.primValues, 0, n2, false);
            }
            this.objValues = (n = objectStreamClass.getNumObjFields()) > 0 ? new Object[n] : null;
            int[] nArray = this.objHandles = n > 0 ? new int[n] : null;
            if (n > 0) {
                int n3 = ObjectInputStream.this.passHandle;
                ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields(false);
                int n4 = objectStreamFieldArray.length - this.objValues.length;
                for (int i = 0; i < this.objValues.length; ++i) {
                    ObjectStreamField objectStreamField = objectStreamFieldArray[n4 + i];
                    this.objValues[i] = ObjectInputStream.this.readObject0(Object.class, objectStreamField.isUnshared());
                    this.objHandles[i] = ObjectInputStream.this.passHandle;
                    if (!bl || objectStreamField.getField() == null) continue;
                    ObjectInputStream.this.handles.markDependency(n3, ObjectInputStream.this.passHandle);
                }
                ObjectInputStream.this.passHandle = n3;
            }
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            return this.desc;
        }

        @Override
        public boolean defaulted(String string) {
            return this.getFieldOffset(string, null) < 0;
        }

        @Override
        public boolean get(String string, boolean bl) {
            int n = this.getFieldOffset(string, Boolean.TYPE);
            return n >= 0 ? Bits.getBoolean((byte[])this.primValues, (int)n) : bl;
        }

        @Override
        public byte get(String string, byte by) {
            int n = this.getFieldOffset(string, Byte.TYPE);
            return n >= 0 ? this.primValues[n] : by;
        }

        @Override
        public char get(String string, char c) {
            int n = this.getFieldOffset(string, Character.TYPE);
            return n >= 0 ? Bits.getChar((byte[])this.primValues, (int)n) : c;
        }

        @Override
        public short get(String string, short s) {
            int n = this.getFieldOffset(string, Short.TYPE);
            return n >= 0 ? Bits.getShort((byte[])this.primValues, (int)n) : s;
        }

        @Override
        public int get(String string, int n) {
            int n2 = this.getFieldOffset(string, Integer.TYPE);
            return n2 >= 0 ? Bits.getInt((byte[])this.primValues, (int)n2) : n;
        }

        @Override
        public float get(String string, float f) {
            int n = this.getFieldOffset(string, Float.TYPE);
            return n >= 0 ? Bits.getFloat((byte[])this.primValues, (int)n) : f;
        }

        @Override
        public long get(String string, long l) {
            int n = this.getFieldOffset(string, Long.TYPE);
            return n >= 0 ? Bits.getLong((byte[])this.primValues, (int)n) : l;
        }

        @Override
        public double get(String string, double d) {
            int n = this.getFieldOffset(string, Double.TYPE);
            return n >= 0 ? Bits.getDouble((byte[])this.primValues, (int)n) : d;
        }

        @Override
        public Object get(String string, Object object) {
            int n = this.getFieldOffset(string, Object.class);
            if (n >= 0) {
                int n2 = this.objHandles[n];
                ObjectInputStream.this.handles.markDependency(ObjectInputStream.this.passHandle, n2);
                return ObjectInputStream.this.handles.lookupException(n2) == null ? this.objValues[n] : null;
            }
            return object;
        }

        void defaultCheckFieldValues(Object object) {
            if (this.objValues != null) {
                this.desc.checkObjFieldValueTypes(object, this.objValues);
            }
        }

        private void defaultSetFieldValues(Object object) {
            if (this.primValues != null) {
                this.desc.setPrimFieldValues(object, this.primValues);
            }
            if (this.objValues != null) {
                this.desc.setObjFieldValues(object, this.objValues);
            }
        }

        private int getFieldOffset(String string, Class<?> clazz) {
            ObjectStreamField objectStreamField = this.desc.getField(string, clazz);
            if (objectStreamField != null) {
                return objectStreamField.getOffset();
            }
            if (this.desc.getLocalDesc().getField(string, clazz) != null) {
                return -1;
            }
            throw new IllegalArgumentException("no such field " + string + " with type " + clazz);
        }
    }

    private static class Caches {
        static final ClassValue<Boolean> subclassAudits = new ClassValue<Boolean>(){

            @Override
            protected Boolean computeValue(Class<?> clazz) {
                return ObjectInputStream.auditSubclass(clazz);
            }
        };
        static final boolean SET_FILTER_AFTER_READ = GetBooleanAction.privilegedGetProperty("jdk.serialSetFilterAfterRead");
        static final int PROXY_INTERFACE_LIMIT = Math.max(0, Math.min(65535, GetIntegerAction.privilegedGetProperty("jdk.serialProxyInterfaceLimit", 65535)));

        private Caches() {
        }
    }

    static class FilterValues
    implements ObjectInputFilter.FilterInfo {
        final Class<?> clazz;
        final long arrayLength;
        final long totalObjectRefs;
        final long depth;
        final long streamBytes;

        public FilterValues(Class<?> clazz, long l, long l2, long l3, long l4) {
            this.clazz = clazz;
            this.arrayLength = l;
            this.totalObjectRefs = l2;
            this.depth = l3;
            this.streamBytes = l4;
        }

        @Override
        public Class<?> serialClass() {
            return this.clazz;
        }

        @Override
        public long arrayLength() {
            return this.arrayLength;
        }

        @Override
        public long references() {
            return this.totalObjectRefs;
        }

        @Override
        public long depth() {
            return this.depth;
        }

        @Override
        public long streamBytes() {
            return this.streamBytes;
        }
    }

    private static class Logging {
        static final System.Logger filterLogger;

        private Logging() {
        }

        static {
            System.Logger logger = System.getLogger("java.io.serialization");
            filterLogger = logger.isLoggable(System.Logger.Level.DEBUG) || logger.isLoggable(System.Logger.Level.TRACE) ? logger : null;
        }
    }

    private static class PeekInputStream
    extends InputStream {
        private final InputStream in;
        private int peekb = -1;
        private long totalBytesRead = 0L;

        PeekInputStream(InputStream inputStream) {
            this.in = inputStream;
        }

        int peek() throws IOException {
            if (this.peekb >= 0) {
                return this.peekb;
            }
            this.peekb = this.in.read();
            this.totalBytesRead += this.peekb >= 0 ? 1L : 0L;
            return this.peekb;
        }

        @Override
        public int read() throws IOException {
            if (this.peekb >= 0) {
                int n = this.peekb;
                this.peekb = -1;
                return n;
            }
            int n = this.in.read();
            this.totalBytesRead += n >= 0 ? 1L : 0L;
            return n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (n2 == 0) {
                return 0;
            }
            if (this.peekb < 0) {
                int n4 = this.in.read(byArray, n, n2);
                this.totalBytesRead += n4 >= 0 ? (long)n4 : 0L;
                return n4;
            }
            byArray[n++] = (byte)this.peekb;
            this.peekb = -1;
            this.totalBytesRead += (n3 = this.in.read(byArray, n, --n2)) >= 0 ? (long)n3 : 0L;
            return n3 >= 0 ? n3 + 1 : 1;
        }

        void readFully(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            for (int i = 0; i < n2; i += n3) {
                n3 = this.read(byArray, n + i, n2 - i);
                if (n3 >= 0) continue;
                throw new EOFException();
            }
        }

        @Override
        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            int n = 0;
            if (this.peekb >= 0) {
                this.peekb = -1;
                ++n;
                --l;
            }
            l = (long)n + this.in.skip(l);
            this.totalBytesRead += l;
            return l;
        }

        @Override
        public int available() throws IOException {
            return this.in.available() + (this.peekb >= 0 ? 1 : 0);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        public long getBytesRead() {
            return this.totalBytesRead;
        }
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException;

        public abstract boolean get(String var1, boolean var2) throws IOException;

        public abstract byte get(String var1, byte var2) throws IOException;

        public abstract char get(String var1, char var2) throws IOException;

        public abstract short get(String var1, short var2) throws IOException;

        public abstract int get(String var1, int var2) throws IOException;

        public abstract long get(String var1, long var2) throws IOException;

        public abstract float get(String var1, float var2) throws IOException;

        public abstract double get(String var1, double var2) throws IOException;

        public abstract Object get(String var1, Object var2) throws IOException;
    }
}

