/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public ByteArrayInputStream(byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public ByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.count = Math.min(n + n2, byArray.length);
        this.mark = n;
    }

    @Override
    public synchronized int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) {
        Objects.checkFromIndexSize(n, n2, byArray.length);
        if (this.pos >= this.count) {
            return -1;
        }
        int n3 = this.count - this.pos;
        if (n2 > n3) {
            n2 = n3;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    @Override
    public synchronized byte[] readAllBytes() {
        byte[] byArray = Arrays.copyOfRange(this.buf, this.pos, this.count);
        this.pos = this.count;
        return byArray;
    }

    @Override
    public int readNBytes(byte[] byArray, int n, int n2) {
        int n3 = this.read(byArray, n, n2);
        return n3 == -1 ? 0 : n3;
    }

    @Override
    public synchronized long transferTo(OutputStream outputStream) throws IOException {
        int n = this.count - this.pos;
        outputStream.write(this.buf, this.pos, n);
        this.pos = this.count;
        return n;
    }

    @Override
    public synchronized long skip(long l) {
        long l2 = this.count - this.pos;
        if (l < l2) {
            l2 = l < 0L ? 0L : l;
        }
        this.pos = (int)((long)this.pos + l2);
        return l2;
    }

    @Override
    public synchronized int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        this.mark = this.pos;
    }

    @Override
    public synchronized void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() throws IOException {
    }
}

