/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.zvrobot.tickprofile.internals;

import com.azul.xml.sax.Characters;
import com.azul.xml.sax.stack.Tag;
import com.azul.zing.zvrobot.tickprofile.CodeRef;
import com.azul.zing.zvrobot.tickprofile.internals.CodeRefHandler;
import com.azul.zing.zvrobot.tickprofile.internals.LeafTagHandler;
import com.azul.zing.zvrobot.tickprofile.internals.PcRefImpl;

final class PcRefTagHandler
extends CodeRefHandler {
    PcRefImpl pcRef = new PcRefImpl();

    PcRefTagHandler() {
    }

    @Override
    CodeRef result() {
        return this.pcRef;
    }

    @Override
    LeafTagHandler.CharactersHandler getCharactersHandler(Tag tag) throws Exception {
        switch (tag.qName) {
            case "pretty_name": {
                return chars -> {
                    this.pcRef.prettyName = chars.toString();
                };
            }
            case "name": {
                return chars -> {
                    this.pcRef.name = chars.toString();
                };
            }
            case "address": {
                return chars -> {
                    this.pcRef.address = PcRefTagHandler.parseAddress(chars);
                };
            }
        }
        return null;
    }

    private static long parseAddress(Characters chars) {
        String addressStr = chars.toString();
        if (addressStr.startsWith("0x")) {
            addressStr = addressStr.substring("0x".length());
        }
        return Long.parseUnsignedLong(addressStr, 16);
    }
}

