/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.zvrobot.tickprofile.internals;

import com.azul.xml.sax.Characters;
import com.azul.xml.sax.stack.DefaultTagHandler;
import com.azul.xml.sax.stack.Tag;
import com.azul.xml.sax.stack.TagHandler;
import com.azul.zing.zvrobot.tickprofile.ProfileEntry;
import com.azul.zing.zvrobot.tickprofile.internals.LeafTagHandler;
import com.azul.zing.zvrobot.tickprofile.internals.ProfileEntryImpl;
import com.azul.zing.zvrobot.tickprofile.internals.ValueTagHandler;

final class EntryTagHandler
extends DefaultTagHandler {
    private ProfileEntryImpl entry = new ProfileEntryImpl();

    EntryTagHandler() {
    }

    protected ProfileEntry result() {
        return this.entry;
    }

    @Override
    public TagHandler getChildTagHandler(Tag tag) throws Exception {
        switch (tag.qName) {
            case "percent": {
                return new LeafTagHandler(chars -> {
                    this.entry.percentage = EntryTagHandler.parsePercentage(chars);
                });
            }
            case "ticks": {
                return new LeafTagHandler(chars -> {
                    this.entry.ticks = chars.parseInt();
                });
            }
            case "value": {
                return new ValueTagHandler();
            }
        }
        return null;
    }

    @Override
    public final void endChildTag(Tag tag, TagHandler childHandler) throws Exception {
        switch (tag.qName) {
            case "value": {
                ValueTagHandler valueHandler = (ValueTagHandler)childHandler;
                this.entry.codeRef = valueHandler.result();
            }
        }
    }

    private static double parsePercentage(Characters chars) {
        String percentageStr = chars.toString().trim();
        if (percentageStr.lastIndexOf(37) == percentageStr.length() - 1) {
            percentageStr = percentageStr.substring(0, percentageStr.length() - 1);
        }
        return Double.parseDouble(percentageStr);
    }
}

