/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.zvrobot;

import com.azul.xml.sax.Sax;
import com.azul.zing.zvrobot.tickprofile.TickProfileProcessor;
import com.azul.zing.zvrobot.tickprofile.internals.TickProfileSaxHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TickProfileFile
implements Comparable<TickProfileFile> {
    private final File file;
    private final int seqNum;

    TickProfileFile(File file, int seqNum) {
        this.file = file;
        this.seqNum = seqNum;
    }

    public final String name() {
        return this.file.getName();
    }

    public final int sequenceNumber() {
        return this.seqNum;
    }

    public void process(TickProfileProcessor processor) {
        SAXParser parser = Sax.createDefaultParser();
        try {
            parser.parse(new InputSource(new FileInputStream(this.file)), (DefaultHandler)new TickProfileSaxHandler(processor));
        }
        catch (IOException | SAXException e) {
            throw new IllegalStateException("Problem parsing " + this.file, e);
        }
    }

    @Override
    public final int compareTo(TickProfileFile that) {
        return Integer.compare(this.seqNum, that.seqNum);
    }
}

