/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.time.internals;

import com.azul.gulp.Emitter;
import com.azul.gulp.Gulp;
import com.azul.gulp.Normalizer;
import com.azul.gulp.text.Line;
import com.azul.jvm.Jvm;
import com.azul.jvm.time.VmTime;

public class ZingVmTimeLineNormalizer
implements Normalizer<Line> {
    @Gulp.Inject
    Emitter<VmTime> timeEmitter;
    @Gulp.Inject
    Emitter<Jvm> jvmEmitter;

    @Override
    public final Line normalize(Line line) throws Exception {
        String prefix = this.extractPrefix(line);
        if (prefix == null) {
            return line;
        }
        this.jvmEmitter.fire(Jvm.ZING);
        String[] prefixParts = prefix.split("\\.");
        if (prefixParts.length != 2) {
            prefixParts = prefix.split("\\,");
        }
        int prefixSecs = Integer.parseInt(prefixParts[0], 10);
        int prefixMillis = Integer.parseInt(prefixParts[1], 10);
        String affix = this.extractAffix(line, prefix);
        int totalMillis = 1000 * prefixSecs + prefixMillis;
        this.timeEmitter.fire(VmTime.fromMillis(totalMillis));
        int colonPos = line.indexOf(':');
        if (colonPos == -1 || colonPos > 10) {
            return line;
        }
        if (affix != null) {
            return line.subLine(colonPos + 2, line.length() - affix.length());
        }
        return line.subLine(colonPos + 2);
    }

    private String extractPrefix(Line line) {
        boolean sawDot = false;
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (Character.isDigit(ch)) continue;
            if (ZingVmTimeLineNormalizer.isFractionalSeparator(ch) && !sawDot) {
                sawDot = true;
                continue;
            }
            if (ch != ':') break;
            if (sawDot) {
                return line.substring(0, i);
            }
            return null;
        }
        return null;
    }

    private static boolean isFractionalSeparator(char ch) {
        return ch == '.' || ch == ',';
    }

    private String extractAffix(Line line, String prefix) {
        int preDecCount = 0;
        boolean sawDot = false;
        for (int i = line.length() - 1; i >= 0; --i) {
            char ch = line.charAt(i);
            if (Character.isDigit(ch)) {
                if (sawDot) continue;
                ++preDecCount;
                continue;
            }
            if (ZingVmTimeLineNormalizer.isFractionalSeparator(ch) && !sawDot) {
                sawDot = true;
                continue;
            }
            if (!sawDot || preDecCount != 6) break;
            return Character.isWhitespace(line.charAt(i)) ? line.substring(i + 1) : null;
        }
        return null;
    }
}

