/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.time.internals;

import com.azul.gulp.Emitter;
import com.azul.gulp.Gulp;
import com.azul.gulp.Normalizer;
import com.azul.gulp.text.Line;
import com.azul.jvm.time.EpochTime;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EpochLineNormalizer
implements Normalizer<Line> {
    private final DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    @Gulp.Inject
    Emitter<EpochTime> epochEmitter;

    @Override
    public final Line normalize(Line line) throws Exception {
        if (line.length() < 28) {
            return line;
        }
        String datePrefix = line.substring(0, 28);
        try {
            Date date = this.format.parse(datePrefix);
            EpochTime epochTime = EpochTime.fromMillisWithOffset(date.getTime(), EpochTime.extractOffsetId(datePrefix));
            this.epochEmitter.fire(epochTime);
            return line.subLine(30);
        }
        catch (ParseException e) {
            return line;
        }
    }
}

