/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog.internals;

import com.azul.gulp.Emitter;
import com.azul.jvm.codeprofile.KlassHistogram;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.zing.profilelog.ProfileHeader;
import com.azul.zing.profilelog.ProfiledInstruction;
import com.azul.zing.profilelog.internals.ProfileLineMatcher;
import java.util.ArrayList;

public final class ProfiledTypeCheckLineMatcher
extends ProfileLineMatcher<ProfiledInstruction.TypeCheck> {
    public ProfiledTypeCheckLineMatcher(Class<?> dataClass) {
        super(dataClass);
    }

    @Override
    protected void process(ProfileHeader header, ProfileLineMatcher.InputBuffer buffer, Emitter<ProfiledInstruction.TypeCheck> emitter) throws Exception {
        if (header.version >= 26) {
            this.processV26(buffer, emitter);
        } else {
            this.processV1(buffer, emitter);
        }
    }

    private void processV26(ProfileLineMatcher.InputBuffer buffer, Emitter<ProfiledInstruction.TypeCheck> emitter) {
        long profileId = buffer.readLong();
        int bci = buffer.readInt();
        int siteCount = buffer.readCount();
        int failCount = buffer.readCount();
        int overflowCount = buffer.readCount();
        ArrayList<PersistentKlassId> classIds = new ArrayList<PersistentKlassId>(4);
        ArrayList<Integer> classCounts = new ArrayList<Integer>(4);
        buffer.readListStart();
        while (!buffer.isListEnd()) {
            buffer.readListStart();
            classIds.add(PersistentKlassId.of(buffer.readInt()));
            classCounts.add(buffer.readCount());
            buffer.readListEnd();
        }
        buffer.readListEnd();
        emitter.fire(new ProfiledInstruction.TypeCheck(profileId, bci, siteCount, failCount, overflowCount, new KlassHistogram(classIds, classCounts)));
    }

    private void processV1(ProfileLineMatcher.InputBuffer buffer, Emitter<ProfiledInstruction.TypeCheck> emitter) {
        long methodId = buffer.readLong();
        int compileId = buffer.readInt();
        int bci = buffer.readInt();
        int siteCount = buffer.readCount();
        int failCount = buffer.readCount();
        int overflowCount = buffer.readCount();
        ArrayList<PersistentKlassId> classIds = new ArrayList<PersistentKlassId>(4);
        ArrayList<Integer> classCounts = new ArrayList<Integer>(4);
        buffer.readListStart();
        while (!buffer.isListEnd()) {
            buffer.readListStart();
            classIds.add(PersistentKlassId.of(buffer.readInt()));
            classCounts.add(buffer.readCount());
            buffer.readListEnd();
        }
        buffer.readListEnd();
        while (!buffer.isEol()) {
            classIds.add(PersistentKlassId.of(buffer.readInt()));
            classCounts.add(buffer.readCount());
        }
        emitter.fire(new ProfiledInstruction.TypeCheck(methodId, compileId, bci, siteCount, failCount, overflowCount, new KlassHistogram(classIds, classCounts)));
    }
}

