/*
 * Decompiled with CFR 0.152.
 */
package com.azul.zing.profilelog;

import com.azul.gulp.Gulp;
import com.azul.gulp.text.GulpText;
import com.azul.jvm.klass.PersistentKlassId;
import com.azul.jvm.klassloader.KlassLoaderId;
import com.azul.jvm.klassloader.KlassLoaderType;
import com.azul.jvm.time.EpochTime;
import com.azul.zing.profilelog.ProfileRecord;
import com.azul.zing.profilelog.ProfileVersion;
import com.azul.zing.profilelog.internals.ProfileReflectiveLineMatcher;
import java.util.Objects;

@GulpText.LineMatcher(value=ProfileReflectiveLineMatcher.class)
@ProfileRecord(value="ClassLoader")
public final class ProfiledClassLoader {
    @Gulp.Capture
    public EpochTime epochTime;
    public final KlassLoaderId id;
    public final KlassLoaderType loaderType;
    public final PersistentKlassId classId;

    @ProfileVersion(value=5)
    public ProfiledClassLoader(int id, KlassLoaderType loaderType, Integer classId) {
        this.id = KlassLoaderId.of(id);
        this.loaderType = loaderType;
        this.classId = classId == null ? null : PersistentKlassId.of(classId);
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof ProfiledClassLoader)) {
            return false;
        }
        ProfiledClassLoader that = (ProfiledClassLoader)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.classId, that.classId) && this.loaderType == that.loaderType;
    }

    public final String toString() {
        return "ClassLoader: " + this.id + " " + (Object)((Object)this.loaderType) + " " + this.classId;
    }
}

